/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle;

import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;

public class MagicParticlePacket {
    private final Color color;
    private final double posX;
    private final double posY;
    private final double posZ;

    public MagicParticlePacket(Color color, double posX, double posY, double posZ) {
        this.color = color;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, MagicParticlePacket.class, MagicParticlePacket::encode, MagicParticlePacket::decode, MagicParticlePacket::execute);
    }

    public static MagicParticlePacket decode(FriendlyByteBuf buf) {
        Color color = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return new MagicParticlePacket(color, posX, posY, posZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.addParticles(new Vec3(this.posX, this.posY, this.posZ), this.color);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void addParticles(Vec3 pos, Color color) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.1f, 0.0f).setLifetime(10).setSpin(0.4f).setScale(0.4f, 0.0f).setColor(color, color.darker()).enableNoClip().randomOffset((double)0.2f, (double)0.2f).randomMotion((double)0.01f, (double)0.01f).repeat((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 12);
            ParticleBuilders.create((RegistryObject)OrtusParticles.SMOKE_PARTICLE).setAlpha(0.05f, 0.0f).setLifetime(20).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, color.darker()).randomOffset((double)0.4f).enableNoClip().randomMotion((double)0.025f, (double)0.025f).repeat((Level)level, pos.f_82479_, pos.f_82480_, pos.f_82481_, 20);
        }
    }
}

