/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle;

import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;

public class BlockMistParticlePacket {
    private final Color color;
    private final int posX;
    private final int posY;
    private final int posZ;

    public BlockMistParticlePacket(Color color, int posX, int posY, int posZ) {
        this.color = color;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, BlockMistParticlePacket.class, BlockMistParticlePacket::encode, BlockMistParticlePacket::decode, BlockMistParticlePacket::execute);
    }

    public static BlockMistParticlePacket decode(FriendlyByteBuf buf) {
        Color color = new Color(buf.readInt(), buf.readInt(), buf.readInt());
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        return new BlockMistParticlePacket(color, posX, posY, posZ);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.addParticles(new BlockPos(this.posX, this.posY, this.posZ), this.color);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void addParticles(BlockPos pos, Color color) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.4f, 0.0f).setLifetime(20).setSpin(0.2f).setScale(0.3f, 0.0f).setColor(color, color).enableNoClip().randomOffset((double)0.1f, (double)0.1f).randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges((Level)level, pos, 4, new Direction[]{Direction.UP, Direction.DOWN});
            ParticleBuilders.create((RegistryObject)OrtusParticles.SMOKE_PARTICLE).setAlpha(0.2f, 0.0f).setLifetime(40).setSpin(0.1f).setScale(0.4f, 0.0f).setColor(color, color).randomOffset((double)0.2f).enableNoClip().randomMotion((double)0.001f, (double)0.001f).evenlyRepeatEdges((Level)level, pos, 6, new Direction[]{Direction.UP, Direction.DOWN});
        }
    }
}

