/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets;

import com.sammy.malum.common.capability.PlayerDataCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SyncMalumPlayerCapabilityDataPacket {
    private final UUID uuid;
    private final CompoundTag tag;

    public SyncMalumPlayerCapabilityDataPacket(UUID uuid, CompoundTag tag) {
        this.uuid = uuid;
        this.tag = tag;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SyncMalumPlayerCapabilityDataPacket.class, SyncMalumPlayerCapabilityDataPacket::encode, SyncMalumPlayerCapabilityDataPacket::decode, SyncMalumPlayerCapabilityDataPacket::execute);
    }

    public static SyncMalumPlayerCapabilityDataPacket decode(FriendlyByteBuf buf) {
        return new SyncMalumPlayerCapabilityDataPacket(buf.m_130259_(), buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.m_130079_(this.tag);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.syncData(this.uuid, this.tag);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void syncData(UUID uuid, CompoundTag tag) {
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(uuid);
            PlayerDataCapability.getCapability(player).ifPresent(c -> c.deserializeNBT(tag));
        }
    }
}

