/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets;

import com.sammy.malum.common.capability.LivingEntityDataCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SyncLivingCapabilityDataPacket {
    private final int entityId;
    private final CompoundTag tag;

    public SyncLivingCapabilityDataPacket(int entityId, CompoundTag tag) {
        this.entityId = entityId;
        this.tag = tag;
    }

    public static void register(SimpleChannel instance, int index) {
        instance.registerMessage(index, SyncLivingCapabilityDataPacket.class, SyncLivingCapabilityDataPacket::encode, SyncLivingCapabilityDataPacket::decode, SyncLivingCapabilityDataPacket::execute);
    }

    public static SyncLivingCapabilityDataPacket decode(FriendlyByteBuf buf) {
        return new SyncLivingCapabilityDataPacket(buf.readInt(), buf.m_130260_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130079_(this.tag);
    }

    public void execute(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientOnly.syncData(this.entityId, this.tag);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static class ClientOnly {
        public static void syncData(int entityId, CompoundTag tag) {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                LivingEntityDataCapability.getCapability(livingEntity).ifPresent(c -> c.deserializeNBT(tag));
            }
        }
    }
}

