/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.common.packets.particle.MagicParticlePacket;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.DamageSourceRegistry;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.item.IMalumEventResponderItem;
import com.sammy.ortus.helpers.ColorHelper;
import com.sammy.ortus.item.tools.OrtusSwordItem;
import com.sammy.ortus.setup.OrtusScreenParticles;
import com.sammy.ortus.systems.easing.Easing;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import com.sammy.ortus.systems.rendering.particle.screen.emitter.ItemParticleEmitter;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class TyrvingItem
extends OrtusSwordItem
implements IMalumEventResponderItem,
ItemParticleEmitter {
    public TyrvingItem(Tier material, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public void hurtEvent(LivingHurtEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (event.getSource().m_19387_()) {
            return;
        }
        if (attacker.f_19853_ instanceof ServerLevel) {
            float spiritCount = (float)SpiritHelper.getEntitySpiritCount(target) * 2.0f;
            if (target instanceof Player) {
                spiritCount = 4.0f;
            }
            if (target.m_6084_()) {
                target.f_19802_ = 0;
                target.m_6469_(DamageSourceRegistry.causeVoodooDamage((Entity)attacker), spiritCount);
            }
            attacker.f_19853_.m_5594_(null, target.m_142538_(), (SoundEvent)SoundRegistry.VOID_SLASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f + target.f_19853_.f_46441_.nextFloat() * 0.25f);
            PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> target), (Object)new MagicParticlePacket(SpiritTypeRegistry.ELDRITCH_SPIRIT_COLOR, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_()));
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void particleTick(ItemStack stack, float x, float y, ScreenParticle.RenderOrder renderOrder) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float gameTime = (float)level.m_46467_() + Minecraft.m_91087_().f_90991_.f_92518_;
        Color firstColor = SpiritTypeRegistry.ELDRITCH_SPIRIT_COLOR;
        Color secondColor = ColorHelper.darker((Color)SpiritTypeRegistry.ELDRITCH_SPIRIT_COLOR, (int)2);
        ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.STAR).setAlpha(0.06f, 0.0f).setLifetime(8).setScale((float)(0.75 + Math.sin(gameTime * 0.05f) * (double)0.15f), 0.0f).setColor(firstColor, secondColor).setColorCurveMultiplier(1.25f).randomOffset((double)0.05f).setSpinOffset(0.025f * gameTime % 6.28f).setSpin(0.0f, 1.0f).setSpinEasing(Easing.EXPO_IN_OUT).setAlphaEasing(Easing.QUINTIC_IN).overwriteRenderOrder(renderOrder).centerOnStack(stack, -2.0f, 2.0f).repeat((double)x, (double)y, 1).setScale((float)(0.75 - Math.sin(gameTime * 0.075f) * (double)0.15f), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.785f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1).setScale((float)((double)0.9f - Math.sin(gameTime * 0.1f) * (double)0.175f), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.8f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1);
        ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.STAR).setAlpha(0.05f, 0.0f).setLifetime(8).setScale((float)(0.75 + Math.sin((gameTime += 31.4f) * 0.05f) * 0.125), 0.0f).setColor(firstColor, secondColor).setColorCurveMultiplier(1.25f).randomOffset((double)0.05f).setSpinOffset(0.025f * gameTime % 6.28f).setAlphaEasing(Easing.QUINTIC_IN).overwriteRenderOrder(renderOrder).centerOnStack(stack, 3.0f, -3.0f).repeat((double)x, (double)y, 1).setScale((float)((double)0.85f - Math.sin(gameTime * 0.075f) * (double)0.15f), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.785f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1).setScale((float)((double)0.95f - Math.sin(gameTime * 0.1f) * (double)0.175f), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.8f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1);
    }
}

