/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.common.entity.spirit.SoulEntity;
import com.sammy.malum.common.item.spirit.SoulStaveItem;
import com.sammy.malum.core.systems.item.ISoulContainerItem;
import com.sammy.malum.core.systems.spirit.MalumEntitySpiritData;
import com.sammy.ortus.helpers.ItemHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SoulVialItem
extends BlockItem
implements ISoulContainerItem {
    public SoulVialItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public String m_5671_(ItemStack pStack) {
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_("soul_data")) {
            return "item.malum.filled_soul_vial";
        }
        return super.m_5671_(pStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag tag;
        if (pStack.m_41782_() && (tag = pStack.m_41783_()).m_128441_("soul_data")) {
            MalumEntitySpiritData data = MalumEntitySpiritData.load(tag);
            pTooltipComponents.add((Component)new TranslatableComponent("malum.spirit.description.stored_soul").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.addAll(data.createTooltip());
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel instanceof ServerLevel) {
            return this.fetchSoul(pPlayer, pUsedHand);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        InteractionResult result;
        if (pContext.m_43723_() != null && (result = this.fetchSoul(pContext.m_43723_(), pContext.m_43724_()).m_19089_()).equals((Object)InteractionResult.SUCCESS)) {
            return result;
        }
        return super.m_6225_(pContext);
    }

    protected boolean m_40610_(BlockPlaceContext pContext, BlockState pState) {
        ItemStack otherStack = pContext.m_43723_().m_21120_(pContext.m_43724_().equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (otherStack.m_41720_() instanceof SoulStaveItem) {
            return false;
        }
        return super.m_40610_(pContext, pState);
    }

    @Override
    public InteractionResultHolder<ItemStack> interactWithSoul(Player pPlayer, InteractionHand pHand, SoulEntity soul) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (!soul.spiritData.equals(MalumEntitySpiritData.EMPTY) && (!stack.m_41782_() || stack.m_41782_() && !stack.m_41784_().m_128441_("soul_data"))) {
            ItemStack split = stack.m_41620_(1);
            soul.spiritData.saveTo(split.m_41784_());
            soul.m_146870_();
            ItemHelper.giveItemToEntity((ItemStack)split, (LivingEntity)pPlayer);
            pPlayer.m_21011_(pHand, true);
            return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pHand));
        }
        return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pHand));
    }
}

