/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.spirit;

import com.sammy.malum.common.capability.PlayerDataCapability;
import com.sammy.malum.common.entity.spirit.SoulEntity;
import com.sammy.malum.core.systems.item.ISoulContainerItem;
import com.sammy.malum.core.systems.spirit.MalumEntitySpiritData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SoulStaveItem
extends Item
implements ISoulContainerItem {
    public SoulStaveItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public String m_5671_(ItemStack pStack) {
        if (pStack.m_41782_() && pStack.m_41783_().m_128441_("soul_data")) {
            return "item.malum.filled_soulwood_stave";
        }
        return super.m_5671_(pStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag tag;
        if (pStack.m_41782_() && (tag = pStack.m_41783_()).m_128441_("soul_data")) {
            MalumEntitySpiritData data = MalumEntitySpiritData.load(tag);
            pTooltipComponents.add((Component)new TranslatableComponent("malum.spirit.description.stored_soul").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.addAll(data.createTooltip());
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public InteractionResultHolder<ItemStack> interactWithSoul(Player pPlayer, InteractionHand pHand, SoulEntity soul) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        ItemStack otherStack = pPlayer.m_21120_(pHand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (otherStack.m_41720_() instanceof ISoulContainerItem) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!soul.spiritData.equals(MalumEntitySpiritData.EMPTY) && !stack.m_41784_().m_128441_("soul_data")) {
            soul.spiritData.saveTo(stack.m_41784_());
            soul.m_146870_();
            pPlayer.m_21011_(pHand, true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            PlayerDataCapability.getCapability(pPlayer).ifPresent(c -> {
                if (c.targetedSoulUUID != null) {
                    LivingEntity entity = (LivingEntity)serverLevel.m_8791_(c.targetedSoulUUID);
                    if (entity != null && entity.m_6084_()) {
                        pPlayer.m_6672_(pUsedHand);
                    }
                } else {
                    this.fetchSoul(pPlayer, pUsedHand);
                }
            });
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            player.m_36335_().m_41524_(pStack.m_41720_(), 40);
        }
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeCharged);
    }
}

