/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.ether;

import com.sammy.malum.common.item.ether.AbstractEtherItem;
import com.sammy.ortus.setup.OrtusScreenParticles;
import com.sammy.ortus.systems.easing.Easing;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import java.awt.Color;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtherTorchItem
extends AbstractEtherItem {
    protected final Block wallBlock;

    public EtherTorchItem(Block floorBlock, Block wallBlockIn, Item.Properties builder, boolean iridescent) {
        super(floorBlock, builder, iridescent);
        this.wallBlock = wallBlockIn;
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        BlockState blockstate = this.wallBlock.m_5573_(context);
        BlockState blockstate1 = null;
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.m_40614_().m_5573_(context) : blockstate;
            if (blockstate2 == null || !blockstate2.m_60710_((LevelReader)level, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && level.m_45752_(blockstate1, blockpos, CollisionContext.m_82749_()) ? blockstate1 : null;
    }

    public void m_6192_(Map<Block, Item> blockToItemMap, Item itemIn) {
        super.m_6192_(blockToItemMap, itemIn);
        blockToItemMap.put(this.wallBlock, itemIn);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        super.removeFromBlockToItemMap(blockToItemMap, itemIn);
        blockToItemMap.remove(this.wallBlock);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void particleTick(ItemStack stack, float x, float y, ScreenParticle.RenderOrder renderOrder) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float gameTime = (float)level.m_46467_() + Minecraft.m_91087_().f_90991_.f_92518_;
        AbstractEtherItem etherItem = (AbstractEtherItem)stack.m_41720_();
        Color firstColor = new Color(etherItem.getFirstColor(stack));
        Color secondColor = new Color(etherItem.getSecondColor(stack));
        float alphaMultiplier = etherItem.iridescent ? 1.5f : 1.0f;
        ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.STAR).setAlpha(0.11f * alphaMultiplier, 0.0f).setLifetime(7).setScale((float)(0.75 + Math.sin(gameTime * 0.05f) * 0.125), 0.0f).setColor(firstColor, secondColor).setColorCurveMultiplier(1.25f).randomOffset((double)0.05f).setSpinOffset(0.025f * gameTime % 6.28f).setSpin(0.0f, 1.0f).setSpinEasing(Easing.EXPO_IN_OUT).setAlphaEasing(Easing.QUINTIC_IN).overwriteRenderOrder(renderOrder).centerOnStack(stack, 0.0f, -1.0f).repeat((double)x, (double)y, 1).setScale((float)(0.75 - Math.sin(gameTime * 0.075f) * 0.125), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.785f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1);
    }
}

