/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.equipment.curios;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.equipment.curios.MalumCurioItem;
import com.sammy.malum.core.setup.content.AttributeRegistry;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.systems.item.IMalumEventResponderItem;
import com.sammy.ortus.helpers.ColorHelper;
import com.sammy.ortus.setup.OrtusAttributes;
import com.sammy.ortus.setup.OrtusScreenParticles;
import com.sammy.ortus.systems.easing.Easing;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import com.sammy.ortus.systems.rendering.particle.screen.emitter.ItemParticleEmitter;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CurioMagebaneBelt
extends MalumCurioItem
implements IMalumEventResponderItem,
ItemParticleEmitter {
    public CurioMagebaneBelt(Item.Properties builder) {
        super(builder);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        map.put((Object)((Attribute)OrtusAttributes.MAGIC_RESISTANCE.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Curio magic resistance", 2.0, AttributeModifier.Operation.ADDITION));
        map.put((Object)((Attribute)AttributeRegistry.SOUL_WARD_CAP.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION));
        return map;
    }

    @Override
    public boolean isOrnate() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void particleTick(ItemStack stack, float x, float y, ScreenParticle.RenderOrder renderOrder) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float gameTime = (float)level.m_46467_() + Minecraft.m_91087_().f_90991_.f_92518_;
        Color firstColor = SpiritTypeRegistry.ELDRITCH_SPIRIT_COLOR;
        Color secondColor = ColorHelper.darker((Color)SpiritTypeRegistry.ELDRITCH_SPIRIT_COLOR, (int)2);
        ParticleBuilders.create((ScreenParticleType)OrtusScreenParticles.STAR).setAlpha(0.09f, 0.0f).setLifetime(8).setScale((float)((double)0.85f + Math.sin(gameTime * 0.05f) * 0.125), 0.0f).setColor(firstColor, secondColor).setColorCurveMultiplier(1.25f).randomOffset((double)0.05f).setSpinOffset(0.025f * gameTime % 6.28f).setSpin(0.0f, 1.0f).setSpinEasing(Easing.EXPO_IN_OUT).setAlphaEasing(Easing.QUINTIC_IN).overwriteRenderOrder(renderOrder).centerOnStack(stack, -2.0f, 2.0f).repeat((double)x, (double)y, 1).setScale((float)((double)0.85f - Math.sin(gameTime * 0.075f) * (double)0.15f), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.785f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1).setScale((float)((double)0.95f - Math.sin(gameTime * 0.1f) * (double)0.175f), 0.0f).setColor(secondColor, firstColor).setSpinOffset(0.8f - 0.01f * gameTime % 6.28f).repeat((double)x, (double)y, 1);
    }
}

