/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.spirit;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.AttributeRegistry;
import com.sammy.malum.core.setup.content.entity.EntityRegistry;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpiritItemEntity
extends FloatingItemEntity {
    public UUID ownerUUID;
    public LivingEntity owner;

    public SpiritItemEntity(Level level) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.NATURAL_SPIRIT.get()), level);
        this.maxAge = 4000;
    }

    public SpiritItemEntity(Level level, UUID ownerUUID, ItemStack stack, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.NATURAL_SPIRIT.get()), level);
        this.setOwner(ownerUUID);
        this.setItem(stack);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(velX, velY, velZ);
        this.maxAge = 800;
    }

    public float getRange() {
        return this.f_19853_.m_45786_((Entity)this) ? (float)this.range : (float)this.range * 5.0f;
    }

    public void setOwner(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.updateOwner();
    }

    public void updateOwner() {
        if (!this.f_19853_.f_46443_) {
            this.owner = (LivingEntity)((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID);
            if (this.owner != null) {
                this.range = (int)this.owner.m_21133_((Attribute)AttributeRegistry.SPIRIT_REACH.get());
            }
        }
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        SpiritHelper.spawnSpiritParticles(this.f_19853_, x, y, z, this.color, this.endColor);
    }

    @Override
    public void move() {
        float friction = 0.94f;
        this.m_20256_(this.m_20184_().m_82542_((double)friction, (double)friction, (double)friction));
        float range = this.getRange();
        if (this.owner == null || !this.owner.m_6084_()) {
            Player playerEntity;
            if (this.f_19853_.m_46467_() % 40L == 0L && (playerEntity = this.f_19853_.m_45930_((Entity)this, (double)(range * 5.0f))) != null) {
                this.setOwner(playerEntity.m_142081_());
            }
            return;
        }
        Vec3 desiredLocation = this.owner.m_20182_().m_82520_(0.0, (double)(this.owner.m_20206_() / 3.0f), 0.0);
        float distance = (float)this.m_20238_(desiredLocation);
        float velocity = Mth.m_14179_((float)(Math.min(this.moveTime, 10.0f) / 10.0f), (float)0.05f, (float)(0.4f + range * 0.075f));
        if (this.moveTime != 0.0f || distance < range) {
            this.moveTime += 1.0f;
            Vec3 desiredMotion = desiredLocation.m_82546_(this.m_20182_()).m_82541_().m_82542_((double)velocity, (double)velocity, (double)velocity);
            float easing = 0.01f;
            float xMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82479_, (double)desiredMotion.f_82479_);
            float yMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82480_, (double)desiredMotion.f_82480_);
            float zMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82481_, (double)desiredMotion.f_82481_);
            Vec3 resultingMotion = new Vec3((double)xMotion, (double)yMotion, (double)zMotion);
            this.m_20256_(resultingMotion);
        }
        if (distance < 0.4f && this.m_6084_()) {
            ItemStack stack = this.getItem();
            SpiritHarvestHandler.pickupSpirit(stack, this.owner);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.ownerUUID != null) {
            compound.m_128362_("ownerUUID", this.ownerUUID);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ownerUUID")) {
            this.setOwner(compound.m_128342_("ownerUUID"));
        }
    }
}

