/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.spirit;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.AttributeRegistry;
import com.sammy.malum.core.setup.content.entity.EntityRegistry;
import com.sammy.malum.core.systems.spirit.MalumEntitySpiritData;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoulEntity
extends FloatingEntity {
    public UUID thiefUUID;
    public MalumEntitySpiritData spiritData = MalumEntitySpiritData.EMPTY;
    public LivingEntity thief;

    public SoulEntity(Level level) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.NATURAL_SOUL.get()), level);
        this.maxAge = 2000;
        this.range = 8;
    }

    public SoulEntity(Level level, MalumEntitySpiritData spiritData, UUID ownerUUID, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.NATURAL_SOUL.get()), level);
        this.spiritData = spiritData;
        if (!spiritData.equals(MalumEntitySpiritData.EMPTY)) {
            this.color = spiritData.primaryType.color;
            this.m_20088_().m_135381_(DATA_COLOR, (Object)this.color.getRGB());
            this.endColor = spiritData.primaryType.endColor;
            this.m_20088_().m_135381_(DATA_END_COLOR, (Object)this.endColor.getRGB());
        }
        this.range = 8;
        this.setThief(ownerUUID);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(velX, velY, velZ);
        this.maxAge = 600;
    }

    public void setThief(UUID ownerUUID) {
        this.thiefUUID = ownerUUID;
        this.updateThief();
    }

    public void updateThief() {
        if (!this.f_19853_.f_46443_) {
            this.thief = (LivingEntity)((ServerLevel)this.f_19853_).m_8791_(this.thiefUUID);
            if (this.thief != null) {
                this.range = (int)this.thief.m_21133_((Attribute)AttributeRegistry.SPIRIT_REACH.get());
            }
        }
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        Vec3 motion = this.m_20184_();
        Vec3 norm = motion.m_82541_().m_82490_((double)0.025f);
        for (int i = 0; i < 4; ++i) {
            double lerpX = Mth.m_14139_((double)((float)i / 4.0f), (double)(x - motion.f_82479_), (double)x);
            double lerpY = Mth.m_14139_((double)((float)i / 4.0f), (double)(y - motion.f_82480_), (double)y);
            double lerpZ = Mth.m_14139_((double)((float)i / 4.0f), (double)(z - motion.f_82481_), (double)z);
            SpiritHelper.spawnSoulParticles(this.f_19853_, lerpX, lerpY, lerpZ, 0.25f, 1.0f, norm, this.color, this.endColor);
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        if (pReason.equals((Object)Entity.RemovalReason.KILLED)) {
            SpiritHelper.createSpiritsFromSoul(this.spiritData, this.f_19853_, this.m_20182_(), this.thief);
        }
        super.m_142687_(pReason);
    }

    @Override
    public void move() {
        boolean below;
        this.m_20256_(this.m_20184_().m_82542_((double)0.95f, (double)0.97f, (double)0.95f));
        if (this.thief == null || !this.thief.m_6084_()) {
            Player playerEntity;
            if (this.f_19853_.m_46467_() % 40L == 0L && (playerEntity = this.f_19853_.m_45930_((Entity)this, (double)((float)this.range * 5.0f))) != null) {
                this.setThief(playerEntity.m_142081_());
            }
            return;
        }
        float sine = Mth.m_14031_((float)((float)this.f_19853_.m_46467_() * 0.05f)) * 0.2f;
        Vec3 desiredLocation = this.thief.m_20182_().m_82520_(0.0, (double)(this.thief.m_20206_() / 4.0f), 0.0).m_82520_((double)(-sine), (double)sine, (double)(-sine));
        float distance = (float)this.m_20238_(desiredLocation);
        float velocity = Mth.m_14179_((float)(Math.min(this.moveTime, 20.0f) / 20.0f), (float)0.1f, (float)(0.05f + (float)this.range * 0.025f));
        if (distance > 2.0f) {
            this.moveTime += 1.0f;
            Vec3 desiredMotion = desiredLocation.m_82546_(this.m_20182_()).m_82541_().m_82542_((double)velocity, (double)velocity, (double)velocity).m_82520_(0.0, (double)0.075f, 0.0);
            float easing = 0.01f;
            float xMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82479_, (double)desiredMotion.f_82479_);
            float yMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82480_, (double)desiredMotion.f_82480_);
            float zMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82481_, (double)desiredMotion.f_82481_);
            Vec3 resultingMotion = new Vec3((double)xMotion, (double)yMotion, (double)zMotion);
            this.m_20256_(resultingMotion);
            return;
        }
        boolean above = !this.f_19853_.m_45772_(this.m_142469_().m_82386_(0.0, 1.5, 0.0));
        boolean bl = below = !this.f_19853_.m_45772_(this.m_142469_().m_82386_(0.0, -2.0, 0.0));
        if (above && below) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.002f, 0.0));
            return;
        }
        if (below) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.003f, 0.0));
        }
        if (above || !below) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.0015f, 0.0));
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.spiritData.equals(MalumEntitySpiritData.EMPTY)) {
            this.spiritData.saveTo(compound);
        }
        if (this.thiefUUID != null) {
            compound.m_128362_("thiefUUID", this.thiefUUID);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.spiritData = MalumEntitySpiritData.load(compound);
        if (compound.m_128441_("thiefUUID")) {
            this.setThief(compound.m_128342_("thiefUUID"));
        }
    }
}

