/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.spirit;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import com.sammy.malum.core.setup.content.entity.EntityRegistry;
import com.sammy.malum.core.systems.item.IFloatingGlowItem;
import com.sammy.ortus.helpers.ColorHelper;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MirrorItemEntity
extends FloatingItemEntity {
    public Direction cachedDirection;
    public Direction direction;
    public BlockPos cachedBlockPos;
    public float desiredMoveTime = 1.0f;

    public MirrorItemEntity(Level level) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.MIRROR_ITEM.get()), level);
        this.maxAge = 4000;
        this.direction = Direction.NORTH;
        this.moveTime = 1.0f;
    }

    public MirrorItemEntity(Level level, Direction direction, ItemStack stack, BlockPos pos) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.MIRROR_ITEM.get()), level);
        this.direction = direction;
        this.setItem(stack);
        this.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.25f, (float)pos.m_123343_() + 0.5f);
        this.maxAge = 4000;
        this.moveTime = 1.0f;
        float multiplier = 0.02f;
        this.m_20334_((float)direction.m_122429_() * multiplier, (float)direction.m_122430_() * multiplier, (float)direction.m_122431_() * multiplier);
    }

    @Override
    public void setItem(ItemStack pStack) {
        if (!(pStack.m_41720_() instanceof IFloatingGlowItem)) {
            this.setColor(ColorHelper.brighter((Color)SpiritTypeRegistry.ARCANE_SPIRIT_COLOR, (int)2), SpiritTypeRegistry.ARCANE_SPIRIT.endColor);
        }
        super.setItem(pStack);
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        SpiritHelper.spawnSpiritParticles(this.f_19853_, x, y, z, 1.5f, Vec3.f_82478_, this.color, this.endColor);
    }

    @Override
    public void move() {
        if (this.moveTime < this.desiredMoveTime) {
            this.moveTime += 0.1f;
        }
        if (this.moveTime > this.desiredMoveTime) {
            this.moveTime -= 0.1f;
        }
        if (this.cachedBlockPos != this.m_142538_() || this.f_19853_.m_46467_() % 10L == 0L) {
            this.cachedBlockPos = this.m_142538_();
            BlockPos ahead = this.cachedBlockPos.m_5484_(this.direction, 1);
            BlockState state = this.f_19853_.m_8055_(ahead);
            this.desiredMoveTime = state.m_60783_((BlockGetter)this.f_19853_, ahead, this.direction) ? 0.0f : 1.0f;
        }
        if (this.cachedDirection != this.direction) {
            this.cachedDirection = this.direction;
        }
        float multiplier = 0.02f * this.moveTime;
        this.m_20334_((float)this.direction.m_122429_() * multiplier, (float)this.direction.m_122430_() * multiplier, (float)this.direction.m_122431_() * multiplier);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128359_("direction", this.direction.toString());
        compound.m_128350_("desiredMoveTime", this.desiredMoveTime);
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        this.cachedDirection = this.direction = Direction.m_122402_((String)compound.m_128461_("direction"));
        this.desiredMoveTime = compound.m_128457_("desiredMoveTime");
        super.m_7378_(compound);
    }
}

