/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.boomerang;

import com.sammy.malum.common.item.tools.MalumScytheItem;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.entity.EntityRegistry;
import com.sammy.malum.core.setup.content.item.MalumEnchantments;
import com.sammy.ortus.helpers.ItemHelper;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class ScytheBoomerangEntity
extends ThrowableItemProjectile {
    public static final EntityDataAccessor<ItemStack> SCYTHE = SynchedEntityData.m_135353_(ScytheBoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public ItemStack scythe;
    public UUID f_37244_;
    public Player owner;
    public int slot;
    public float damage;
    public int age;
    public int returnAge = 8;
    public boolean returning;

    public ScytheBoomerangEntity(Level level) {
        super((EntityType)EntityRegistry.SCYTHE_BOOMERANG.get(), level);
        this.f_19794_ = false;
    }

    public Player getScytheOwner() {
        if (this.owner == null && !this.f_19853_.f_46443_) {
            this.owner = (Player)((ServerLevel)this.f_19853_).m_8791_(this.f_37244_);
        }
        return this.owner;
    }

    public void setData(float damage, UUID ownerUUID, int slot, ItemStack scythe) {
        this.damage = damage;
        this.f_37244_ = ownerUUID;
        this.slot = slot;
        this.scythe = scythe;
    }

    public void m_37251_(Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.m_14031_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, innacuracy);
        Vec3 vec3 = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, 0.0, vec3.f_82481_));
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.returning = true;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        DamageSource source = DamageSource.m_19340_((Entity)this, (LivingEntity)this.getScytheOwner());
        Entity entity = p_213868_1_.m_82443_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (entity.equals((Object)this.owner)) {
            return;
        }
        boolean success = entity.m_6469_(source, this.damage);
        if (success) {
            if (!this.f_19853_.f_46443_ && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.scythe.m_41622_(1, (LivingEntity)this.getScytheOwner(), e -> this.m_142687_(Entity.RemovalReason.KILLED));
                ItemHelper.applyEnchantments((LivingEntity)this.owner, (Entity)livingentity, (ItemStack)this.scythe);
                int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.scythe);
                if (i > 0) {
                    livingentity.m_20254_(i * 4);
                }
            }
            this.returnAge += 4;
            entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)SoundRegistry.SCYTHE_CUT.get(), entity.m_5720_(), 1.0f, 0.9f + entity.f_19853_.f_46441_.nextFloat() * 0.2f);
        }
        super.m_5790_(p_213868_1_);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        if (this.f_19853_.f_46443_ && !this.m_20071_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.m_7846_()) > 0) {
            Vec3 vector = new Vec3(this.m_20208_(0.7), this.m_20187_(), this.m_20262_(0.7));
            if (this.scythe.m_41720_() instanceof MalumScytheItem) {
                Random random = new Random();
                float rotation = random.nextFloat();
                vector = new Vec3(Math.cos(this.age) * (double)0.8f + this.m_20185_(), this.m_20227_(0.1), Math.sin(this.age) * (double)0.8f + this.m_20189_());
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, Math.cos((float)this.age + rotation * 2.0f - 1.0f) * (double)0.8f + this.m_20185_(), vector.f_82480_, Math.sin((float)this.age + rotation * 2.0f - 1.0f) * (double)0.8f + this.m_20189_(), 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, Math.cos((float)this.age + rotation * 2.0f - 1.0f) * (double)0.8f + this.m_20185_(), vector.f_82480_, Math.sin((float)this.age + rotation * 2.0f - 1.0f) * (double)0.8f + this.m_20189_(), 0.0, 0.0, 0.0);
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, vector.f_82479_, vector.f_82480_, vector.f_82481_, 0.0, 0.0, 0.0);
        }
        if (!this.f_19853_.f_46443_) {
            Player playerEntity = this.getScytheOwner();
            if (playerEntity == null || !playerEntity.m_6084_()) {
                ItemEntity entityitem = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.scythe);
                entityitem.m_32010_(40);
                entityitem.m_20256_(entityitem.m_20184_().m_82542_(0.0, 1.0, 0.0));
                this.f_19853_.m_7967_((Entity)entityitem);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (this.age % 3 == 0) {
                this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.25f);
            }
            if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
                Vec3 vector3d = this.m_20184_();
                this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
            if (this.age > this.returnAge) {
                this.returning = true;
            }
            if (this.returning) {
                this.f_19794_ = true;
                Vec3 ownerPos = playerEntity.m_20182_().m_82520_(0.0, 1.0, 0.0);
                Vec3 motion = ownerPos.m_82546_(this.m_20182_());
                this.m_20256_(motion.m_82541_().m_82490_(0.75));
            }
            float distance = this.m_20270_((Entity)playerEntity);
            if (this.age > 8 && distance < 3.0f && this.m_6084_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)this.scythe, (int)this.slot);
                if (!playerEntity.m_7500_()) {
                    int cooldown = 100 - 25 * (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)MalumEnchantments.REBOUND.get()), (ItemStack)this.scythe) - 1);
                    playerEntity.m_36335_().m_41524_(this.scythe.m_41720_(), cooldown);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("scythe", (Tag)this.scythe.serializeNBT());
        if (this.f_37244_ != null) {
            compound.m_128362_("ownerUUID", this.f_37244_);
        }
        compound.m_128405_("slot", this.slot);
        compound.m_128350_("damage", this.damage);
        compound.m_128405_("age", this.age);
        compound.m_128379_("returning", this.returning);
        compound.m_128405_("returnAge", this.returnAge);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("scythe")) {
            this.scythe = ItemStack.m_41712_((CompoundTag)compound.m_128469_("scythe"));
        }
        this.f_19804_.m_135381_(SCYTHE, (Object)this.scythe);
        if (compound.m_128441_("ownerUUID")) {
            this.f_37244_ = compound.m_128342_("ownerUUID");
            this.owner = this.getScytheOwner();
        }
        this.slot = compound.m_128451_("slot");
        this.damage = compound.m_128457_("damage");
        this.age = compound.m_128451_("age");
        this.returning = compound.m_128471_("returning");
        this.returnAge = compound.m_128451_("returnAge");
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6143_() {
        return 4.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCYTHE, (Object)ItemStack.f_41583_);
    }

    protected Item m_7881_() {
        if (this.scythe == null) {
            this.scythe = (ItemStack)this.f_19804_.m_135370_(SCYTHE);
        }
        return this.scythe.m_41720_();
    }

    public ItemStack m_7846_() {
        if (this.scythe == null) {
            this.scythe = (ItemStack)this.f_19804_.m_135370_(SCYTHE);
        }
        return this.scythe;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

