/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.malum.core.systems.item.IFloatingGlowItem;
import java.awt.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FloatingItemEntity
extends FloatingEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public ItemStack itemStack = ItemStack.f_41583_;

    public FloatingItemEntity(EntityType<? extends FloatingEntity> type, Level level) {
        super(type, level);
    }

    public void setItem(ItemStack pStack) {
        Item item = pStack.m_41720_();
        if (item instanceof IFloatingGlowItem) {
            IFloatingGlowItem glow = (IFloatingGlowItem)item;
            this.setColor(glow.getColor(), glow.getEndColor());
        }
        if (!pStack.m_150930_(this.getDefaultItem()) || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)pStack);
        }
    }

    public void setColor(Color color, Color endColor) {
        this.color = color;
        this.m_20088_().m_135381_(DATA_COLOR, (Object)color.getRGB());
        this.endColor = endColor;
        this.m_20088_().m_135381_(DATA_END_COLOR, (Object)endColor.getRGB());
    }

    @Override
    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        super.m_8097_();
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_ITEM_STACK.equals(pKey)) {
            this.itemStack = (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
        }
        super.m_7350_(pKey);
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    protected Item getDefaultItem() {
        return (Item)ItemRegistry.SACRED_SPIRIT.get();
    }

    public ItemStack getItem() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            pCompound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.setItem(itemstack);
    }
}

