/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import com.sammy.malum.core.setup.content.SpiritTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class FloatingEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(FloatingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_END_COLOR = SynchedEntityData.m_135353_(FloatingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final ArrayList<Vec3> pastPositions = new ArrayList();
    public Color color = SpiritTypeRegistry.SACRED_SPIRIT_COLOR;
    public Color endColor;
    public int maxAge;
    public int age;
    public float moveTime;
    public int range;
    public float windUp;
    public final float hoverStart;

    public FloatingEntity(EntityType<? extends FloatingEntity> type, Level level) {
        super(type, level);
        this.endColor = SpiritTypeRegistry.SACRED_SPIRIT.endColor;
        this.range = 3;
        this.f_19794_ = false;
        this.hoverStart = (float)(Math.random() * Math.PI * 2.0);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_COLOR, (Object)SpiritTypeRegistry.SACRED_SPIRIT_COLOR.getRGB());
        this.m_20088_().m_135372_(DATA_END_COLOR, (Object)SpiritTypeRegistry.SACRED_SPIRIT.endColor.getRGB());
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("age", this.age);
        compound.m_128350_("moveTime", this.moveTime);
        compound.m_128405_("range", this.range);
        compound.m_128350_("windUp", this.windUp);
        compound.m_128405_("red", this.color.getRed());
        compound.m_128405_("green", this.color.getGreen());
        compound.m_128405_("blue", this.color.getBlue());
        compound.m_128405_("endRed", this.endColor.getRed());
        compound.m_128405_("endGreen", this.endColor.getGreen());
        compound.m_128405_("endBlue", this.endColor.getBlue());
    }

    public void m_7378_(CompoundTag compound) {
        this.age = compound.m_128451_("age");
        this.moveTime = compound.m_128457_("moveTime");
        int range = compound.m_128451_("range");
        if (range > 0) {
            this.range = range;
        }
        this.windUp = compound.m_128457_("windUp");
        this.color = new Color(compound.m_128451_("red"), compound.m_128451_("green"), compound.m_128451_("blue"));
        this.endColor = new Color(compound.m_128451_("endRed"), compound.m_128451_("endGreen"), compound.m_128451_("endBlue"));
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_COLOR.equals(pKey)) {
            this.color = new Color((Integer)this.f_19804_.m_135370_(DATA_COLOR));
        }
        if (DATA_END_COLOR.equals(pKey)) {
            this.endColor = new Color((Integer)this.f_19804_.m_135370_(DATA_END_COLOR));
        }
        super.m_7350_(pKey);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6075_();
        this.trackPastPositions();
        ++this.age;
        if (this.windUp < 1.0f) {
            this.windUp += 0.02f;
        }
        if (this.age > this.maxAge) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_19853_.f_46443_) {
            double x = this.m_20185_();
            double y = this.m_20186_() + (double)this.getYOffset(0.0f) + 0.25;
            double z = this.m_20189_();
            this.spawnParticles(x, y, z);
        } else {
            this.move();
        }
    }

    public void trackPastPositions() {
        Vec3 position = this.m_20182_().m_82520_(0.0, (double)(this.getYOffset(0.0f) + 0.25f), 0.0);
        if (!this.pastPositions.isEmpty()) {
            Vec3 latest = this.pastPositions.get(this.pastPositions.size() - 1);
            float distance = (float)latest.m_82554_(position);
            if (distance > 0.1f) {
                this.pastPositions.add(position);
            }
            int excess = this.pastPositions.size() - 1;
            ArrayList<Vec3> toRemove = new ArrayList<Vec3>();
            float efficiency = (float)((double)((float)excess * 0.12f) + Math.exp((float)Math.max(0, excess - 20) * 0.2f));
            float ratio = 0.3f;
            if (efficiency > 0.0f) {
                for (int i = 0; i < excess; ++i) {
                    Vec3 excessPosition = this.pastPositions.get(i);
                    Vec3 nextExcessPosition = this.pastPositions.get(i + 1);
                    this.pastPositions.set(i, excessPosition.m_165921_(nextExcessPosition, (double)Math.min(1.0f, ratio * (float)(excess - i) * (ratio + efficiency))));
                    float excessDistance = (float)excessPosition.m_82554_(nextExcessPosition);
                    if (!(excessDistance < 0.05f)) continue;
                    toRemove.add(this.pastPositions.get(i));
                }
                this.pastPositions.removeAll(toRemove);
            }
        } else {
            this.pastPositions.add(position);
        }
    }

    public void m_6075_() {
        BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockEntity blockentity;
            BlockPos blockpos = result.m_82425_();
            BlockState blockstate = this.f_19853_.m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
            } else if (blockstate.m_60713_(Blocks.f_50446_) && (blockentity = this.f_19853_.m_7702_(blockpos)) instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
            }
        }
        this.m_20101_();
        Vec3 movement = this.m_20184_();
        double nextX = this.m_20185_() + movement.f_82479_;
        double nextY = this.m_20186_() + movement.f_82480_;
        double nextZ = this.m_20189_() + movement.f_82481_;
        double distance = movement.m_165924_();
        this.m_146926_(FloatingEntity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)movement.f_82480_, (double)distance) * 57.2957763671875)));
        this.m_146922_(FloatingEntity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)movement.f_82479_, (double)movement.f_82481_) * 57.2957763671875)));
        this.m_6034_(nextX, nextY, nextZ);
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    public void spawnParticles(double x, double y, double z) {
    }

    public void move() {
    }

    public float getYOffset(float partialTicks) {
        return Mth.m_14031_((float)(((float)this.age + partialTicks) / 20.0f + this.hoverStart)) * 0.1f + 0.1f;
    }

    public float getRotation(float partialTicks) {
        return ((float)this.age + partialTicks) / 20.0f + this.hoverStart;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return true;
    }
}

