/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.capability;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.packets.SyncMalumPlayerCapabilityDataPacket;
import com.sammy.malum.core.setup.content.SpiritAffinityRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.spirit.MalumSpiritAffinity;
import com.sammy.ortus.systems.capability.OrtusCapability;
import com.sammy.ortus.systems.capability.OrtusCapabilityProvider;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;

public class PlayerDataCapability
implements OrtusCapability {
    public static Capability<PlayerDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerDataCapability>(){});
    public UUID targetedSoulUUID;
    public int targetedSoulId;
    public int soulFetchCooldown;
    public MalumSpiritAffinity affinity;
    public float soulWard;
    public float soulWardProgress;
    public float heartOfStone;
    public float heartOfStoneProgress;

    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            PlayerDataCapability capability = new PlayerDataCapability();
            event.addCapability(MalumMod.prefix("player_data"), (ICapabilityProvider)new OrtusCapabilityProvider(CAPABILITY, () -> capability));
        }
    }

    public static void playerJoin(EntityJoinWorldEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerDataCapability.syncSelf(serverPlayer);
        }
    }

    public static void syncPlayerCapability(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.f_19853_ instanceof ServerLevel) {
                PlayerDataCapability.syncTracking(player);
            }
        }
    }

    public static void playerClone(PlayerEvent.Clone event) {
        PlayerDataCapability originalCapability = (PlayerDataCapability)PlayerDataCapability.getCapability(event.getOriginal()).orElse((Object)new PlayerDataCapability());
        PlayerDataCapability capability = (PlayerDataCapability)PlayerDataCapability.getCapability(event.getPlayer()).orElse((Object)new PlayerDataCapability());
        capability.deserializeNBT(originalCapability.serializeNBT());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.targetedSoulUUID != null) {
            tag.m_128362_("targetedSoulUUID", this.targetedSoulUUID);
        }
        tag.m_128405_("targetedSoulId", this.targetedSoulId);
        tag.m_128405_("soulFetchCooldown", this.soulFetchCooldown);
        if (this.affinity != null) {
            tag.m_128359_("affinity", this.affinity.identifier);
        }
        tag.m_128350_("soulWard", this.soulWard);
        tag.m_128350_("soulWardProgress", this.soulWardProgress);
        tag.m_128350_("heartOfStone", this.heartOfStone);
        tag.m_128350_("heartOfStoneProgress", this.heartOfStoneProgress);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.affinity = SpiritAffinityRegistry.AFFINITIES.get(tag.m_128461_("affinity"));
        if (tag.m_128441_("targetedSoulUUID")) {
            this.targetedSoulUUID = tag.m_128342_("targetedSoulUUID");
        }
        this.targetedSoulId = tag.m_128451_("targetedSoulId");
        this.soulFetchCooldown = tag.m_128451_("soulFetchCooldown");
        this.soulWard = tag.m_128457_("soulWard");
        this.soulWardProgress = tag.m_128457_("soulWardProgress");
        this.heartOfStone = tag.m_128457_("heartOfStone");
        this.heartOfStoneProgress = tag.m_128451_("heartOfStoneProgress");
    }

    public static void syncSelf(ServerPlayer player) {
        PlayerDataCapability.sync((Player)player, PacketDistributor.PLAYER.with(() -> player));
    }

    public static void syncTrackingAndSelf(Player player) {
        PlayerDataCapability.sync(player, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }

    public static void syncTracking(Player player) {
        PlayerDataCapability.sync(player, PacketDistributor.TRACKING_ENTITY.with(() -> player));
    }

    public static void sync(Player player, PacketDistributor.PacketTarget target) {
        PlayerDataCapability.getCapability(player).ifPresent(c -> PacketRegistry.INSTANCE.send(target, (Object)new SyncMalumPlayerCapabilityDataPacket(player.m_142081_(), c.serializeNBT())));
    }

    public static LazyOptional<PlayerDataCapability> getCapability(Player player) {
        return player.getCapability(CAPABILITY);
    }
}

