/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.capability;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.packets.SyncLivingCapabilityDataPacket;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.spirit.MalumEntitySpiritData;
import com.sammy.ortus.systems.capability.OrtusCapability;
import com.sammy.ortus.systems.capability.OrtusCapabilityProvider;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;

public class LivingEntityDataCapability
implements OrtusCapability {
    public static Capability<LivingEntityDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LivingEntityDataCapability>(){});
    public MalumEntitySpiritData spiritData;
    public float soulHarvestProgress;
    public float exposedSoul;
    public boolean soulless;
    public boolean spawnerSpawned;
    public UUID ownerUUID;

    public float getPreviewProgress() {
        return this.soulless ? 10.0f : Math.min(10.0f, this.soulHarvestProgress);
    }

    public float getHarvestProgress() {
        return Math.max(0.0f, this.soulHarvestProgress - 10.0f);
    }

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            LivingEntityDataCapability capability = new LivingEntityDataCapability();
            event.addCapability(MalumMod.prefix("living_data"), (ICapabilityProvider)new OrtusCapabilityProvider(CAPABILITY, () -> capability));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.f_19853_ instanceof ServerLevel) {
                LivingEntityDataCapability.sync(livingEntity);
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("soulHarvestProgress", this.soulHarvestProgress);
        tag.m_128350_("exposedSoul", this.exposedSoul);
        tag.m_128379_("soulless", this.soulless);
        tag.m_128379_("spawnerSpawned", this.spawnerSpawned);
        if (this.ownerUUID != null) {
            tag.m_128362_("ownerUUID", this.ownerUUID);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.soulHarvestProgress = tag.m_128457_("soulHarvestProgress");
        this.exposedSoul = tag.m_128457_("exposedSoul");
        this.soulless = tag.m_128471_("soulless");
        this.spawnerSpawned = tag.m_128471_("spawnerSpawned");
        if (tag.m_128441_("ownerUUID")) {
            this.ownerUUID = tag.m_128342_("ownerUUID");
        }
    }

    public static void sync(LivingEntity entity) {
        LivingEntityDataCapability.getCapability(entity).ifPresent(c -> PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncLivingCapabilityDataPacket(entity.m_142049_(), c.serializeNBT())));
    }

    public static LazyOptional<LivingEntityDataCapability> getCapability(LivingEntity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static UUID getOwner(LivingEntity entity) {
        return ((LivingEntityDataCapability)entity.getCapability(LivingEntityDataCapability.CAPABILITY).orElse((Object)new LivingEntityDataCapability())).ownerUUID;
    }

    public static boolean isSoulless(LivingEntity entity) {
        return ((LivingEntityDataCapability)entity.getCapability(LivingEntityDataCapability.CAPABILITY).orElse((Object)new LivingEntityDataCapability())).soulless;
    }

    public static boolean hasSpiritData(LivingEntity entity) {
        return ((LivingEntityDataCapability)entity.getCapability(LivingEntityDataCapability.CAPABILITY).orElse((Object)new LivingEntityDataCapability())).spiritData != null;
    }
}

