/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.totem;

import com.sammy.malum.common.block.totem.TotemPoleBlock;
import com.sammy.malum.common.blockentity.totem.TotemBaseTileEntity;
import com.sammy.malum.common.packets.particle.BlockParticlePacket;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntity;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;

public class TotemPoleTileEntity
extends OrtusBlockEntity {
    public MalumSpiritType f_58855_;
    public int desiredColor;
    public int currentColor;
    public int baseLevel;
    public boolean corrupted;
    public Block logBlock;
    public Direction direction;

    public TotemPoleTileEntity(BlockEntityType<? extends TotemPoleTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.corrupted = ((TotemPoleBlock)state.m_60734_()).corrupted;
        this.logBlock = ((TotemPoleBlock)state.m_60734_()).logBlock.get();
        this.direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public TotemPoleTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemPoleTileEntity>)((BlockEntityType)BlockEntityRegistry.TOTEM_POLE.get()), pos, state);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).canPerformAction(ToolActions.AXE_STRIP) && this.f_58855_ != null) {
            if (this.f_58857_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            this.f_58857_.m_46597_(this.f_58858_, this.logBlock.m_49966_());
            PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new BlockParticlePacket(this.f_58855_.color, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()));
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.onUse(player, hand);
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.f_58855_ != null) {
            compound.m_128359_("type", this.f_58855_.identifier);
        }
        compound.m_128405_("desiredColor", this.desiredColor);
        compound.m_128405_("currentColor", this.currentColor);
        compound.m_128405_("baseLevel", this.baseLevel);
        compound.m_128379_("corrupted", this.corrupted);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("type")) {
            this.f_58855_ = SpiritHelper.getSpiritType(compound.m_128461_("type"));
        }
        this.desiredColor = compound.m_128451_("desiredColor");
        this.currentColor = compound.m_128451_("currentColor");
        this.baseLevel = compound.m_128451_("baseLevel");
        this.corrupted = compound.m_128471_("corrupted");
        super.m_142466_(compound);
    }

    public void tick() {
        if (this.currentColor > this.desiredColor) {
            --this.currentColor;
        }
        if (this.currentColor < this.desiredColor) {
            ++this.currentColor;
        }
        if (this.f_58857_.f_46443_ && this.f_58855_ != null && this.desiredColor != 0) {
            this.passiveParticles();
        }
    }

    public void create(MalumSpiritType type) {
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_ENGRAVE.get(), SoundSource.BLOCKS, 1.0f, Mth.m_14068_((Random)this.f_58857_.f_46441_, (float)0.9f, (float)1.1f));
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, Mth.m_14068_((Random)this.f_58857_.f_46441_, (float)0.9f, (float)1.1f));
        PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new BlockParticlePacket(type.color, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()));
        this.f_58855_ = type;
        this.currentColor = 10;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void riteStarting(int height) {
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * (float)height);
        PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new BlockParticlePacket(this.f_58855_.color, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_()));
        this.desiredColor = 10;
        this.baseLevel = this.f_58858_.m_123342_() - height;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void riteComplete() {
        this.desiredColor = 20;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void riteEnding() {
        this.desiredColor = 0;
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void onBreak() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos basePos = new BlockPos(this.f_58858_.m_123341_(), this.baseLevel, this.f_58858_.m_123343_());
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof TotemBaseTileEntity) {
            TotemBaseTileEntity base = (TotemBaseTileEntity)blockEntity;
            if (base.active) {
                base.endRite();
            }
        }
    }

    public void passiveParticles() {
        Color color = this.f_58855_.color;
        Color endColor = this.f_58855_.endColor;
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.06f, 0.0f).setLifetime(5).setSpin(0.2f).setScale(0.4f, 0.0f).setColor(color, endColor).setColorCurveMultiplier(2.0f).addMotion(0.0, (double)Mth.m_14068_((Random)this.f_58857_.f_46441_, (float)-0.03f, (float)0.03f), 0.0).enableNoClip().randomOffset((double)0.1f, (double)0.1f).randomMotion((double)0.01f, (double)0.01f).evenlyRepeatEdges(this.f_58857_, this.f_58858_, 1, new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH});
        ParticleBuilders.create((RegistryObject)OrtusParticles.SMOKE_PARTICLE).setAlpha(0.06f, 0.0f).setLifetime(10).setSpin(0.1f).setScale(0.6f, 0.0f).setColor(color, endColor).setColorCurveMultiplier(2.0f).addMotion(0.0, (double)Mth.m_14068_((Random)this.f_58857_.f_46441_, (float)-0.03f, (float)0.03f), 0.0).randomOffset((double)0.2f).enableNoClip().randomMotion((double)0.01f, (double)0.01f).evenlyRepeatEdges(this.f_58857_, this.f_58858_, 1, new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH});
    }
}

