/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.totem;

import com.sammy.malum.common.block.totem.TotemBaseBlock;
import com.sammy.malum.common.blockentity.totem.TotemPoleTileEntity;
import com.sammy.malum.common.packets.particle.TotemParticlePacket;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.SpiritRiteRegistry;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class TotemBaseTileEntity
extends OrtusBlockEntity {
    public MalumRiteType rite;
    public ArrayList<MalumSpiritType> spirits = new ArrayList();
    public ArrayList<BlockPos> poles = new ArrayList();
    public boolean active;
    public int progress;
    public int height;
    public boolean corrupted;
    public Direction direction;

    public TotemBaseTileEntity(BlockEntityType<? extends TotemBaseTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.corrupted = ((TotemBaseBlock)state.m_60734_()).corrupted;
    }

    public TotemBaseTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends TotemBaseTileEntity>)((BlockEntityType)BlockEntityRegistry.TOTEM_BASE.get()), pos, state);
    }

    public void tick() {
        if (this.rite != null) {
            ++this.progress;
            if (this.progress >= this.rite.interval(this.corrupted)) {
                this.rite.executeRite(this.f_58857_, this.f_58858_, this.height, this.corrupted);
                this.progress = 0;
                if (!this.f_58857_.f_46443_) {
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                }
            }
        } else if (this.active && !this.f_58857_.f_46443_) {
            --this.progress;
            if (this.progress <= 0) {
                ++this.height;
                BlockPos polePos = this.f_58858_.m_6630_(this.height);
                BlockEntity blockEntity = this.f_58857_.m_7702_(polePos);
                if (blockEntity instanceof TotemPoleTileEntity) {
                    TotemPoleTileEntity pole = (TotemPoleTileEntity)blockEntity;
                    this.addPole(pole);
                } else {
                    MalumRiteType rite = SpiritRiteRegistry.getRite(this.spirits);
                    if (rite == null) {
                        this.endRite();
                    } else {
                        this.completeRite(rite);
                        this.m_6596_();
                    }
                }
                this.progress = 20;
                BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
        }
    }

    public void onBreak() {
        if (!this.f_58857_.f_46443_) {
            this.poles.forEach(p -> {
                BlockEntity patt3613$temp = this.f_58857_.m_7702_(p);
                if (patt3613$temp instanceof TotemPoleTileEntity) {
                    TotemPoleTileEntity pole = (TotemPoleTileEntity)patt3613$temp;
                    pole.riteEnding();
                }
            });
            if (this.height > 1) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_CHARGE.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
                PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TotemParticlePacket(this.spirits.stream().map(s -> s.color).collect(Collectors.toCollection(ArrayList::new)), this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 1, this.f_58858_.m_123343_()));
            }
        }
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.active && this.rite == null) {
            return InteractionResult.FAIL;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.active) {
                this.endRite();
            } else {
                this.startRite();
            }
            BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
        player.m_21011_(InteractionHand.MAIN_HAND, true);
        return InteractionResult.SUCCESS;
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.rite != null) {
            compound.m_128359_("rite", this.rite.identifier);
        }
        compound.m_128405_("spiritCount", this.spirits.size());
        for (int i = 0; i < this.spirits.size(); ++i) {
            MalumSpiritType type = this.spirits.get(i);
            compound.m_128359_("spirit_" + i, type.identifier);
        }
        compound.m_128379_("active", this.active);
        compound.m_128405_("progress", this.progress);
        compound.m_128405_("height", this.height);
        compound.m_128379_("corrupted", this.corrupted);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        int i;
        this.rite = SpiritRiteRegistry.getRite(compound.m_128461_("rite"));
        int size = compound.m_128451_("spiritCount");
        this.spirits.clear();
        for (i = 0; i < size; ++i) {
            this.spirits.add(SpiritHelper.getSpiritType(compound.m_128461_("spirit_" + i)));
        }
        this.active = compound.m_128471_("active");
        this.progress = compound.m_128451_("progress");
        this.height = compound.m_128451_("height");
        this.corrupted = compound.m_128471_("corrupted");
        this.poles.clear();
        for (i = 1; i <= this.height; ++i) {
            this.poles.add(new BlockPos(this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + i, this.f_58858_.m_123343_()));
        }
        super.m_142466_(compound);
    }

    public void addPole(TotemPoleTileEntity pole) {
        Direction direction = (Direction)pole.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (this.poles.isEmpty()) {
            this.direction = direction;
        }
        if (pole.corrupted == this.corrupted && direction.equals((Object)this.direction) && pole.f_58855_ != null) {
            this.spirits.add(pole.f_58855_);
            this.poles.add(pole.m_58899_());
            pole.riteStarting(this.height);
        }
    }

    public void disableOtherRites(MalumRiteType rite) {
        int range = rite.range(this.corrupted);
        List totemBases = BlockHelper.getBlocks((BlockPos)this.f_58858_, (int)range, b -> this.f_58857_.m_7702_(b) instanceof TotemBaseTileEntity && !b.equals((Object)this.f_58858_)).stream().map(b -> (TotemBaseTileEntity)this.f_58857_.m_7702_(b)).collect(Collectors.toCollection(ArrayList::new));
        for (TotemBaseTileEntity blockEntity : totemBases) {
            if (!rite.equals(blockEntity.rite)) continue;
            blockEntity.endRite();
        }
    }

    public void completeRite(MalumRiteType rite) {
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_ACTIVATED.get(), SoundSource.BLOCKS, 1.0f, 0.75f + (float)this.height * 0.1f);
        PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TotemParticlePacket(this.spirits.stream().map(s -> s.color).collect(Collectors.toCollection(ArrayList::new)), this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 1, this.f_58858_.m_123343_()));
        this.poles.forEach(p -> {
            BlockEntity patt7780$temp = this.f_58857_.m_7702_(p);
            if (patt7780$temp instanceof TotemPoleTileEntity) {
                TotemPoleTileEntity pole = (TotemPoleTileEntity)patt7780$temp;
                pole.riteComplete();
            }
        });
        this.progress = 0;
        rite.executeRite(this.f_58857_, this.f_58858_, this.height, this.corrupted);
        if (rite.isInstant(this.corrupted)) {
            this.resetRite();
            return;
        }
        this.rite = rite;
        this.disableOtherRites(rite);
    }

    public void startRite() {
        this.resetValues();
        this.active = true;
    }

    public void endRite() {
        if (this.height > 1) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.TOTEM_CANCELLED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TotemParticlePacket(this.spirits.stream().map(s -> s.color).collect(Collectors.toCollection(ArrayList::new)), this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 1, this.f_58858_.m_123343_()));
        }
        this.resetRite();
    }

    public void resetRite() {
        this.poles.forEach(p -> {
            BlockEntity patt8834$temp = this.f_58857_.m_7702_(p);
            if (patt8834$temp instanceof TotemPoleTileEntity) {
                TotemPoleTileEntity pole = (TotemPoleTileEntity)patt8834$temp;
                pole.riteEnding();
            }
        });
        this.resetValues();
    }

    public void resetValues() {
        this.height = 0;
        this.rite = null;
        this.active = false;
        this.progress = 0;
        this.spirits.clear();
        this.poles.clear();
    }
}

