/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.tablet;

import com.sammy.malum.common.blockentity.tablet.TwistedTabletBlockEntity;
import com.sammy.ortus.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface ITabletTracker {
    public ArrayList<TwistedTabletBlockEntity> getTablets();

    public Set<BlockPos> getTabletPositions();

    default public int getLookupRange() {
        return 4;
    }

    default public void fetchTablets(Level level, BlockPos pos) {
        this.getTablets().clear();
        this.getTabletPositions().clear();
        int range = this.getLookupRange();
        ArrayList nearbyTablets = BlockHelper.getBlockEntities(TwistedTabletBlockEntity.class, (Level)level, (BlockPos)pos, (int)range);
        nearbyTablets = nearbyTablets.stream().filter(tabletBlockEntity -> {
            Direction direction = (Direction)tabletBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            BlockPos tabletPos = tabletBlockEntity.m_58899_();
            if (tabletPos.m_123343_() == pos.m_123343_() && tabletPos.m_123341_() == pos.m_123341_()) {
                return direction == (tabletPos.m_123342_() > pos.m_123342_() ? Direction.DOWN : Direction.UP);
            }
            if (tabletPos.m_123343_() == pos.m_123343_()) {
                return direction == (tabletPos.m_123341_() > pos.m_123341_() ? Direction.WEST : Direction.EAST);
            }
            if (tabletPos.m_123341_() == pos.m_123341_()) {
                return direction == (tabletPos.m_123343_() > pos.m_123343_() ? Direction.NORTH : Direction.SOUTH);
            }
            return false;
        }).collect(Collectors.toCollection(ArrayList::new));
        this.getTabletPositions().addAll(nearbyTablets.stream().map(BlockEntity::m_58899_).collect(Collectors.toList()));
        this.getTablets().addAll(nearbyTablets);
    }

    default public void saveTwistedTabletData(CompoundTag compound) {
        if (!this.getTabletPositions().isEmpty()) {
            CompoundTag twistedTabletTag = new CompoundTag();
            AtomicInteger tabletNumber = new AtomicInteger(0);
            twistedTabletTag.m_128405_("amount", this.getTabletPositions().size());
            this.getTabletPositions().forEach(pos -> BlockHelper.saveBlockPos((CompoundTag)twistedTabletTag, (BlockPos)pos, (String)("" + tabletNumber.getAndIncrement())));
            compound.m_128365_("twistedTabletData", (Tag)twistedTabletTag);
        }
    }

    default public void loadTwistedTabletData(Level level, CompoundTag compound) {
        if (compound.m_128441_("twistedTabletData")) {
            CompoundTag twistedTabletTag = compound.m_128469_("twistedTabletData");
            int amount = twistedTabletTag.m_128451_("amount");
            for (int i = 0; i < amount; ++i) {
                BlockEntity blockEntity;
                BlockPos pos = BlockHelper.loadBlockPos((CompoundTag)twistedTabletTag, (String)("" + i));
                if (level == null || !((blockEntity = level.m_7702_(pos)) instanceof TwistedTabletBlockEntity)) continue;
                TwistedTabletBlockEntity tabletBlockEntity = (TwistedTabletBlockEntity)blockEntity;
                this.getTabletPositions().add(pos);
                this.getTablets().add(tabletBlockEntity);
            }
        }
    }
}

