/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.storage;

import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntity;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class SpiritJarBlockEntity
extends OrtusBlockEntity {
    public MalumSpiritType f_58855_;
    public int count;

    public SpiritJarBlockEntity(BlockEntityType<? extends SpiritJarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritJarBlockEntity>)((BlockEntityType)BlockEntityRegistry.SPIRIT_JAR.get()), pos, state);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item instanceof MalumSpiritItem) {
            MalumSpiritItem spiritSplinterItem = (MalumSpiritItem)item;
            if (this.f_58855_ == null || this.f_58855_.equals(spiritSplinterItem.type)) {
                this.f_58855_ = spiritSplinterItem.type;
                this.count += heldItem.m_41613_();
                if (!player.f_19853_.f_46443_) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                } else {
                    this.spawnUseParticles(this.f_58857_, this.f_58858_, this.f_58855_);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (this.f_58855_ != null) {
            int max = player.m_6144_() ? 64 : 1;
            int count = Math.min(this.count, max);
            if (!player.f_19853_.f_46443_) {
                this.count -= count;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)this.f_58855_.getSplinterItem(), count));
                if (this.count == 0) {
                    this.f_58855_ = null;
                }
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            } else {
                this.spawnUseParticles(this.f_58857_, this.f_58858_, this.f_58855_);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onUse(player, hand);
    }

    public void onPlace(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.m_142466_(stack.m_41783_());
        }
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.f_58855_ != null) {
            compound.m_128359_("spirit", this.f_58855_.identifier);
        }
        compound.m_128405_("count", this.count);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        this.f_58855_ = compound.m_128441_("spirit") ? SpiritHelper.getSpiritType(compound.m_128461_("spirit")) : null;
        this.count = compound.m_128451_("count");
        super.m_142466_(compound);
    }

    public void tick() {
        if (this.f_58857_.f_46443_ && this.f_58855_ != null) {
            double x = (float)this.m_58899_().m_123341_() + 0.5f;
            double y = (double)((float)this.m_58899_().m_123342_() + 0.5f) + Math.sin((float)this.f_58857_.m_46467_() / 20.0f) * (double)0.2f;
            double z = (float)this.m_58899_().m_123343_() + 0.5f;
            SpiritHelper.spawnSpiritParticles(this.f_58857_, x, y, z, this.f_58855_.color, this.f_58855_.endColor);
        }
    }

    public void spawnUseParticles(Level level, BlockPos pos, MalumSpiritType type) {
        Color color = type.color;
        ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.15f, 0.0f).setLifetime(20).setScale(0.3f, 0.0f).setSpin(0.2f).randomMotion((double)0.02f).randomOffset((double)0.1f, (double)0.1f).setColor(color, color.darker()).enableNoClip().repeat(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f) + Math.sin((float)level.m_46467_() / 20.0f) * (double)0.2f, (double)((float)pos.m_123343_() + 0.5f), 10);
    }
}

