/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.storage;

import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.malum.core.systems.item.ISoulContainerItem;
import com.sammy.malum.core.systems.spirit.MalumEntitySpiritData;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.helpers.ItemHelper;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntityInventory;
import com.sammy.ortus.systems.multiblock.MultiBlockCoreEntity;
import com.sammy.ortus.systems.multiblock.MultiBlockStructure;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class PlinthCoreBlockEntity
extends MultiBlockCoreEntity {
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.SOULWOOD_PLINTH_COMPONENT.get()).m_49966_())});
    public OrtusBlockEntityInventory inventory;
    public MalumEntitySpiritData data;

    public PlinthCoreBlockEntity(BlockEntityType<? extends PlinthCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
    }

    public PlinthCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends PlinthCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.PLINTH.get()), STRUCTURE.get(), pos, state);
        this.inventory = new OrtusBlockEntityInventory(1, 64, s -> this.data == null){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((Level)PlinthCoreBlockEntity.this.f_58857_, (BlockPos)PlinthCoreBlockEntity.this.f_58858_);
            }
        };
    }

    protected void m_183515_(CompoundTag compound) {
        this.inventory.save(compound);
        if (this.data != null) {
            this.data.saveTo(compound);
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.inventory.load(compound);
        this.data = compound.m_128441_("soul_data") ? MalumEntitySpiritData.load(compound) : null;
        super.m_142466_(compound);
    }

    public MultiBlockStructure getStructure() {
        return STRUCTURE.get();
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ISoulContainerItem) {
            if (this.f_58857_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (this.data == null) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("soul_data")) {
                    this.data = MalumEntitySpiritData.load(stack.m_41783_());
                    if (stack.m_41613_() > 1) {
                        ItemStack split = stack.m_41620_(1);
                        split.m_41784_().m_128473_("soul_data");
                        ItemHelper.giveItemToEntity((ItemStack)split, (LivingEntity)player);
                    } else {
                        stack.m_41784_().m_128473_("soul_data");
                    }
                }
            } else if (!stack.m_41784_().m_128441_("soul_data")) {
                if (stack.m_41613_() > 1) {
                    ItemStack split = stack.m_41620_(1);
                    this.data.saveTo(split.m_41784_());
                    this.data = null;
                    ItemHelper.giveItemToEntity((ItemStack)split, (LivingEntity)player);
                } else {
                    this.data.saveTo(stack.m_41784_());
                    this.data = null;
                }
            }
            player.m_21011_(hand, true);
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            return InteractionResult.SUCCESS;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.inventory.interact(this.f_58857_, player, hand);
            return InteractionResult.SUCCESS;
        }
        return super.onUse(player, hand);
    }

    public void onBreak() {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        super.onBreak();
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            Item item = this.inventory.getStackInSlot(0).m_41720_();
            if (item instanceof MalumSpiritItem) {
                MalumSpiritItem item2 = (MalumSpiritItem)item;
                Vec3 pos = this.getItemPos();
                double x = pos.f_82479_;
                double y = pos.f_82480_ + Math.sin((float)this.f_58857_.m_46467_() / 20.0f) * (double)0.05f;
                double z = pos.f_82481_;
                SpiritHelper.spawnSpiritParticles(this.f_58857_, x, y, z, item2.type.color, item2.type.endColor);
            }
            if (this.data != null) {
                Vec3 pos = this.getItemPos();
                double x = pos.f_82479_;
                double y = pos.f_82480_ + Math.sin((float)this.f_58857_.m_46467_() / 20.0f) * (double)0.08f;
                double z = pos.f_82481_;
                SpiritHelper.spawnSoulParticles(this.f_58857_, x, y, z, 1.0f, 1.0f, Vec3.f_82478_, this.data.primaryType.color, this.data.primaryType.endColor);
            }
        }
    }

    public Vec3 getItemPos() {
        return DataHelper.fromBlockPos((BlockPos)this.m_58899_()).m_82549_(this.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, 2.0, 0.5);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

