/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.storage;

import com.sammy.malum.common.blockentity.altar.IAltarProvider;
import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.systems.blockentity.ItemHolderBlockEntity;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntityInventory;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemPedestalBlockEntity
extends ItemHolderBlockEntity
implements IAltarProvider {
    public ItemPedestalBlockEntity(BlockEntityType<? extends ItemPedestalBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemPedestalBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ItemPedestalBlockEntity>)((BlockEntityType)BlockEntityRegistry.ITEM_PEDESTAL.get()), pos, state);
        this.inventory = new OrtusBlockEntityInventory(1, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((Level)ItemPedestalBlockEntity.this.f_58857_, (BlockPos)ItemPedestalBlockEntity.this.f_58858_);
            }
        };
    }

    @Override
    public OrtusBlockEntityInventory getInventoryForAltar() {
        return this.inventory;
    }

    @Override
    public Vec3 getItemPosForAltar() {
        return this.getItemPos();
    }

    @Override
    public BlockPos getBlockPosForAltar() {
        return this.f_58858_;
    }

    public Vec3 getItemPos() {
        return DataHelper.fromBlockPos((BlockPos)this.m_58899_()).m_82549_(this.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, (double)1.1f, 0.5);
    }

    public void tick() {
        Item item;
        if (this.f_58857_.f_46443_ && (item = this.inventory.getStackInSlot(0).m_41720_()) instanceof MalumSpiritItem) {
            MalumSpiritItem item2 = (MalumSpiritItem)item;
            Vec3 pos = this.getItemPos();
            double x = pos.f_82479_;
            double y = pos.f_82480_ + Math.sin((float)this.f_58857_.m_46467_() / 20.0f) * (double)0.1f;
            double z = pos.f_82481_;
            SpiritHelper.spawnSpiritParticles(this.f_58857_, x, y, z, item2.type.color, item2.type.endColor);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

