/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.crucible;

import com.sammy.malum.common.blockentity.crucible.CrucibleSoundInstance;
import com.sammy.malum.common.blockentity.crucible.IAccelerationTarget;
import com.sammy.malum.common.blockentity.crucible.ICrucibleAccelerator;
import com.sammy.malum.common.blockentity.tablet.ITabletTracker;
import com.sammy.malum.common.blockentity.tablet.TwistedTabletBlockEntity;
import com.sammy.malum.common.item.impetus.ImpetusItem;
import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.common.packets.particle.altar.AltarConsumeParticlePacket;
import com.sammy.malum.common.packets.particle.altar.AltarCraftParticlePacket;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntityInventory;
import com.sammy.ortus.systems.multiblock.MultiBlockCoreEntity;
import com.sammy.ortus.systems.multiblock.MultiBlockStructure;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;

public class SpiritCrucibleCoreBlockEntity
extends MultiBlockCoreEntity
implements IAccelerationTarget,
ITabletTracker {
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.SPIRIT_CRUCIBLE_COMPONENT.get()).m_49966_())});
    public OrtusBlockEntityInventory inventory;
    public OrtusBlockEntityInventory spiritInventory;
    public SpiritFocusingRecipe focusingRecipe;
    public SpiritRepairRecipe repairRecipe;
    public boolean updateRecipe;
    public float spiritAmount;
    public float spiritSpin;
    public float speed;
    public float damageChance;
    public int maxDamage;
    public float progress;
    public int queuedCracks;
    public int crackTimer;
    public Set<BlockPos> tabletPositions = new HashSet<BlockPos>();
    public ArrayList<TwistedTabletBlockEntity> twistedTablets = new ArrayList();
    public TwistedTabletBlockEntity validTablet;
    public int tabletFetchCooldown;
    public ArrayList<BlockPos> acceleratorPositions = new ArrayList();
    public ArrayList<ICrucibleAccelerator> accelerators = new ArrayList();

    public SpiritCrucibleCoreBlockEntity(BlockEntityType<? extends SpiritCrucibleCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
        this.inventory = new OrtusBlockEntityInventory(1, 1, t -> !(t.m_41720_() instanceof MalumSpiritItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.updateRecipe = true;
                BlockHelper.updateAndNotifyState((Level)SpiritCrucibleCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCrucibleCoreBlockEntity.this.f_58858_);
            }
        };
        this.spiritInventory = new OrtusBlockEntityInventory(4, 64, t -> t.m_41720_() instanceof MalumSpiritItem){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritCrucibleCoreBlockEntity.this.updateRecipe = true;
                SpiritCrucibleCoreBlockEntity.this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.15f, (float)SpiritCrucibleCoreBlockEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((Level)SpiritCrucibleCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCrucibleCoreBlockEntity.this.f_58858_);
            }
        };
    }

    public SpiritCrucibleCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritCrucibleCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.SPIRIT_CRUCIBLE.get()), STRUCTURE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.spiritAmount != 0.0f) {
            compound.m_128350_("spiritAmount", this.spiritAmount);
        }
        if (this.progress != 0.0f) {
            compound.m_128350_("progress", this.progress);
        }
        if (this.speed != 0.0f) {
            compound.m_128350_("speed", this.speed);
        }
        if (this.damageChance != 0.0f) {
            compound.m_128350_("damageChance", this.damageChance);
        }
        if (this.maxDamage != 0) {
            compound.m_128405_("maxDamage", this.maxDamage);
        }
        if (this.queuedCracks != 0) {
            compound.m_128405_("queuedCracks", this.queuedCracks);
        }
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
        this.saveTwistedTabletData(compound);
        this.saveAcceleratorData(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.spiritAmount = compound.m_128457_("spiritAmount");
        this.progress = compound.m_128457_("progress");
        this.speed = compound.m_128457_("speed");
        this.damageChance = compound.m_128457_("damageChance");
        this.maxDamage = compound.m_128451_("maxDamage");
        this.queuedCracks = compound.m_128451_("queuedCracks");
        this.updateRecipe = true;
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        this.loadTwistedTabletData(this.f_58857_, compound);
        this.loadAcceleratorData(this.f_58857_, compound);
        super.m_142466_(compound);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack stack;
            this.fetchTablets(this.f_58857_, this.f_58858_.m_7494_());
            ItemStack heldStack = player.m_21205_();
            this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
            if (!(heldStack.m_41720_() instanceof MalumSpiritItem) && !(stack = this.inventory.interact(this.f_58857_, player, hand)).m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            this.spiritInventory.interact(this.f_58857_, player, hand);
            if (heldStack.m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.onUse(player, hand);
    }

    public void onBreak() {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        this.spiritInventory.dumpItems(this.f_58857_, this.f_58858_);
        super.onBreak();
    }

    @Override
    public void fetchTablets(Level level, BlockPos pos) {
        ITabletTracker.super.fetchTablets(level, pos);
        if (this.focusingRecipe == null && !this.getTablets().isEmpty()) {
            for (TwistedTabletBlockEntity tablet : this.getTablets()) {
                this.repairRecipe = SpiritRepairRecipe.getRecipe(level, this.inventory.getStackInSlot(0), tablet.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyStacks);
                if (this.repairRecipe == null) continue;
                this.validTablet = tablet;
                break;
            }
        } else {
            this.repairRecipe = null;
            this.validTablet = null;
        }
    }

    @Override
    public ArrayList<TwistedTabletBlockEntity> getTablets() {
        return this.twistedTablets;
    }

    @Override
    public Set<BlockPos> getTabletPositions() {
        return this.tabletPositions;
    }

    @Override
    public boolean canBeAccelerated() {
        return this.focusingRecipe != null;
    }

    @Override
    public ArrayList<ICrucibleAccelerator> getAccelerators() {
        return this.accelerators;
    }

    @Override
    public ArrayList<BlockPos> getAcceleratorPositions() {
        return this.acceleratorPositions;
    }

    @Override
    public int getLookupRange() {
        return 4;
    }

    public void tick() {
        this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (this.queuedCracks > 0) {
            ++this.crackTimer;
            if (this.crackTimer % 7 == 0) {
                float pitch = 0.95f + (float)(this.crackTimer - 8) * 0.015f + this.f_58857_.f_46441_.nextFloat() * 0.05f;
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.IMPETUS_CRACK.get(), SoundSource.BLOCKS, 0.7f, pitch);
                --this.queuedCracks;
                if (this.queuedCracks == 0) {
                    this.crackTimer = 0;
                }
            }
        }
        if (this.updateRecipe) {
            if (this.f_58857_.f_46443_ && this.focusingRecipe == null && this.repairRecipe == null) {
                CrucibleSoundInstance.playSound(this);
            }
            this.fetchTablets(this.f_58857_, this.f_58858_.m_7494_());
            this.focusingRecipe = SpiritFocusingRecipe.getRecipe(this.f_58857_, this.inventory.getStackInSlot(0), this.spiritInventory.nonEmptyStacks);
            this.updateRecipe = false;
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
        if (this.f_58857_.f_46443_) {
            this.spiritSpin = (float)((double)this.spiritSpin + (1.0 + Math.cos(Math.sin((float)this.f_58857_.m_46467_() * 0.1f))) * (double)(1.0f + this.speed * 0.1f));
            this.passiveParticles();
        } else {
            if (this.focusingRecipe != null) {
                if (!this.accelerators.isEmpty()) {
                    boolean canAccelerate = true;
                    for (ICrucibleAccelerator accelerator : this.accelerators) {
                        boolean canAcceleratorAccelerate = accelerator.canAccelerate();
                        if (canAcceleratorAccelerate) continue;
                        canAccelerate = false;
                    }
                    if (!canAccelerate) {
                        this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
                        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
                    }
                }
            } else if (this.speed > 0.0f) {
                this.speed = 0.0f;
                this.damageChance = 0.0f;
                this.maxDamage = 0;
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            if (this.focusingRecipe != null) {
                this.progress += 1.0f + this.speed;
                if (this.progress >= (float)this.focusingRecipe.time) {
                    this.craft();
                }
                return;
            }
            if (this.repairRecipe != null && !this.getTablets().isEmpty()) {
                ItemStack damagedItem = this.inventory.getStackInSlot(0);
                int time = 400 + damagedItem.m_41773_() * 5;
                this.progress += 1.0f;
                if (!this.repairRecipe.repairMaterial.matches(this.validTablet.inventory.getStackInSlot(0))) {
                    this.fetchTablets(this.f_58857_, this.f_58858_.m_7494_());
                }
                if (this.progress >= (float)time) {
                    this.repair();
                }
            }
            if (this.focusingRecipe == null && this.repairRecipe == null) {
                this.progress = 0.0f;
            }
            if (this.focusingRecipe == null) {
                --this.tabletFetchCooldown;
                if (this.tabletFetchCooldown <= 0) {
                    this.tabletFetchCooldown = 5;
                    this.fetchTablets(this.f_58857_, this.f_58858_.m_7494_());
                    BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.m_58899_());
                }
            }
        }
    }

    public void repair() {
        Object malumSpiritItem;
        Item item;
        Vec3 itemPos = SpiritCrucibleCoreBlockEntity.getItemPos(this);
        Vec3 providedItemPos = this.validTablet.getItemPos();
        ItemStack damagedItem = this.inventory.getStackInSlot(0);
        ItemStack repairMaterial = this.validTablet.inventory.getStackInSlot(0);
        ItemStack result = SpiritRepairRecipe.getRepairRecipeOutput(damagedItem);
        result.m_41721_(Math.max(0, result.m_41773_() - (int)((float)result.m_41776_() * this.repairRecipe.durabilityPercentage)));
        this.inventory.setStackInSlot(0, result);
        if (!this.repairRecipe.spirits.isEmpty()) {
            PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarConsumeParticlePacket(repairMaterial, this.repairRecipe.spirits.stream().map(s -> s.type.identifier).collect(Collectors.toList()), providedItemPos.f_82479_, providedItemPos.f_82480_, providedItemPos.f_82481_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
        } else {
            item = this.repairRecipe.repairMaterial.getItem();
            if (item instanceof MalumSpiritItem) {
                malumSpiritItem = (MalumSpiritItem)item;
                PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarConsumeParticlePacket(repairMaterial, List.of(((MalumSpiritItem)malumSpiritItem).type.identifier), providedItemPos.f_82479_, providedItemPos.f_82480_, providedItemPos.f_82481_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
            }
        }
        PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarConsumeParticlePacket(repairMaterial, this.repairRecipe.spirits.stream().map(s -> s.type.identifier).collect(Collectors.toList()), providedItemPos.f_82479_, providedItemPos.f_82480_, providedItemPos.f_82481_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
        repairMaterial.m_41774_(this.repairRecipe.repairMaterial.getCount());
        block0: for (SpiritWithCount spirit : this.repairRecipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.m_41774_(spirit.count);
                continue block0;
            }
        }
        if (!this.repairRecipe.spirits.isEmpty()) {
            PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarCraftParticlePacket(this.repairRecipe.spirits.stream().map(s -> s.type.identifier).collect(Collectors.toList()), itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
        } else {
            item = this.repairRecipe.repairMaterial.getItem();
            if (item instanceof MalumSpiritItem) {
                malumSpiritItem = (MalumSpiritItem)item;
                PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarCraftParticlePacket(List.of(((MalumSpiritItem)malumSpiritItem).type.identifier), itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
            }
        }
        this.repairRecipe = SpiritRepairRecipe.getRecipe(this.f_58857_, damagedItem, repairMaterial, this.spiritInventory.nonEmptyStacks);
        this.fetchTablets(this.f_58857_, this.f_58858_.m_7494_());
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.validTablet.m_58899_());
        this.finishRecipe();
    }

    public void craft() {
        Vec3 itemPos = SpiritCrucibleCoreBlockEntity.getItemPos(this);
        ItemStack stack = this.inventory.getStackInSlot(0);
        ItemStack outputStack = this.focusingRecipe.output.getStack();
        if (this.focusingRecipe.durabilityCost != 0 && stack.m_41763_()) {
            Item item;
            int durabilityCost = this.focusingRecipe.durabilityCost;
            for (float chance = this.damageChance; durabilityCost < durabilityCost + this.maxDamage && this.f_58857_.f_46441_.nextFloat() < chance; ++durabilityCost, chance *= chance) {
            }
            this.queuedCracks = durabilityCost;
            boolean success = stack.m_41629_(durabilityCost, this.f_58857_.f_46441_, null);
            if (success && (item = stack.m_41720_()) instanceof ImpetusItem) {
                ImpetusItem impetusItem = (ImpetusItem)item;
                this.inventory.setStackInSlot(0, impetusItem.getCrackedVariant().m_7968_());
                this.updateRecipe = true;
            }
        }
        block1: for (SpiritWithCount spirit : this.focusingRecipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.m_41774_(spirit.count);
                continue block1;
            }
        }
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, outputStack));
        PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarCraftParticlePacket(this.focusingRecipe.spirits.stream().map(s -> s.type.identifier).collect(Collectors.toList()), itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
        this.focusingRecipe = SpiritFocusingRecipe.getRecipe(this.f_58857_, stack, this.spiritInventory.nonEmptyStacks);
        this.finishRecipe();
    }

    public void finishRecipe() {
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.CRUCIBLE_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.75f + this.f_58857_.f_46441_.nextFloat() * 0.5f);
        this.progress = 0.0f;
        this.inventory.updateData();
        this.spiritInventory.updateData();
        this.recalibrateAccelerators(this.f_58857_, this.f_58858_);
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    @Override
    public HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> recalibrateAccelerators(Level level, BlockPos pos) {
        HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> accelerators = IAccelerationTarget.super.recalibrateAccelerators(level, pos);
        this.speed = 0.0f;
        this.damageChance = 0.0f;
        this.maxDamage = 0;
        accelerators.forEach((e, c) -> {
            this.speed += e.getAcceleration((int)c);
            this.damageChance = Math.min(this.damageChance + e.getDamageChance((int)c), 1.0f);
            this.maxDamage += e.getMaximumDamage((int)c);
        });
        return accelerators;
    }

    public static Vec3 getItemPos(SpiritCrucibleCoreBlockEntity blockEntity) {
        return DataHelper.fromBlockPos((BlockPos)blockEntity.m_58899_()).m_82549_(blockEntity.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, (double)1.6f, 0.5);
    }

    public static Vec3 spiritOffset(SpiritCrucibleCoreBlockEntity blockEntity, int slot) {
        float distance = 0.75f + (float)Math.sin(blockEntity.spiritSpin / 20.0f) * 0.025f;
        float height = 1.75f;
        return DataHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)blockEntity.spiritAmount, (long)((long)blockEntity.spiritSpin), (float)360.0f);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void passiveParticles() {
        block11: {
            itemPos = SpiritCrucibleCoreBlockEntity.getItemPos(this);
            if (!this.spiritInventory.isEmpty()) {
                for (i = 0; i < this.spiritInventory.slotCount; ++i) {
                    item = this.spiritInventory.getStackInSlot(i);
                    var5_6 = item.m_41720_();
                    if (!(var5_6 instanceof MalumSpiritItem)) continue;
                    spiritSplinterItem = (MalumSpiritItem)var5_6;
                    offset = SpiritCrucibleCoreBlockEntity.spiritOffset(this, i);
                    color /* !! */  = spiritSplinterItem.type.color;
                    endColor = spiritSplinterItem.type.endColor;
                    x = (double)this.m_58899_().m_123341_() + offset.m_7096_();
                    y = (double)this.m_58899_().m_123342_() + offset.m_7098_();
                    z = (double)this.m_58899_().m_123343_() + offset.m_7094_();
                    SpiritHelper.spawnSpiritParticles(this.f_58857_, x, y, z, (Color)color /* !! */ , endColor);
                }
            }
            if (this.repairRecipe == null) break block11;
            tabletBlockEntity = this.validTablet;
            colors = new ArrayList<Color>();
            endColors = new ArrayList<E>();
            color /* !! */  = tabletBlockEntity.inventory.getStackInSlot(0).m_41720_();
            if (!(color /* !! */  instanceof MalumSpiritItem)) ** GOTO lbl-1000
            spiritItem = (MalumSpiritItem)color /* !! */ ;
            if (this.repairRecipe.repairMaterial.getItem() instanceof MalumSpiritItem) {
                colors.add(spiritItem.type.color);
                endColors.add(spiritItem.type.endColor);
            } else if (!this.spiritInventory.isEmpty()) {
                for (i = 0; i < this.spiritInventory.slotCount; ++i) {
                    item = this.spiritInventory.getStackInSlot(i);
                    var9_17 = item.m_41720_();
                    if (!(var9_17 instanceof MalumSpiritItem)) continue;
                    spiritItem = (MalumSpiritItem)var9_17;
                    colors.add(spiritItem.type.color);
                    endColors.add(spiritItem.type.endColor);
                }
            }
            for (i = 0; i < colors.size(); ++i) {
                color = (Color)colors.get(i);
                endColor = (Color)endColors.get(i);
                tabletItemPos = tabletBlockEntity.getItemPos();
                velocity = tabletItemPos.m_82546_(itemPos).m_82541_().m_82490_(-0.10000000149011612);
                ParticleBuilders.create((RegistryObject)OrtusParticles.STAR_PARTICLE).setAlpha(0.24f / (float)colors.size(), 0.0f).setLifetime(15).setScale(0.45f + this.f_58857_.f_46441_.nextFloat() * 0.15f, 0.0f).randomOffset(0.05).setSpinOffset(0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setColor(color, endColor).enableNoClip().repeat(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, 1);
                ParticleBuilders.create((RegistryObject)OrtusParticles.STAR_PARTICLE).setAlpha(0.24f / (float)colors.size(), 0.0f).setLifetime(15).setScale(0.45f + this.f_58857_.f_46441_.nextFloat() * 0.15f, 0.0f).randomOffset(0.05).setSpinOffset(-0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setColor(color, endColor).enableNoClip().repeat(this.f_58857_, tabletItemPos.f_82479_, tabletItemPos.f_82480_, tabletItemPos.f_82481_, 1);
                ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.4f / (float)colors.size(), 0.0f).setLifetime((int)((double)(10 + this.f_58857_.f_46441_.nextInt(8)) + Math.sin(0.5 * (double)this.f_58857_.m_46467_() % 6.28000020980835))).setScale(0.2f + this.f_58857_.f_46441_.nextFloat() * 0.15f, 0.0f).randomOffset(0.05).setSpinOffset(0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setSpin(0.1f + this.f_58857_.f_46441_.nextFloat() * 0.05f).setColor(color.brighter(), endColor).setAlphaCurveMultiplier(0.5f).setColorCurveMultiplier(0.75f).setMotion(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_).enableNoClip().repeat(this.f_58857_, tabletItemPos.f_82479_, tabletItemPos.f_82480_, tabletItemPos.f_82481_, 1);
            }
            return;
        }
        if (this.focusingRecipe != null) {
            for (i = 0; i < this.spiritInventory.slotCount; ++i) {
                item = this.spiritInventory.getStackInSlot(i);
                for (Object accelerator : this.accelerators) {
                    if (accelerator == null) continue;
                    accelerator.addParticles(this.f_58858_, itemPos);
                }
                accelerator = item.m_41720_();
                if (!(accelerator instanceof MalumSpiritItem)) continue;
                spiritSplinterItem = (MalumSpiritItem)accelerator;
                offset = SpiritCrucibleCoreBlockEntity.spiritOffset(this, i);
                color /* !! */  = spiritSplinterItem.type.color;
                endColor = spiritSplinterItem.type.endColor;
                x = (double)this.m_58899_().m_123341_() + offset.m_7096_();
                y = (double)this.m_58899_().m_123342_() + offset.m_7098_();
                z = (double)this.m_58899_().m_123343_() + offset.m_7094_();
                velocity = new Vec3(x, y, z).m_82546_(itemPos).m_82541_().m_82490_(-0.029999999329447746);
                for (ICrucibleAccelerator accelerator : this.accelerators) {
                    if (accelerator == null) continue;
                    accelerator.addParticles((Color)color /* !! */ , endColor, 0.08f / (float)this.spiritInventory.nonEmptyItemAmount, this.f_58858_, itemPos);
                }
                ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.3f, 0.0f).setLifetime(40).setScale(0.2f, 0.0f).randomOffset(0.019999999552965164).randomMotion(0.009999999776482582, 0.009999999776482582).setColor((Color)color /* !! */ , endColor).setColorCurveMultiplier(0.75f).randomMotion(0.0024999999441206455, 0.0024999999441206455).addMotion(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_).enableNoClip().repeat(this.f_58857_, x, y, z, 1);
                ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.12f / (float)this.spiritInventory.nonEmptyItemAmount, 0.0f).setLifetime(25).setScale(0.2f + this.f_58857_.f_46441_.nextFloat() * 0.1f, 0.0f).randomOffset(0.05).setSpinOffset(0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setColor((Color)color /* !! */ , endColor).enableNoClip().repeat(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, 1);
                ParticleBuilders.create((RegistryObject)OrtusParticles.STAR_PARTICLE).setAlpha(0.16f / (float)this.spiritInventory.nonEmptyItemAmount, 0.0f).setLifetime(25).setScale(0.45f + this.f_58857_.f_46441_.nextFloat() * 0.1f, 0.0f).randomOffset(0.05).setSpinOffset(0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setColor((Color)color /* !! */ , endColor).enableNoClip().repeat(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, 1);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

