/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.crucible;

import com.sammy.malum.common.blockentity.crucible.IAccelerationTarget;
import com.sammy.malum.common.blockentity.crucible.ICrucibleAccelerator;
import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.setup.content.block.BlockRegistry;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntityInventory;
import com.sammy.ortus.systems.multiblock.HorizontalDirectionStructure;
import com.sammy.ortus.systems.multiblock.MultiBlockCoreEntity;
import com.sammy.ortus.systems.multiblock.MultiBlockStructure;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.RegistryObject;

public class SpiritCatalyzerCoreBlockEntity
extends MultiBlockCoreEntity
implements ICrucibleAccelerator {
    public static final Supplier<HorizontalDirectionStructure> STRUCTURE = () -> HorizontalDirectionStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.SPIRIT_CATALYZER_COMPONENT.get()).m_49966_())});
    public static final ICrucibleAccelerator.CrucibleAcceleratorType CATALYZER = new ICrucibleAccelerator.ArrayCrucibleAcceleratorType("catalyzer", new float[]{0.2f, 0.25f, 0.3f, 0.4f, 0.45f, 0.5f, 0.6f, 0.8f}, new int[]{1, 1, 1, 2, 2, 3, 3, 5}, new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.5f, 2.0f, 3.0f, 8.0f});
    public OrtusBlockEntityInventory inventory = new OrtusBlockEntityInventory(1, 64, t -> !(t.m_41720_() instanceof MalumSpiritItem)){

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockHelper.updateAndNotifyState((Level)SpiritCatalyzerCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCatalyzerCoreBlockEntity.this.f_58858_);
        }
    };
    public int burnTicks;
    IAccelerationTarget target;

    public SpiritCatalyzerCoreBlockEntity(BlockEntityType<? extends SpiritCatalyzerCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
    }

    public SpiritCatalyzerCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritCatalyzerCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.SPIRIT_CATALYZER.get()), (MultiBlockStructure)STRUCTURE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        this.inventory.save(compound);
        if (this.burnTicks != 0) {
            compound.m_128405_("burnTicks", this.burnTicks);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.inventory.load(compound);
        this.burnTicks = compound.m_128451_("burnTicks");
        super.m_142466_(compound);
    }

    @Override
    public ICrucibleAccelerator.CrucibleAcceleratorType getAcceleratorType() {
        return CATALYZER;
    }

    @Override
    public IAccelerationTarget getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(IAccelerationTarget target) {
        this.target = target;
    }

    @Override
    public boolean canStartAccelerating() {
        boolean ticks = this.burnTicks > 0;
        boolean stack = ForgeHooks.getBurnTime((ItemStack)this.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_) > 0;
        return ticks || stack;
    }

    @Override
    public boolean canAccelerate() {
        this.updateBurnTicks();
        return this.burnTicks > 0;
    }

    public void tick() {
        if (this.target != null && !this.target.canBeAccelerated()) {
            this.setTarget(null);
        } else if (this.target != null && this.burnTicks > 0) {
            --this.burnTicks;
        }
    }

    public void updateBurnTicks() {
        ItemStack stack;
        if (this.burnTicks == 0 && !(stack = this.inventory.getStackInSlot(0)).m_41619_()) {
            this.burnTicks = ForgeHooks.getBurnTime((ItemStack)this.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_) / 2;
            stack.m_41774_(1);
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
    }

    @Override
    public void addParticles(Color color, Color endColor, float alpha, BlockPos targetPos, Vec3 targetItemPos) {
        if (this.burnTicks > 0) {
            Vec3 startPos = SpiritCatalyzerCoreBlockEntity.getItemPos(this);
            float random = this.f_58857_.f_46441_.nextFloat() * 0.04f;
            Vec3 velocity = startPos.m_82546_(targetItemPos.m_82520_((double)random, (double)random, (double)random)).m_82541_().m_82490_((double)-0.08f);
            ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(alpha * 5.0f, 0.0f).setLifetime((int)((double)(10 + this.f_58857_.f_46441_.nextInt(8)) + Math.sin(0.2 * (double)this.f_58857_.m_46467_() % (double)6.28f))).setScale(0.15f + this.f_58857_.f_46441_.nextFloat() * 0.15f, 0.0f).randomOffset(0.05).setSpinOffset(0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setSpin(0.1f + this.f_58857_.f_46441_.nextFloat() * 0.05f).setColor(color.brighter(), endColor).setAlphaCurveMultiplier(0.5f).setColorCurveMultiplier(0.75f).setMotion(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_).enableNoClip().repeat(this.f_58857_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 1);
            ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(alpha * 3.0f, 0.0f).setLifetime(15).setScale(0.2f + this.f_58857_.f_46441_.nextFloat() * 0.15f, 0.0f).randomOffset(0.05).setSpinOffset(0.15f * (float)this.f_58857_.m_46467_() % 6.28f).setColor(color, endColor).enableNoClip().repeat(this.f_58857_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 1);
            ParticleBuilders.create((RegistryObject)OrtusParticles.STAR_PARTICLE).setAlpha(alpha * 3.0f, 0.0f).setLifetime(15).setScale(0.45f + this.f_58857_.f_46441_.nextFloat() * 0.15f, 0.0f).randomOffset(0.05).setSpinOffset(0.075f * (float)this.f_58857_.m_46467_() % 6.28f).setColor(color, endColor).enableNoClip().repeat(this.f_58857_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 1);
        }
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        this.inventory.interact(player.f_19853_, player, hand);
        return InteractionResult.SUCCESS;
    }

    public void onBreak() {
        this.inventory.dumpItems(this.f_58857_, DataHelper.fromBlockPos((BlockPos)this.f_58858_).m_82520_(0.5, 0.5, 0.5));
        super.onBreak();
    }

    public static Vec3 getItemPos(SpiritCatalyzerCoreBlockEntity blockEntity) {
        return DataHelper.fromBlockPos((BlockPos)blockEntity.m_58899_()).m_82549_(blockEntity.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, (double)1.95f, 0.5);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

