/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.crucible;

import com.sammy.malum.common.blockentity.crucible.IAccelerationTarget;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public interface ICrucibleAccelerator {
    public CrucibleAcceleratorType getAcceleratorType();

    default public boolean canStartAccelerating() {
        return true;
    }

    default public boolean canAccelerate() {
        return true;
    }

    public IAccelerationTarget getTarget();

    public void setTarget(IAccelerationTarget var1);

    default public void addParticles(BlockPos targetPos, Vec3 targetItemPos) {
    }

    default public void addParticles(Color color, Color endColor, float alpha, BlockPos targetPos, Vec3 targetItemPos) {
    }

    public static class ArrayCrucibleAcceleratorType
    extends CrucibleAcceleratorType {
        public final float[] damageChance;
        public final int[] maximumDamage;
        public final float[] acceleration;

        public ArrayCrucibleAcceleratorType(String type, float[] damageChance, int[] maximumDamage, float[] acceleration) {
            super(damageChance.length, type);
            this.damageChance = damageChance;
            this.maximumDamage = maximumDamage;
            this.acceleration = acceleration;
        }

        @Override
        public float getDamageChance(int entries) {
            return this.damageChance[entries - 1];
        }

        @Override
        public int getMaximumDamage(int entries) {
            return this.maximumDamage[entries - 1];
        }

        @Override
        public float getAcceleration(int entries) {
            return this.acceleration[entries - 1];
        }
    }

    public static abstract class CrucibleAcceleratorType {
        public final int maximumEntries;
        public final String type;

        public CrucibleAcceleratorType(int maximumEntries, String type) {
            this.maximumEntries = maximumEntries;
            this.type = type;
        }

        public float getDamageChance(int entries) {
            return 0.0f;
        }

        public int getMaximumDamage(int entries) {
            return 0;
        }

        public float getAcceleration(int entries) {
            return 0.0f;
        }
    }
}

