/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.crucible;

import com.sammy.malum.common.blockentity.crucible.ICrucibleAccelerator;
import com.sammy.ortus.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IAccelerationTarget {
    public boolean canBeAccelerated();

    public ArrayList<ICrucibleAccelerator> getAccelerators();

    public ArrayList<BlockPos> getAcceleratorPositions();

    default public int getLookupRange() {
        return 4;
    }

    default public HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> recalibrateAccelerators(Level level, BlockPos pos) {
        this.getAccelerators().clear();
        this.getAcceleratorPositions().clear();
        ArrayList nearbyAccelerators = BlockHelper.getBlockEntities(ICrucibleAccelerator.class, (Level)level, (BlockPos)pos, (int)this.getLookupRange());
        HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer> entries = new HashMap<ICrucibleAccelerator.CrucibleAcceleratorType, Integer>();
        for (ICrucibleAccelerator accelerator : nearbyAccelerators) {
            if (!accelerator.canStartAccelerating() || accelerator.getTarget() != null && accelerator.getTarget() != this) continue;
            accelerator.setTarget(this);
            int max = accelerator.getAcceleratorType().maximumEntries;
            int amount = entries.computeIfAbsent(accelerator.getAcceleratorType(), a -> 0);
            if (amount >= max) continue;
            this.getAccelerators().add(accelerator);
            this.getAcceleratorPositions().add(((BlockEntity)accelerator).m_58899_());
            entries.replace(accelerator.getAcceleratorType(), amount + 1);
        }
        return entries;
    }

    default public void saveAcceleratorData(CompoundTag compound) {
        CompoundTag acceleratorTag = new CompoundTag();
        ArrayList<BlockPos> positions = this.getAcceleratorPositions();
        if (!positions.isEmpty()) {
            acceleratorTag.m_128405_("amount", positions.size());
            for (int i = 0; i < positions.size(); ++i) {
                BlockPos position = positions.get(i);
                BlockHelper.saveBlockPos((CompoundTag)acceleratorTag, (BlockPos)position, (String)("accelerator_" + i + "_"));
            }
            compound.m_128365_("acceleratorData", (Tag)acceleratorTag);
        }
    }

    default public void loadAcceleratorData(Level level, CompoundTag compound) {
        this.getAcceleratorPositions().clear();
        this.getAccelerators().clear();
        if (compound.m_128441_("acceleratorData")) {
            CompoundTag acceleratorTag = compound.m_128469_("acceleratorData");
            int amount = acceleratorTag.m_128451_("amount");
            for (int i = 0; i < amount; ++i) {
                BlockEntity blockEntity;
                BlockPos pos = BlockHelper.loadBlockPos((CompoundTag)acceleratorTag, (String)("accelerator_" + i + "_"));
                if (level != null && (blockEntity = level.m_7702_(pos)) instanceof ICrucibleAccelerator) {
                    ICrucibleAccelerator accelerator = (ICrucibleAccelerator)blockEntity;
                    this.getAccelerators().add(accelerator);
                } else if (level != null) continue;
                this.getAcceleratorPositions().add(pos);
            }
        }
    }
}

