/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity.altar;

import com.sammy.malum.common.blockentity.altar.AltarSoundInstance;
import com.sammy.malum.common.blockentity.altar.IAltarAccelerator;
import com.sammy.malum.common.blockentity.altar.IAltarProvider;
import com.sammy.malum.common.item.spirit.MalumSpiritItem;
import com.sammy.malum.common.packets.particle.altar.AltarConsumeParticlePacket;
import com.sammy.malum.common.packets.particle.altar.AltarCraftParticlePacket;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.helper.SpiritHelper;
import com.sammy.malum.core.setup.content.SoundRegistry;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.malum.core.setup.server.PacketRegistry;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.ortus.helpers.BlockHelper;
import com.sammy.ortus.helpers.DataHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntity;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntityInventory;
import com.sammy.ortus.systems.recipe.IngredientWithCount;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;

public class SpiritAltarTileEntity
extends OrtusBlockEntity {
    private static final int HORIZONTAL_RANGE = 4;
    private static final int VERTICAL_RANGE = 2;
    public float speed;
    public int progress;
    public int spinUp;
    public ArrayList<BlockPos> acceleratorPositions = new ArrayList();
    public ArrayList<IAltarAccelerator> accelerators = new ArrayList();
    public float spiritAmount;
    public float spiritSpin;
    public boolean updateRecipe;
    public OrtusBlockEntityInventory inventory;
    public OrtusBlockEntityInventory extrasInventory;
    public OrtusBlockEntityInventory spiritInventory;
    public ArrayList<SpiritInfusionRecipe> possibleRecipes = new ArrayList();
    public SpiritInfusionRecipe recipe;

    public SpiritAltarTileEntity(BlockEntityType<? extends SpiritAltarTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SpiritAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SPIRIT_ALTAR.get(), pos, state);
        this.inventory = new OrtusBlockEntityInventory(1, 64, t -> !(t.m_41720_() instanceof MalumSpiritItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritAltarTileEntity.this.updateRecipe = true;
                BlockHelper.updateAndNotifyState((Level)SpiritAltarTileEntity.this.f_58857_, (BlockPos)SpiritAltarTileEntity.this.f_58858_);
            }
        };
        this.extrasInventory = new OrtusBlockEntityInventory(8, 1){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((Level)SpiritAltarTileEntity.this.f_58857_, (BlockPos)SpiritAltarTileEntity.this.f_58858_);
            }
        };
        this.spiritInventory = new OrtusBlockEntityInventory(8, 64, t -> t.m_41720_() instanceof MalumSpiritItem){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SpiritAltarTileEntity.this.updateRecipe = true;
                SpiritAltarTileEntity.this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.15f, (float)SpiritAltarTileEntity.this.spiritAmount, (float)(this.nonEmptyItemAmount + 1)));
                BlockHelper.updateAndNotifyState((Level)SpiritAltarTileEntity.this.f_58857_, (BlockPos)SpiritAltarTileEntity.this.f_58858_);
            }
        };
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.progress != 0) {
            compound.m_128405_("progress", this.progress);
        }
        if (this.spinUp != 0) {
            compound.m_128405_("spinUp", this.spinUp);
        }
        if (this.speed != 0.0f) {
            compound.m_128350_("speed", this.speed);
        }
        if (this.spiritAmount != 0.0f) {
            compound.m_128350_("spiritAmount", this.spiritAmount);
        }
        if (!this.acceleratorPositions.isEmpty()) {
            compound.m_128405_("acceleratorAmount", this.acceleratorPositions.size());
            for (int i = 0; i < this.acceleratorPositions.size(); ++i) {
                BlockHelper.saveBlockPos((CompoundTag)compound, (BlockPos)this.acceleratorPositions.get(i), (String)("" + i));
            }
        }
        this.inventory.save(compound);
        this.spiritInventory.save(compound, "spiritInventory");
        this.extrasInventory.save(compound, "extrasInventory");
    }

    public void m_142466_(CompoundTag compound) {
        this.progress = compound.m_128451_("progress");
        this.spinUp = compound.m_128451_("spinUp");
        this.speed = compound.m_128457_("speed");
        this.acceleratorPositions.clear();
        this.accelerators.clear();
        int amount = compound.m_128451_("acceleratorAmount");
        for (int i = 0; i < amount; ++i) {
            BlockEntity blockEntity;
            BlockPos pos = BlockHelper.loadBlockPos((CompoundTag)compound, (String)("" + i));
            if (this.f_58857_ == null || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof IAltarAccelerator)) continue;
            IAltarAccelerator accelerator = (IAltarAccelerator)blockEntity;
            this.acceleratorPositions.add(pos);
            this.accelerators.add(accelerator);
        }
        this.spiritAmount = compound.m_128457_("spiritAmount");
        this.updateRecipe = true;
        this.inventory.load(compound);
        this.spiritInventory.load(compound, "spiritInventory");
        this.extrasInventory.load(compound, "extrasInventory");
        super.m_142466_(compound);
    }

    public void onBreak() {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        this.spiritInventory.dumpItems(this.f_58857_, this.f_58858_);
        this.extrasInventory.dumpItems(this.f_58857_, this.f_58858_);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack stack;
            ItemStack heldStack = player.m_21205_();
            this.recalibrateAccelerators();
            if (!(heldStack.m_41720_() instanceof MalumSpiritItem) && !(stack = this.inventory.interact(this.f_58857_, player, hand)).m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            this.spiritInventory.interact(this.f_58857_, player, hand);
            if (heldStack.m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.onUse(player, hand);
    }

    public void tick() {
        this.spiritAmount = Math.max(1.0f, Mth.m_14179_((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.nonEmptyItemAmount));
        if (this.updateRecipe) {
            ItemStack stack = this.inventory.getStackInSlot(0);
            this.possibleRecipes = new ArrayList(DataHelper.getAll(SpiritInfusionRecipe.getRecipes(this.f_58857_), r -> r.doesInputMatch(stack) && r.doSpiritsMatch(this.spiritInventory.nonEmptyStacks)));
            this.recipe = SpiritInfusionRecipe.getRecipe(this.f_58857_, stack, this.spiritInventory.nonEmptyStacks);
            if (this.f_58857_.f_46443_ && !this.possibleRecipes.isEmpty()) {
                AltarSoundInstance.playSound(this);
            }
            this.updateRecipe = false;
        }
        if (!this.possibleRecipes.isEmpty()) {
            if (this.spinUp < 10) {
                ++this.spinUp;
            }
            if (!this.f_58857_.f_46443_) {
                boolean success;
                int progressCap;
                boolean canAccelerate;
                ++this.progress;
                if (this.f_58857_.m_46467_() % 20L == 0L && !(canAccelerate = this.accelerators.stream().allMatch(IAltarAccelerator::canAccelerate))) {
                    this.recalibrateAccelerators();
                }
                if (this.progress >= (progressCap = (int)(300.0 * Math.exp(-0.15 * (double)this.speed))) && (success = this.consume())) {
                    this.craft();
                }
            }
        } else {
            this.progress = 0;
            if (this.spinUp > 0) {
                --this.spinUp;
            }
        }
        if (this.f_58857_.f_46443_) {
            this.spiritSpin += 1.0f + (float)this.spinUp / 5.0f;
            this.passiveParticles();
        }
    }

    public static Vec3 getItemPos(SpiritAltarTileEntity blockEntity) {
        return DataHelper.fromBlockPos((BlockPos)blockEntity.m_58899_()).m_82549_(blockEntity.itemOffset());
    }

    public Vec3 itemOffset() {
        return new Vec3(0.5, 1.25, 0.5);
    }

    public static Vec3 spiritOffset(SpiritAltarTileEntity blockEntity, int slot, float partialTicks) {
        float distance = 1.0f - Math.min(0.25f, (float)blockEntity.spinUp / 40.0f) + (float)Math.sin((blockEntity.spiritSpin + partialTicks) / 20.0f) * 0.025f;
        float height = 0.75f + Math.min(0.5f, (float)blockEntity.spinUp / 20.0f);
        return DataHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)blockEntity.spiritAmount, (long)((long)(blockEntity.spiritSpin + partialTicks)), (float)360.0f);
    }

    public boolean consume() {
        Vec3 itemPos = SpiritAltarTileEntity.getItemPos(this);
        if (this.recipe.extraItems.isEmpty()) {
            return true;
        }
        this.extrasInventory.updateData();
        int extras = this.extrasInventory.nonEmptyItemAmount;
        if (extras < this.recipe.extraItems.size()) {
            this.progress = (int)((float)this.progress * 0.75f);
            ArrayList altarProviders = BlockHelper.getBlockEntities(IAltarProvider.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)4, (int)2, (int)4);
            for (IAltarProvider provider : altarProviders) {
                ItemStack providedStack = provider.getInventoryForAltar().getStackInSlot(0);
                IngredientWithCount requestedItem = this.recipe.extraItems.get(extras);
                boolean matches = requestedItem.matches(providedStack);
                if (!matches) {
                    for (SpiritInfusionRecipe recipe : this.possibleRecipes) {
                        if (extras >= recipe.extraItems.size() || !recipe.extraItems.get(extras).matches(providedStack)) continue;
                        this.recipe = recipe;
                        break;
                    }
                }
                if (!(matches = (requestedItem = this.recipe.extraItems.get(extras)).matches(providedStack))) continue;
                this.f_58857_.m_5594_(null, provider.getBlockPosForAltar(), (SoundEvent)SoundRegistry.ALTAR_CONSUME.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.nextFloat() * 0.2f);
                Vec3 providedItemPos = provider.getItemPosForAltar();
                PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(provider.getBlockPosForAltar())), (Object)new AltarConsumeParticlePacket(providedStack, this.recipe.spirits.stream().map(s -> s.type.identifier).collect(Collectors.toList()), providedItemPos.f_82479_, providedItemPos.f_82480_, providedItemPos.f_82481_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
                this.extrasInventory.insertItem(this.f_58857_, providedStack.m_41620_(requestedItem.count));
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)provider.getBlockPosForAltar());
                break;
            }
            return false;
        }
        return true;
    }

    public void craft() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        Vec3 itemPos = SpiritAltarTileEntity.getItemPos(this);
        ItemStack outputStack = this.recipe.output.getStack();
        if (this.inventory.getStackInSlot(0).m_41782_()) {
            outputStack.m_41751_(stack.m_41783_());
        }
        stack.m_41774_(this.recipe.input.count);
        block0: for (SpiritWithCount spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.matches(spiritStack)) continue;
                spiritStack.m_41774_(spirit.count);
                continue block0;
            }
        }
        PacketRegistry.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new AltarCraftParticlePacket(this.recipe.spirits.stream().map(s -> s.type.identifier).collect(Collectors.toList()), itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_));
        this.progress = 0;
        this.extrasInventory.clear();
        this.updateRecipe = true;
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.ALTAR_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.nextFloat() * 0.2f);
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, outputStack));
        this.inventory.updateData();
        this.spiritInventory.updateData();
        this.extrasInventory.updateData();
        this.recalibrateAccelerators();
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void recalibrateAccelerators() {
        this.speed = 0.0f;
        this.accelerators.clear();
        this.acceleratorPositions.clear();
        ArrayList nearbyAccelerators = BlockHelper.getBlockEntities(IAltarAccelerator.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)4, (int)2, (int)4);
        HashMap<IAltarAccelerator.AltarAcceleratorType, Integer> entries = new HashMap<IAltarAccelerator.AltarAcceleratorType, Integer>();
        for (IAltarAccelerator accelerator : nearbyAccelerators) {
            if (!accelerator.canAccelerate()) continue;
            int max = accelerator.getAcceleratorType().maximumEntries;
            int amount = entries.computeIfAbsent(accelerator.getAcceleratorType(), a -> 0);
            if (amount >= max) continue;
            this.accelerators.add(accelerator);
            this.acceleratorPositions.add(((BlockEntity)accelerator).m_58899_());
            this.speed += accelerator.getAcceleration();
            entries.replace(accelerator.getAcceleratorType(), amount + 1);
        }
    }

    public void passiveParticles() {
        Vec3 itemPos = SpiritAltarTileEntity.getItemPos(this);
        for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
            ItemStack item = this.spiritInventory.getStackInSlot(i);
            for (IAltarAccelerator iAltarAccelerator : this.accelerators) {
                if (iAltarAccelerator == null) continue;
                iAltarAccelerator.addParticles(this.f_58858_, itemPos);
            }
            Item item2 = item.m_41720_();
            if (!(item2 instanceof MalumSpiritItem)) continue;
            MalumSpiritItem spiritSplinterItem = (MalumSpiritItem)item2;
            Vec3 vec3 = SpiritAltarTileEntity.spiritOffset(this, i, 0.0f);
            Color color = spiritSplinterItem.type.color;
            Color endColor = spiritSplinterItem.type.endColor;
            double x = (double)this.m_58899_().m_123341_() + vec3.m_7096_();
            double y = (double)this.m_58899_().m_123342_() + vec3.m_7098_();
            double z = (double)this.m_58899_().m_123343_() + vec3.m_7094_();
            SpiritHelper.spawnSpiritParticles(this.f_58857_, x, y, z, color, endColor);
            if (this.possibleRecipes.isEmpty()) continue;
            Vec3 velocity = new Vec3(x, y, z).m_82546_(itemPos).m_82541_().m_82490_((double)-0.03f);
            float alpha = 0.07f / (float)this.spiritInventory.nonEmptyItemAmount;
            for (IAltarAccelerator accelerator3 : this.accelerators) {
                if (accelerator3 == null) continue;
                accelerator3.addParticles(color, endColor, alpha, this.f_58858_, itemPos);
            }
            ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setAlpha(0.125f, 0.0f).setLifetime(45).setScale(0.2f, 0.0f).randomOffset((double)0.02f).randomMotion((double)0.01f, (double)0.01f).setColor(color, endColor).setColorCurveMultiplier(1.25f).setSpin(0.1f + this.f_58857_.f_46441_.nextFloat() * 0.1f).randomMotion((double)0.0025f, (double)0.0025f).addMotion(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_).enableNoClip().repeat(this.f_58857_, x, y, z, 2);
            ParticleBuilders.create((RegistryObject)OrtusParticles.SPARKLE_PARTICLE).setAlpha(alpha, 0.0f).setLifetime(25).setScale(0.5f, 0.0f).randomOffset(0.1, 0.1).randomMotion((double)0.02f, (double)0.02f).setColor(color, endColor).setColorCurveMultiplier(1.5f).randomMotion((double)0.0025f, (double)0.0025f).enableNoClip().repeat(this.f_58857_, itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_, 2);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

