/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blockentity;

import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.common.block.ether.EtherTorchBlock;
import com.sammy.malum.common.block.ether.EtherWallTorchBlock;
import com.sammy.malum.common.item.ether.AbstractEtherItem;
import com.sammy.malum.core.setup.client.ParticleRegistry;
import com.sammy.malum.core.setup.content.block.BlockEntityRegistry;
import com.sammy.ortus.helpers.ColorHelper;
import com.sammy.ortus.setup.OrtusParticles;
import com.sammy.ortus.systems.blockentity.OrtusBlockEntity;
import com.sammy.ortus.systems.easing.Easing;
import com.sammy.ortus.systems.rendering.particle.ParticleBuilders;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.RegistryObject;

public class EtherBlockEntity
extends OrtusBlockEntity {
    public int firstColorRGB;
    public Color firstColor;
    public int secondColorRGB;
    public Color secondColor;

    public EtherBlockEntity(BlockEntityType<? extends EtherBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public EtherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.ETHER.get(), pos, state);
    }

    public void setFirstColor(int rgb) {
        this.firstColorRGB = rgb;
        this.firstColor = new Color(rgb);
    }

    public void setSecondColor(int rgb) {
        this.secondColorRGB = rgb;
        this.secondColor = new Color(rgb);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("firstColor")) {
            this.setFirstColor(compound.m_128451_("firstColor"));
        } else {
            this.setFirstColor(15712278);
        }
        Item item = this.m_58900_().m_60734_().m_5456_();
        if (item instanceof AbstractEtherItem) {
            AbstractEtherItem etherItem = (AbstractEtherItem)item;
            if (etherItem.iridescent) {
                if (compound.m_128441_("secondColor")) {
                    this.setSecondColor(compound.m_128451_("secondColor"));
                } else {
                    this.setSecondColor(4607909);
                }
            }
        }
        super.m_142466_(compound);
    }

    protected void m_183515_(CompoundTag compound) {
        Item item;
        if (this.firstColor != null && this.firstColorRGB != 15712278) {
            compound.m_128405_("firstColor", this.firstColorRGB);
        }
        if ((item = this.m_58900_().m_60734_().m_5456_()) instanceof AbstractEtherItem) {
            AbstractEtherItem etherItem = (AbstractEtherItem)item;
            if (etherItem.iridescent && this.secondColor != null && this.secondColorRGB != 4607909) {
                compound.m_128405_("secondColor", this.secondColorRGB);
            }
        }
        super.m_183515_(compound);
    }

    public void onPlace(LivingEntity placer, ItemStack stack) {
        AbstractEtherItem item = (AbstractEtherItem)stack.m_41720_();
        this.setFirstColor(item.getFirstColor(stack));
        if (item.iridescent) {
            this.setSecondColor(item.getSecondColor(stack));
        }
        this.m_6596_();
    }

    public ItemStack onClone(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = state.m_60734_().m_5456_().m_7968_();
        AbstractEtherItem etherItem = (AbstractEtherItem)stack.m_41720_();
        if (this.firstColor != null) {
            etherItem.setFirstColor(stack, this.firstColorRGB);
        }
        if (this.secondColor != null) {
            etherItem.setSecondColor(stack, this.secondColorRGB);
        }
        this.m_6596_();
        return super.onClone(state, target, level, pos, player);
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            if (this.firstColor == null) {
                return;
            }
            Color firstColor = ColorHelper.darker((Color)this.firstColor, (int)1);
            Color secondColor = this.secondColor == null ? firstColor : ColorHelper.brighter((Color)this.secondColor, (int)1);
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 0.6;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            int lifeTime = 14 + this.f_58857_.f_46441_.nextInt(4);
            float scale = 0.17f + this.f_58857_.f_46441_.nextFloat() * 0.03f;
            float velocity = 0.04f + this.f_58857_.f_46441_.nextFloat() * 0.02f;
            if (this.m_58900_().m_60734_() instanceof EtherWallTorchBlock) {
                Direction direction = (Direction)this.m_58900_().m_61143_((Property)WallTorchBlock.f_58119_);
                x += (double)((float)direction.m_122436_().m_123341_() * -0.28f);
                y += (double)0.2f;
                z += (double)((float)direction.m_122436_().m_123343_() * -0.28f);
                lifeTime -= 6;
            }
            if (this.m_58900_().m_60734_() instanceof EtherTorchBlock) {
                lifeTime -= 4;
            }
            if (this.m_58900_().m_60734_() instanceof EtherBrazierBlock) {
                y -= (double)0.2f;
                lifeTime -= 2;
                scale *= 1.25f;
            }
            ParticleBuilders.create((RegistryObject)OrtusParticles.WISP_PARTICLE).setScale(scale, 0.0f).setLifetime(lifeTime).setAlpha(0.8f, 0.5f).setColor(firstColor, secondColor).setColorCurveMultiplier(0.8f).setColorEasing(Easing.CIRC_OUT).setSpinOffset((float)this.f_58857_.m_46467_() * 0.2f % 6.28f).setSpin(0.0f, 0.4f).setSpinEasing(Easing.QUARTIC_IN).addMotion(0.0, (double)velocity, 0.0).enableNoClip().spawn(this.f_58857_, x, y, z);
            ParticleBuilders.create((RegistryObject)OrtusParticles.SPARKLE_PARTICLE).setScale(scale * 2.0f, 0.0f).setLifetime(lifeTime).setAlpha(0.2f).setColor(firstColor, secondColor).setColorCurveMultiplier(1.5f).setAlphaCurveMultiplier(1.5f).setSpin(0.0f, 2.0f).setSpinEasing(Easing.QUARTIC_IN).enableNoClip().spawn(this.f_58857_, x, y, z);
            if (this.f_58857_.m_46467_() % 2L == 0L && this.f_58857_.f_46441_.nextFloat() < 0.25f) {
                ParticleBuilders.create(ParticleRegistry.SPIRIT_FLAME_PARTICLE).setScale(0.75f, 0.0f).setColor(firstColor, secondColor).setColorCurveMultiplier(2.0f).setAlphaCurveMultiplier(3.0f).randomOffset((double)0.15f, (double)0.2f).addMotion(0.0, (double)0.03f, 0.0).enableNoClip().spawn(this.f_58857_, x, y += (double)0.15f, z);
                ParticleBuilders.create(ParticleRegistry.SPIRIT_FLAME_PARTICLE).setScale(0.5f, 0.0f).setColor(firstColor, secondColor).setColorCurveMultiplier(3.0f).setAlphaCurveMultiplier(3.0f).randomOffset((double)0.15f, (double)0.2f).addMotion(0.0, (double)velocity, 0.0).enableNoClip().spawn(this.f_58857_, x, y, z);
            }
        }
    }
}

