/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.EntryScreen;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.objects.ImportantEntryObject;
import com.sammy.malum.client.screen.codex.objects.VanishingEntryObject;
import com.sammy.malum.client.screen.codex.pages.CraftingBookPage;
import com.sammy.malum.client.screen.codex.pages.DoubleHeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.SmeltingBookPage;
import com.sammy.malum.client.screen.codex.pages.SpiritCruciblePage;
import com.sammy.malum.client.screen.codex.pages.SpiritInfusionPage;
import com.sammy.malum.client.screen.codex.pages.SpiritRepairPage;
import com.sammy.malum.client.screen.codex.pages.SpiritRitePage;
import com.sammy.malum.client.screen.codex.pages.SpiritTextPage;
import com.sammy.malum.client.screen.codex.pages.TextPage;
import com.sammy.malum.common.events.SetupMalumCodexEntriesEvent;
import com.sammy.malum.core.setup.content.SpiritRiteRegistry;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.ortus.handlers.ScreenParticleHandler;
import com.sammy.ortus.helpers.RenderHelper;
import com.sammy.ortus.systems.recipe.IRecipeComponent;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class ProgressionBookScreen
extends Screen {
    public static final ResourceLocation FRAME_TEXTURE = MalumMod.prefix("textures/gui/book/frame.png");
    public static final ResourceLocation FADE_TEXTURE = MalumMod.prefix("textures/gui/book/fade.png");
    public static final ResourceLocation BACKGROUND_TEXTURE = MalumMod.prefix("textures/gui/book/background.png");
    public int bookWidth = 378;
    public int bookHeight = 250;
    public int bookInsideWidth = 344;
    public int bookInsideHeight = 218;
    public final int parallax_width = 1024;
    public final int parallax_height = 2560;
    public static ProgressionBookScreen screen;
    public float xOffset;
    public float yOffset;
    public float cachedXOffset;
    public float cachedYOffset;
    public boolean ignoreNextMouseInput;
    public static ArrayList<BookEntry> entries;
    public static ArrayList<BookObject> objects;

    protected ProgressionBookScreen() {
        super((Component)new TranslatableComponent("malum.gui.book.title"));
        this.f_96541_ = Minecraft.m_91087_();
        ProgressionBookScreen.setupEntries();
        MinecraftForge.EVENT_BUS.post((Event)new SetupMalumCodexEntriesEvent());
        this.setupObjects();
    }

    public static void setupEntries() {
        entries.clear();
        Item EMPTY = ItemStack.f_41583_.m_41720_();
        entries.add(new BookEntry("introduction", (Item)ItemRegistry.ENCYCLOPEDIA_ARCANA.get(), 0, 0).setObjectSupplier(ImportantEntryObject::new).addPage(new HeadlineTextPage("introduction", "introduction_a")).addPage(new TextPage("introduction_b")).addPage(new TextPage("introduction_c")).addPage(new TextPage("introduction_d")));
        entries.add(new BookEntry("spirit_magics", Items.f_42049_, 0, 1).addPage(new HeadlineTextPage("spirit_magics", "spirit_magics_a")).addPage(new TextPage("spirit_magics_b")).addPage(new TextPage("spirit_magics_c")));
        entries.add(new BookEntry("runewood", (Item)ItemRegistry.RUNEWOOD_SAPLING.get(), 1, 2).addPage(new HeadlineTextPage("runewood", "runewood_a")).addPage(new TextPage("runewood_b")).addPage(new TextPage("runewood_c")).addPage(new TextPage("runewood_d")).addPage(CraftingBookPage.itemPedestalPage((Item)ItemRegistry.RUNEWOOD_ITEM_PEDESTAL.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS_SLAB.get())).addPage(CraftingBookPage.itemStandPage((Item)ItemRegistry.RUNEWOOD_ITEM_STAND.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS_SLAB.get())).addPage(new HeadlineTextPage("arcane_charcoal", "arcane_charcoal")).addPage(new SmeltingBookPage((Item)ItemRegistry.RUNEWOOD_LOG.get(), (Item)ItemRegistry.ARCANE_CHARCOAL.get())).addPage(CraftingBookPage.fullPage((Item)ItemRegistry.BLOCK_OF_ARCANE_CHARCOAL.get(), (Item)ItemRegistry.ARCANE_CHARCOAL.get())).addPage(new HeadlineTextPage("holy_sap", "holy_sap_a")).addPage(new TextPage("holy_sap_b")).addPage(new CraftingBookPage(new ItemStack((ItemLike)ItemRegistry.HOLY_SAPBALL.get(), 3), Items.f_42518_, (Item)ItemRegistry.HOLY_SAP.get())).addPage(new TextPage("holy_sap_c")).addPage(new SmeltingBookPage((Item)ItemRegistry.HOLY_SAP.get(), (Item)ItemRegistry.HOLY_SYRUP.get())).addModCompatPage(new TextPage("holy_sap_d"), "thermal_expansion"));
        entries.add(new BookEntry("soulstone", (Item)ItemRegistry.PROCESSED_SOULSTONE.get(), -1, 2).addPage(new HeadlineTextPage("soulstone", "soulstone_a")).addPage(new TextPage("soulstone_b")).addPage(new TextPage("soulstone_c")).addPage(CraftingBookPage.fullPage((Item)ItemRegistry.BLOCK_OF_SOULSTONE.get(), (Item)ItemRegistry.PROCESSED_SOULSTONE.get())));
        entries.add(new BookEntry("scythes", (Item)ItemRegistry.CRUDE_SCYTHE.get(), 0, 3).addPage(new HeadlineTextPage("scythes", "scythes_a")).addPage(new TextPage("scythes_b")).addPage(new TextPage("scythes_c")).addPage(CraftingBookPage.scythePage((Item)ItemRegistry.CRUDE_SCYTHE.get(), Items.f_42416_, (Item)ItemRegistry.PROCESSED_SOULSTONE.get())).addPage(new HeadlineTextPage("haunted", "haunted")).addPage(new HeadlineTextPage("spirit_plunder", "spirit_plunder")).addPage(new HeadlineTextPage("rebound", "rebound")));
        entries.add(new BookEntry("spirit_infusion", (Item)ItemRegistry.SPIRIT_ALTAR.get(), 0, 5).setObjectSupplier(ImportantEntryObject::new).addPage(new HeadlineTextPage("spirit_infusion", "spirit_infusion_a")).addPage(new TextPage("spirit_infusion_b")).addPage(new TextPage("spirit_infusion_c")).addPage(new CraftingBookPage((Item)ItemRegistry.SPIRIT_ALTAR.get(), Items.f_41852_, (Item)ItemRegistry.PROCESSED_SOULSTONE.get(), Items.f_41852_, Items.f_42417_, (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), Items.f_42417_, (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get())).addPage(CraftingBookPage.itemPedestalPage((Item)ItemRegistry.RUNEWOOD_ITEM_PEDESTAL.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS_SLAB.get())).addPage(CraftingBookPage.itemStandPage((Item)ItemRegistry.RUNEWOOD_ITEM_STAND.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS_SLAB.get())).addPage(new HeadlineTextPage("hex_ash", "hex_ash")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.HEX_ASH.get())));
        entries.add(new BookEntry("primary_arcana", (Item)ItemRegistry.ARCANE_SPIRIT.get(), -2, 4).addPage(new SpiritTextPage("sacred_spirit", "sacred_spirit_a", (Item)ItemRegistry.SACRED_SPIRIT.get())).addPage(new TextPage("sacred_spirit_b")).addPage(new SpiritTextPage("wicked_spirit", "wicked_spirit_a", (Item)ItemRegistry.WICKED_SPIRIT.get())).addPage(new TextPage("wicked_spirit_b")).addPage(new SpiritTextPage("arcane_spirit", "arcane_spirit_a", (Item)ItemRegistry.ARCANE_SPIRIT.get())).addPage(new TextPage("arcane_spirit_b")).addPage(new TextPage("arcane_spirit_c")));
        entries.add(new BookEntry("elemental_arcana", (Item)ItemRegistry.EARTHEN_SPIRIT.get(), 2, 4).addPage(new SpiritTextPage("earthen_spirit", "earthen_spirit_a", (Item)ItemRegistry.EARTHEN_SPIRIT.get())).addPage(new TextPage("earthen_spirit_b")).addPage(new SpiritTextPage("infernal_spirit", "infernal_spirit_a", (Item)ItemRegistry.INFERNAL_SPIRIT.get())).addPage(new TextPage("infernal_spirit_b")).addPage(new SpiritTextPage("aerial_spirit", "aerial_spirit_a", (Item)ItemRegistry.AERIAL_SPIRIT.get())).addPage(new TextPage("aerial_spirit_b")).addPage(new SpiritTextPage("aqueous_spirit", "aqueous_spirit_a", (Item)ItemRegistry.AQUEOUS_SPIRIT.get())).addPage(new TextPage("aqueous_spirit_b")));
        entries.add(new BookEntry("eldritch_arcana", (Item)ItemRegistry.ELDRITCH_SPIRIT.get(), 0, 7).addPage(new SpiritTextPage("eldritch_spirit", "eldritch_spirit_a", (Item)ItemRegistry.ELDRITCH_SPIRIT.get())).addPage(new TextPage("eldritch_spirit_b")));
        entries.add(new BookEntry("arcane_rock", (Item)ItemRegistry.TAINTED_ROCK.get(), 3, 6).addPage(new HeadlineTextPage("tainted_rock", "tainted_rock")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.TAINTED_ROCK.get())).addPage(CraftingBookPage.itemPedestalPage((Item)ItemRegistry.TAINTED_ROCK_ITEM_PEDESTAL.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK_SLAB.get())).addPage(CraftingBookPage.itemStandPage((Item)ItemRegistry.TAINTED_ROCK_ITEM_STAND.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK_SLAB.get())).addPage(new HeadlineTextPage("twisted_rock", "twisted_rock")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.TWISTED_ROCK.get())).addPage(CraftingBookPage.itemPedestalPage((Item)ItemRegistry.TWISTED_ROCK_ITEM_PEDESTAL.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK_SLAB.get())).addPage(CraftingBookPage.itemStandPage((Item)ItemRegistry.TWISTED_ROCK_ITEM_STAND.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK_SLAB.get())));
        entries.add(new BookEntry("ether", (Item)ItemRegistry.ETHER.get(), 5, 6).addPage(new HeadlineTextPage("ether", "ether_a")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.ETHER.get())).addPage(new TextPage("ether_b")).addPage(new CraftingBookPage((Item)ItemRegistry.ETHER_TORCH.get(), EMPTY, EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.ETHER.get(), EMPTY, EMPTY, Items.f_42398_, EMPTY)).addPage(new CraftingBookPage((Item)ItemRegistry.TAINTED_ETHER_BRAZIER.get(), EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.ETHER.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), Items.f_42398_, (Item)ItemRegistry.TAINTED_ROCK.get(), Items.f_42398_)).addPage(new CraftingBookPage((Item)ItemRegistry.TWISTED_ETHER_BRAZIER.get(), EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.ETHER.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), Items.f_42398_, (Item)ItemRegistry.TWISTED_ROCK.get(), Items.f_42398_)).addPage(new HeadlineTextPage("iridescent_ether", "iridescent_ether_a")).addPage(new TextPage("iridescent_ether_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.IRIDESCENT_ETHER.get())).addPage(new CraftingBookPage((Item)ItemRegistry.IRIDESCENT_ETHER_TORCH.get(), EMPTY, EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.IRIDESCENT_ETHER.get(), EMPTY, EMPTY, Items.f_42398_, EMPTY)).addPage(new CraftingBookPage((Item)ItemRegistry.TAINTED_IRIDESCENT_ETHER_BRAZIER.get(), EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.IRIDESCENT_ETHER.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), Items.f_42398_, (Item)ItemRegistry.TAINTED_ROCK.get(), Items.f_42398_)).addPage(new CraftingBookPage((Item)ItemRegistry.TWISTED_IRIDESCENT_ETHER_BRAZIER.get(), EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.IRIDESCENT_ETHER.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), Items.f_42398_, (Item)ItemRegistry.TWISTED_ROCK.get(), Items.f_42398_)));
        entries.add(new BookEntry("spirit_fabric", (Item)ItemRegistry.SPIRIT_FABRIC.get(), 4, 5).addPage(new HeadlineTextPage("spirit_fabric", "spirit_fabric")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SPIRIT_FABRIC.get())).addPage(new HeadlineTextPage("spirit_pouch", "spirit_pouch")).addPage(new CraftingBookPage((Item)ItemRegistry.SPIRIT_POUCH.get(), EMPTY, Items.f_42401_, EMPTY, (Item)ItemRegistry.SPIRIT_FABRIC.get(), Items.f_42049_, (Item)ItemRegistry.SPIRIT_FABRIC.get(), EMPTY, (Item)ItemRegistry.SPIRIT_FABRIC.get(), EMPTY)));
        entries.add(new BookEntry("soul_hunter_gear", (Item)ItemRegistry.SOUL_HUNTER_CLOAK.get(), 4, 7).addPage(new HeadlineTextPage("soul_hunter_armor", "soul_hunter_armor")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_HUNTER_CLOAK.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_HUNTER_ROBE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_HUNTER_LEGGINGS.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_HUNTER_BOOTS.get())));
        entries.add(new BookEntry("spirit_focusing", (Item)ItemRegistry.SPIRIT_CRUCIBLE.get(), 7, 6).addPage(new HeadlineTextPage("spirit_focusing", "spirit_focusing_a")).addPage(new TextPage("spirit_focusing_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SPIRIT_CRUCIBLE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.ALCHEMICAL_IMPETUS.get())));
        entries.add(new BookEntry("working_with_ashes", Items.f_42403_, 6, 5).addPage(new HeadlineTextPage("working_with_ashes", "working_with_ashes")).addPage(SpiritCruciblePage.fromOutput(Items.f_42403_)).addPage(SpiritCruciblePage.fromOutput(Items.f_42525_)).addPage(SpiritCruciblePage.fromOutput(Items.f_42451_)));
        entries.add(new BookEntry("metallurgic_magic", (Item)ItemRegistry.IRON_NODE.get(), 8, 7).addPage(new HeadlineTextPage("metallurgic_magic", "metallurgic_magic_a")).addPage(new TextPage("metallurgic_magic_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.IRON_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.IRON_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.GOLD_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.GOLD_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.COPPER_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.COPPER_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.LEAD_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.LEAD_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SILVER_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.SILVER_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.ALUMINUM_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.ALUMINUM_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.NICKEL_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.NICKEL_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.URANIUM_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.URANIUM_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.OSMIUM_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.OSMIUM_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.ZINC_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.ZINC_NODE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.TIN_IMPETUS.get())).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.TIN_NODE.get())));
        entries.add(new BookEntry("crucible_acceleration", (Item)ItemRegistry.SPIRIT_CATALYZER.get(), 7, 4).addPage(new HeadlineTextPage("crucible_acceleration", "crucible_acceleration_a")).addPage(new TextPage("crucible_acceleration_b")).addPage(new TextPage("crucible_acceleration_c")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SPIRIT_CATALYZER.get())));
        entries.add(new BookEntry("impetus_restoration", (Item)ItemRegistry.TWISTED_TABLET.get(), 7, 8).addPage(new HeadlineTextPage("impetus_restoration", "impetus_restoration_a")).addPage(new TextPage("impetus_restoration_b")).addPage(new TextPage("impetus_restoration_c")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.TWISTED_TABLET.get())).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.CRACKED_ALCHEMICAL_IMPETUS.get())).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.CRACKED_COPPER_IMPETUS.get())).addPage(new HeadlineTextPage("expanded_focusing", "expanded_focusing_a")).addPage(new TextPage("expanded_focusing_b")).addPage(SpiritRepairPage.fromInput(Items.f_42422_)).addPage(SpiritRepairPage.fromInput(Items.f_42427_)).addPage(SpiritRepairPage.fromInput(Items.f_42385_)).addPage(SpiritRepairPage.fromInput(Items.f_42390_)).addPage(SpiritRepairPage.fromInput(Items.f_42432_)).addPage(SpiritRepairPage.fromInput(Items.f_42395_)).addPage(new TextPage("expanded_focusing_c")).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.SOUL_STAINED_STEEL_PICKAXE.get())).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.SOUL_STAINED_STEEL_SCYTHE.get())).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.SOUL_HUNTER_BOOTS.get())));
        entries.add(new BookEntry("crystal_creation", Items.f_42692_, 9, 5).addPage(new HeadlineTextPage("crystal_creation", "crystal_creation")).addPage(SpiritCruciblePage.fromOutput(Items.f_42692_)).addPage(SpiritCruciblePage.fromOutput(Items.f_151049_)).addPage(SpiritCruciblePage.fromOutput((Item)ItemRegistry.BLAZING_QUARTZ.get())).addPage(SpiritCruciblePage.fromOutput(Items.f_42696_)));
        entries.add(new BookEntry("spirit_metals", (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get(), -3, 6).addPage(new HeadlineTextPage("hallowed_gold", "hallowed_gold_a")).addPage(new TextPage("hallowed_gold_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.HALLOWED_GOLD_INGOT.get())).addPage(CraftingBookPage.resonatorPage((Item)ItemRegistry.HALLOWED_SPIRIT_RESONATOR.get(), Items.f_42692_, (Item)ItemRegistry.HALLOWED_GOLD_INGOT.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get())).addPage(new HeadlineTextPage("spirit_jar", "spirit_jar")).addPage(new CraftingBookPage((Item)ItemRegistry.SPIRIT_JAR.get(), Items.f_42027_, (Item)ItemRegistry.HALLOWED_GOLD_INGOT.get(), Items.f_42027_, Items.f_42027_, EMPTY, Items.f_42027_, Items.f_42027_, Items.f_42027_, Items.f_42027_)).addPage(new HeadlineTextPage("soul_stained_steel", "soul_stained_steel_a")).addPage(new TextPage("soul_stained_steel_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addPage(CraftingBookPage.resonatorPage((Item)ItemRegistry.STAINED_SPIRIT_RESONATOR.get(), Items.f_42692_, (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get(), (Item)ItemRegistry.RUNEWOOD_PLANKS.get())).addPage(CraftingBookPage.toolPage((Item)ItemRegistry.SOUL_STAINED_STEEL_PICKAXE.get(), (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addPage(CraftingBookPage.toolPage((Item)ItemRegistry.SOUL_STAINED_STEEL_AXE.get(), (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addPage(CraftingBookPage.toolPage((Item)ItemRegistry.SOUL_STAINED_STEEL_HOE.get(), (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addPage(CraftingBookPage.toolPage((Item)ItemRegistry.SOUL_STAINED_STEEL_SHOVEL.get(), (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addPage(CraftingBookPage.toolPage((Item)ItemRegistry.SOUL_STAINED_STEEL_SWORD.get(), (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addModCompatPage(new CraftingBookPage((Item)ItemRegistry.SOUL_STAINED_STEEL_KNIFE.get(), EMPTY, EMPTY, EMPTY, EMPTY, (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get(), EMPTY, Items.f_42398_), "farmersdelight"));
        entries.add(new BookEntry("soul_stained_scythe", (Item)ItemRegistry.SOUL_STAINED_STEEL_SCYTHE.get(), -4, 5).addPage(new HeadlineTextPage("soul_stained_scythe", "soul_stained_scythe")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_STAINED_STEEL_SCYTHE.get())));
        entries.add(new BookEntry("soul_stained_armor", (Item)ItemRegistry.SOUL_STAINED_STEEL_HELMET.get(), -4, 7).addPage(new HeadlineTextPage("soul_stained_armor", "soul_stained_armor_a")).addPage(new TextPage("soul_stained_armor_b")).addPage(new TextPage("soul_stained_armor_c")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_STAINED_STEEL_HELMET.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_STAINED_STEEL_CHESTPLATE.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_STAINED_STEEL_LEGGINGS.get())).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOUL_STAINED_STEEL_BOOTS.get())));
        entries.add(new BookEntry("spirit_trinkets", (Item)ItemRegistry.ORNATE_RING.get(), -5, 6).addPage(new HeadlineTextPage("spirit_trinkets", "spirit_trinkets_a")).addPage(new TextPage("spirit_trinkets_b")).addPage(CraftingBookPage.ringPage((Item)ItemRegistry.GILDED_RING.get(), Items.f_42454_, (Item)ItemRegistry.HALLOWED_GOLD_INGOT.get())).addPage(new CraftingBookPage((Item)ItemRegistry.GILDED_BELT.get(), Items.f_42454_, Items.f_42454_, Items.f_42454_, (Item)ItemRegistry.HALLOWED_GOLD_INGOT.get(), (Item)ItemRegistry.PROCESSED_SOULSTONE.get(), (Item)ItemRegistry.HALLOWED_GOLD_INGOT.get(), EMPTY, (Item)ItemRegistry.HALLOWED_GOLD_INGOT.get(), EMPTY)).addPage(CraftingBookPage.ringPage((Item)ItemRegistry.ORNATE_RING.get(), Items.f_42454_, (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get())).addPage(new CraftingBookPage((Item)ItemRegistry.ORNATE_NECKLACE.get(), EMPTY, Items.f_42401_, EMPTY, Items.f_42401_, EMPTY, Items.f_42401_, EMPTY, (Item)ItemRegistry.SOUL_STAINED_STEEL_INGOT.get(), EMPTY)).addPage(new HeadlineTextPage("arcane_reach", "arcane_reach")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RING_OF_ARCANE_REACH.get())).addPage(new HeadlineTextPage("arcane_spoil", "arcane_spoil")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RING_OF_ARCANE_SPOIL.get())));
        entries.add(new BookEntry("ring_of_prowess", (Item)ItemRegistry.RING_OF_PROWESS.get(), -7, 6).addPage(new HeadlineTextPage("ring_of_prowess", "ring_of_prowess_a")).addPage(new TextPage("ring_of_prowess_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RING_OF_PROWESS.get())));
        entries.add(new BookEntry("ring_of_wicked_intent", (Item)ItemRegistry.RING_OF_WICKED_INTENT.get(), -7, 8).addPage(new HeadlineTextPage("ring_of_wicked_intent", "ring_of_wicked_intent")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RING_OF_WICKED_INTENT.get())));
        entries.add(new BookEntry("ring_of_curative_talent", (Item)ItemRegistry.RING_OF_CURATIVE_TALENT.get(), -7, 4).addPage(new HeadlineTextPage("ring_of_curative_talent", "ring_of_curative_talent")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RING_OF_CURATIVE_TALENT.get())));
        entries.add(new BookEntry("necklace_of_the_mystic_mirror", (Item)ItemRegistry.NECKLACE_OF_THE_MYSTIC_MIRROR.get(), -6, 5).addPage(new HeadlineTextPage("necklace_of_the_mystic_mirror", "necklace_of_the_mystic_mirror")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.NECKLACE_OF_THE_MYSTIC_MIRROR.get())));
        entries.add(new BookEntry("necklace_of_the_narrow_edge", (Item)ItemRegistry.NECKLACE_OF_THE_NARROW_EDGE.get(), -8, 7).addPage(new HeadlineTextPage("necklace_of_the_narrow_edge", "necklace_of_the_narrow_edge")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.NECKLACE_OF_THE_NARROW_EDGE.get())));
        entries.add(new BookEntry("warded_belt", (Item)ItemRegistry.WARDED_BELT.get(), -9, 5).addPage(new HeadlineTextPage("warded_belt", "warded_belt")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.WARDED_BELT.get())));
        entries.add(new BookEntry("mirror_magic", (Item)ItemRegistry.SPECTRAL_LENS.get(), -6, 10).setObjectSupplier(ImportantEntryObject::new).addPage(new HeadlineTextPage("mirror_magic", "mirror_magic")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SPECTRAL_LENS.get())));
        entries.add(new BookEntry("voodoo_magic", (Item)ItemRegistry.POPPET.get(), 6, 10).setObjectSupplier(ImportantEntryObject::new).addPage(new HeadlineTextPage("voodoo_magic", "voodoo_magic")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.POPPET.get())));
        entries.add(new BookEntry("altar_acceleration", (Item)ItemRegistry.RUNEWOOD_OBELISK.get(), -1, 8).addPage(new HeadlineTextPage("runewood_obelisk", "runewood_obelisk")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RUNEWOOD_OBELISK.get())).addPage(new HeadlineTextPage("brilliant_obelisk", "brilliant_obelisk")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.BRILLIANT_OBELISK.get())));
        entries.add(new BookEntry("totem_magic", (Item)ItemRegistry.RUNEWOOD_TOTEM_BASE.get(), 0, 9).setObjectSupplier(ImportantEntryObject::new).addPage(new HeadlineTextPage("totem_magic", "totem_magic_a")).addPage(new TextPage("totem_magic_b")).addPage(new TextPage("totem_magic_c")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.RUNEWOOD_TOTEM_BASE.get())));
        entries.add(new BookEntry("arcane_rite", (Item)ItemRegistry.ARCANE_SPIRIT.get(), 0, 11).addPage(new HeadlineTextPage("totem_corruption", "totem_corruption_a")).addPage(new TextPage("totem_corruption_b")).addPage(new DoubleHeadlineTextPage("rite_effect", "arcane_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ARCANE_RITE)).addPage(new TextPage("totem_corruption_c")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.SOULWOOD_TOTEM_BASE.get())));
        entries.add(new BookEntry("sacred_rite", (Item)ItemRegistry.SACRED_SPIRIT.get(), -2, 11).addPage(new DoubleHeadlineTextPage("rite_effect", "sacred_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.SACRED_RITE)).addPage(new DoubleHeadlineTextPage("rite_effect", "eldritch_sacred_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ELDRITCH_SACRED_RITE)));
        entries.add(new BookEntry("wicked_rite", (Item)ItemRegistry.WICKED_SPIRIT.get(), 2, 11).addPage(new DoubleHeadlineTextPage("rite_effect", "wicked_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.WICKED_RITE)).addPage(new DoubleHeadlineTextPage("rite_effect", "eldritch_wicked_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ELDRITCH_WICKED_RITE)));
        entries.add(new BookEntry("earthen_rite", (Item)ItemRegistry.EARTHEN_SPIRIT.get(), -1, 12).addPage(new DoubleHeadlineTextPage("rite_effect", "earthen_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.EARTHEN_RITE)).addPage(new DoubleHeadlineTextPage("rite_effect", "eldritch_earthen_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ELDRITCH_EARTHEN_RITE)));
        entries.add(new BookEntry("infernal_rite", (Item)ItemRegistry.INFERNAL_SPIRIT.get(), 1, 12).addPage(new DoubleHeadlineTextPage("rite_effect", "infernal_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.INFERNAL_RITE)).addPage(new DoubleHeadlineTextPage("rite_effect", "eldritch_infernal_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ELDRITCH_INFERNAL_RITE)));
        entries.add(new BookEntry("aerial_rite", (Item)ItemRegistry.AERIAL_SPIRIT.get(), -1, 10).addPage(new DoubleHeadlineTextPage("rite_effect", "aerial_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.AERIAL_RITE)).addPage(new DoubleHeadlineTextPage("rite_effect", "eldritch_aerial_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ELDRITCH_AERIAL_RITE)));
        entries.add(new BookEntry("aqueous_rite", (Item)ItemRegistry.AQUEOUS_SPIRIT.get(), 1, 10).addPage(new DoubleHeadlineTextPage("rite_effect", "aqueous_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.AQUEOUS_RITE)).addPage(new DoubleHeadlineTextPage("rite_effect", "eldritch_aqueous_rite")).addPage(new SpiritRitePage(SpiritRiteRegistry.ELDRITCH_AQUEOUS_RITE)));
        entries.add(new BookEntry("soulwood", (Item)ItemRegistry.SOULWOOD_SAPLING.get(), 0, 13).addPage(new HeadlineTextPage("soulwood", "soulwood_a")).addPage(new TextPage("soulwood_b")).addPage(CraftingBookPage.itemPedestalPage((Item)ItemRegistry.SOULWOOD_ITEM_PEDESTAL.get(), (Item)ItemRegistry.SOULWOOD_PLANKS.get(), (Item)ItemRegistry.SOULWOOD_PLANKS_SLAB.get())).addPage(CraftingBookPage.itemStandPage((Item)ItemRegistry.SOULWOOD_ITEM_STAND.get(), (Item)ItemRegistry.SOULWOOD_PLANKS.get(), (Item)ItemRegistry.SOULWOOD_PLANKS_SLAB.get())).addPage(new SmeltingBookPage((Item)ItemRegistry.SOULWOOD_LOG.get(), (Item)ItemRegistry.ARCANE_CHARCOAL.get())).addPage(CraftingBookPage.fullPage((Item)ItemRegistry.BLOCK_OF_ARCANE_CHARCOAL.get(), (Item)ItemRegistry.ARCANE_CHARCOAL.get())).addPage(new CraftingBookPage(new ItemStack((ItemLike)ItemRegistry.UNHOLY_SAPBALL.get(), 3), Items.f_42518_, (Item)ItemRegistry.UNHOLY_SAP.get())).addPage(new SmeltingBookPage((Item)ItemRegistry.UNHOLY_SAP.get(), (Item)ItemRegistry.UNHOLY_SYRUP.get())));
        entries.add(new BookEntry("magebane_belt", (Item)ItemRegistry.MAGEBANE_BELT.get(), 1, 15).addPage(new HeadlineTextPage("magebane_belt", "magebane_belt")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.MAGEBANE_BELT.get())));
        entries.add(new BookEntry("tyrving", (Item)ItemRegistry.TYRVING.get(), -1, 15).addPage(new HeadlineTextPage("tyrving", "tyrving_a")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.TYRVING.get())).addPage(new TextPage("tyrving_b")).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.TYRVING.get())));
        entries.add(new BookEntry("ceaseless_impetus", (Item)ItemRegistry.CEASELESS_IMPETUS.get(), 0, 16).addPage(new HeadlineTextPage("ceaseless_impetus", "ceaseless_impetus_a")).addPage(new TextPage("ceaseless_impetus_b")).addPage(SpiritInfusionPage.fromOutput((Item)ItemRegistry.CEASELESS_IMPETUS.get())).addPage(SpiritRepairPage.fromInput((Item)ItemRegistry.CRACKED_CEASELESS_IMPETUS.get())));
        entries.add(new BookEntry("huh", (Item)ItemRegistry.THE_DEVICE.get(), 0, -10).setObjectSupplier(VanishingEntryObject::new).addPage(new HeadlineTextPage("the_device", "the_device")).addPage(new CraftingBookPage((Item)ItemRegistry.THE_DEVICE.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK.get(), (Item)ItemRegistry.TAINTED_ROCK.get(), (Item)ItemRegistry.TWISTED_ROCK.get())));
    }

    public void setupObjects() {
        objects.clear();
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        int guiLeft = (this.f_96543_ - this.bookWidth) / 2;
        int guiTop = (this.f_96544_ - this.bookHeight) / 2;
        int coreX = guiLeft + this.bookInsideWidth;
        int coreY = guiTop + this.bookInsideHeight;
        int width = 40;
        int height = 48;
        for (BookEntry entry : entries) {
            objects.add(entry.objectSupplier.getBookObject(entry, coreX + entry.xOffset * width, coreY - entry.yOffset * height));
        }
        this.faceObject(objects.get(0));
    }

    public void faceObject(BookObject object) {
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        int guiLeft = (this.f_96543_ - this.bookWidth) / 2;
        int guiTop = (this.f_96544_ - this.bookHeight) / 2;
        this.xOffset = -object.posX + guiLeft + this.bookInsideWidth;
        this.yOffset = -object.posY + guiTop + this.bookInsideHeight;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int guiLeft = (this.f_96543_ - this.bookWidth) / 2;
        int guiTop = (this.f_96544_ - this.bookHeight) / 2;
        this.renderBackground(BACKGROUND_TEXTURE, poseStack, 0.1f, 0.4f);
        GL11.glEnable((int)3089);
        this.cut();
        this.renderEntries(poseStack, mouseX, mouseY, partialTicks);
        ScreenParticleHandler.renderParticles((ScreenParticle.RenderOrder[])new ScreenParticle.RenderOrder[]{ScreenParticle.RenderOrder.BEFORE_TOOLTIPS});
        GL11.glDisable((int)3089);
        ProgressionBookScreen.renderTransparentTexture(FADE_TEXTURE, poseStack, guiLeft, guiTop, 1.0f, 1.0f, this.bookWidth, this.bookHeight, 512, 512);
        ProgressionBookScreen.renderTexture(FRAME_TEXTURE, poseStack, guiLeft, guiTop, 1.0f, 1.0f, this.bookWidth, this.bookHeight, 512, 512);
        this.lateEntryRender(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.xOffset = (float)((double)this.xOffset + dragX);
        this.yOffset = (float)((double)this.yOffset + dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.cachedXOffset = this.xOffset;
        this.cachedYOffset = this.yOffset;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.ignoreNextMouseInput) {
            this.ignoreNextMouseInput = false;
            return super.m_6348_(mouseX, mouseY, button);
        }
        if (this.xOffset != this.cachedXOffset || this.yOffset != this.cachedYOffset) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        for (BookObject object : objects) {
            if (!object.isHovering(this.xOffset, this.yOffset, mouseX, mouseY)) continue;
            object.click(this.xOffset, this.yOffset, mouseX, mouseY);
            break;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void renderEntries(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        for (int i = objects.size() - 1; i >= 0; --i) {
            float f;
            boolean isHovering;
            BookObject object = objects.get(i);
            object.isHovering = isHovering = object.isHovering(this.xOffset, this.yOffset, mouseX, mouseY);
            if (isHovering) {
                float f2 = object.hover;
                object.hover = f2 + 1.0f;
                f = Math.min(f2, (float)object.hoverCap());
            } else {
                float f3 = object.hover;
                object.hover = f3 - 1.0f;
                f = Math.max(f3, 0.0f);
            }
            object.hover = f;
            object.render(this.f_96541_, stack, this.xOffset, this.yOffset, mouseX, mouseY, partialTicks);
        }
    }

    public void lateEntryRender(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        for (int i = objects.size() - 1; i >= 0; --i) {
            BookObject object = objects.get(i);
            object.lateRender(this.f_96541_, stack, this.xOffset, this.yOffset, mouseX, mouseY, partialTicks);
        }
    }

    public static boolean isHovering(double mouseX, double mouseY, int posX, int posY, int width, int height) {
        if (!ProgressionBookScreen.isInView(mouseX, mouseY)) {
            return false;
        }
        return mouseX > (double)posX && mouseX < (double)(posX + width) && mouseY > (double)posY && mouseY < (double)(posY + height);
    }

    public static boolean isInView(double mouseX, double mouseY) {
        int guiLeft = (ProgressionBookScreen.screen.f_96543_ - ProgressionBookScreen.screen.bookWidth) / 2;
        int guiTop = (ProgressionBookScreen.screen.f_96544_ - ProgressionBookScreen.screen.bookHeight) / 2;
        return !(mouseX < (double)(guiLeft + 17) || mouseY < (double)(guiTop + 14) || mouseX > (double)(guiLeft + (ProgressionBookScreen.screen.bookWidth - 17)) || mouseY > (double)(guiTop + ProgressionBookScreen.screen.bookHeight - 14));
    }

    public void renderBackground(ResourceLocation texture, PoseStack poseStack, float xModifier, float yModifier) {
        int guiLeft = (this.f_96543_ - this.bookWidth) / 2;
        int guiTop = (this.f_96544_ - this.bookHeight) / 2;
        int insideLeft = guiLeft + 17;
        int insideTop = guiTop + 14;
        float uOffset = (1024.0f - this.xOffset) * xModifier;
        float vOffset = Math.min((float)(2560 - this.bookInsideHeight), (float)(2560 - this.bookInsideHeight) - this.yOffset * yModifier);
        if (vOffset <= 1280.0f) {
            vOffset = 1280.0f;
        }
        if (uOffset <= 0.0f) {
            uOffset = 0.0f;
        }
        if (uOffset > (float)(this.bookInsideWidth - 8) / 2.0f) {
            uOffset = (float)(this.bookInsideWidth - 8) / 2.0f;
        }
        ProgressionBookScreen.renderTexture(texture, poseStack, insideLeft, insideTop, uOffset, vOffset, this.bookInsideWidth, this.bookInsideHeight, 512, 1280);
    }

    public void cut() {
        int scale = (int)this.getMinecraft().m_91268_().m_85449_();
        int guiLeft = (this.f_96543_ - this.bookWidth) / 2;
        int guiTop = (this.f_96544_ - this.bookHeight) / 2;
        int insideLeft = guiLeft + 17;
        int insideTop = guiTop + 18;
        GL11.glScissor((int)(insideLeft * scale), (int)(insideTop * scale), (int)(this.bookInsideWidth * scale), (int)((this.bookInsideHeight + 1) * scale));
    }

    public static void renderTexture(ResourceLocation texture, PoseStack poseStack, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderHelper.blit((PoseStack)poseStack, (int)x, (int)y, (double)width, (double)height, (float)uOffset, (float)vOffset, (float)textureWidth, (float)textureHeight);
    }

    public static void renderTransparentTexture(ResourceLocation texture, PoseStack poseStack, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        ProgressionBookScreen.renderTexture(texture, poseStack, x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
    }

    public static void renderComponents(PoseStack poseStack, List<? extends IRecipeComponent> components, int left, int top, int mouseX, int mouseY, boolean vertical) {
        List<ItemStack> items = components.stream().map(IRecipeComponent::getStack).collect(Collectors.toList());
        ProgressionBookScreen.renderItemList(poseStack, items, left, top, mouseX, mouseY, vertical);
    }

    public static void renderComponent(PoseStack poseStack, IRecipeComponent component, int posX, int posY, int mouseX, int mouseY) {
        if (component.getStacks().size() == 1) {
            ProgressionBookScreen.renderItem(poseStack, component.getStack(), posX, posY, mouseX, mouseY);
            return;
        }
        int index = (int)(Minecraft.m_91087_().f_91073_.m_46467_() % (20L * (long)component.getStacks().size()) / 20L);
        ItemStack stack = (ItemStack)component.getStacks().get(index);
        Minecraft.m_91087_().m_91291_().m_115203_(stack, posX, posY);
        Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, stack, posX, posY, null);
        if (ProgressionBookScreen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
            screen.m_96602_(poseStack, (Component)new TranslatableComponent(stack.m_41778_()), mouseX, mouseY);
        }
    }

    public static void renderItem(PoseStack poseStack, Ingredient ingredient, int posX, int posY, int mouseX, int mouseY) {
        ProgressionBookScreen.renderItem(poseStack, List.of(ingredient.m_43908_()), posX, posY, mouseX, mouseY);
    }

    public static void renderItem(PoseStack poseStack, List<ItemStack> stacks, int posX, int posY, int mouseX, int mouseY) {
        if (stacks.size() == 1) {
            ProgressionBookScreen.renderItem(poseStack, stacks.get(0), posX, posY, mouseX, mouseY);
            return;
        }
        int index = (int)(Minecraft.m_91087_().f_91073_.m_46467_() % (20L * (long)stacks.size()) / 20L);
        ItemStack stack = stacks.get(index);
        Minecraft.m_91087_().m_91291_().m_115203_(stack, posX, posY);
        Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, stack, posX, posY, null);
        if (ProgressionBookScreen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
            screen.m_96602_(poseStack, (Component)new TranslatableComponent(stack.m_41778_()), mouseX, mouseY);
        }
    }

    public static void renderItem(PoseStack poseStack, ItemStack stack, int posX, int posY, int mouseX, int mouseY) {
        Minecraft.m_91087_().m_91291_().m_115203_(stack, posX, posY);
        Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, stack, posX, posY, null);
        if (ProgressionBookScreen.isHovering(mouseX, mouseY, posX, posY, 16, 16)) {
            screen.m_96602_(poseStack, (Component)new TranslatableComponent(stack.m_41778_()), mouseX, mouseY);
        }
    }

    public static void renderItemList(PoseStack poseStack, List<ItemStack> items, int left, int top, int mouseX, int mouseY, boolean vertical) {
        int slots = items.size();
        ProgressionBookScreen.renderItemFrames(poseStack, left, top, vertical, slots);
        if (vertical) {
            top -= 10 * (slots - 1);
        } else {
            left -= 10 * (slots - 1);
        }
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = items.get(i);
            int offset = i * 20;
            int oLeft = left + 2 + (vertical ? 0 : offset);
            int oTop = top + 2 + (vertical ? offset : 0);
            ProgressionBookScreen.renderItem(poseStack, stack, oLeft, oTop, mouseX, mouseY);
        }
    }

    public static void renderItemFrames(PoseStack poseStack, int left, int top, boolean vertical, int slots) {
        if (vertical) {
            top -= 10 * (slots - 1);
        } else {
            left -= 10 * (slots - 1);
        }
        for (int i = 0; i < slots; ++i) {
            int offset = i * 20;
            int oLeft = left + (vertical ? 0 : offset);
            int oTop = top + (vertical ? offset : 0);
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, oLeft, oTop, 75.0f, 192.0f, 20, 20, 512, 512);
            if (vertical) {
                if (slots > 1 && i != slots - 1) {
                    ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, left + 1, oTop + 19, 75.0f, 213.0f, 18, 2, 512, 512);
                }
                if (i != slots - 1) continue;
                ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, oLeft + 1, oTop + 19, 75.0f, 216.0f, 18, 2, 512, 512);
                continue;
            }
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, oLeft + 1, top + 19, 75.0f, 216.0f, 18, 2, 512, 512);
            if (slots <= 1 || i == slots - 1) continue;
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, oLeft + 19, top, 96.0f, 192.0f, 2, 20, 512, 512);
        }
        int crownLeft = left + 5 + (vertical ? 0 : 10 * (slots - 1));
        ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, crownLeft, top - 5, 128.0f, 192.0f, 10, 6, 512, 512);
        if (vertical) {
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, left - 4, top - 4, 99.0f, 200.0f, 28, 7, 512, 512);
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, left - 4, top + 17 + 20 * (slots - 1), 99.0f, 192.0f, 28, 7, 512, 512);
        } else {
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, left - 4, top - 4, 59.0f, 192.0f, 7, 28, 512, 512);
            ProgressionBookScreen.renderTexture(EntryScreen.BOOK_TEXTURE, poseStack, left + 17 + 20 * (slots - 1), top - 4, 67.0f, 192.0f, 7, 28, 512, 512);
        }
    }

    public static void renderWrappingText(PoseStack mStack, String text, int x, int y, int w) {
        Font font = Minecraft.m_91087_().f_91062_;
        text = new TranslatableComponent(text).getString();
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        Object line = "";
        for (String s : words) {
            if (font.m_92895_((String)line) + font.m_92895_(s) > w) {
                lines.add((String)line);
                line = s + " ";
                continue;
            }
            line = (String)line + s + " ";
        }
        if (!((String)line).isEmpty()) {
            lines.add((String)line);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String currentLine = (String)lines.get(i);
            Objects.requireNonNull(font);
            ProgressionBookScreen.renderRawText(mStack, currentLine, x, y + i * (9 + 1), ProgressionBookScreen.getTextGlow((float)i / 4.0f));
        }
    }

    public static void renderText(PoseStack stack, String text, int x, int y) {
        ProgressionBookScreen.renderText(stack, (Component)new TranslatableComponent(text), x, y, ProgressionBookScreen.getTextGlow(0.0f));
    }

    public static void renderText(PoseStack stack, Component component, int x, int y) {
        String text = component.getString();
        ProgressionBookScreen.renderRawText(stack, text, x, y, ProgressionBookScreen.getTextGlow(0.0f));
    }

    public static void renderText(PoseStack stack, String text, int x, int y, float glow) {
        ProgressionBookScreen.renderText(stack, (Component)new TranslatableComponent(text), x, y, glow);
    }

    public static void renderText(PoseStack stack, Component component, int x, int y, float glow) {
        String text = component.getString();
        ProgressionBookScreen.renderRawText(stack, text, x, y, glow);
    }

    private static void renderRawText(PoseStack stack, String text, int x, int y, float glow) {
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92883_(stack, text, (float)(x - 1), (float)y, FastColor.ARGB32.m_13660_((int)96, (int)236, (int)227, (int)214));
        font.m_92883_(stack, text, (float)(x + 1), (float)y, FastColor.ARGB32.m_13660_((int)128, (int)165, (int)149, (int)142));
        font.m_92883_(stack, text, (float)x, (float)(y - 1), FastColor.ARGB32.m_13660_((int)128, (int)208, (int)197, (int)183));
        font.m_92883_(stack, text, (float)x, (float)(y + 1), FastColor.ARGB32.m_13660_((int)96, (int)236, (int)110, (int)226));
        font.m_92883_(stack, text, (float)x, (float)y, FastColor.ARGB32.m_13660_((int)255, (int)111, (int)97, (int)105));
    }

    public static float getTextGlow(float offset) {
        return Mth.m_14031_((float)(offset + (float)Minecraft.m_91087_().f_91074_.f_19853_.m_46467_() / 40.0f)) / 2.0f + 0.5f;
    }

    public void playSound() {
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        playerEntity.m_6330_(SoundEvents.f_11713_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void openScreen(boolean ignoreNextMouseClick) {
        Minecraft.m_91087_().m_91152_((Screen)ProgressionBookScreen.getInstance());
        ScreenParticleHandler.wipeParticles((ScreenParticle.RenderOrder[])new ScreenParticle.RenderOrder[0]);
        screen.playSound();
        ProgressionBookScreen.screen.ignoreNextMouseInput = ignoreNextMouseClick;
    }

    public static ProgressionBookScreen getInstance() {
        if (screen == null) {
            screen = new ProgressionBookScreen();
        }
        return screen;
    }

    static {
        entries = new ArrayList();
        objects = new ArrayList();
    }
}

