/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex;

import com.sammy.malum.client.screen.codex.objects.EntryObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import java.util.ArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class BookEntry {
    public final ItemStack iconStack;
    public final String identifier;
    public final int xOffset;
    public final int yOffset;
    public ArrayList<BookPage> pages = new ArrayList();
    public EntryObjectSupplier objectSupplier = EntryObject::new;

    public BookEntry(String identifier, Item item, int xOffset, int yOffset) {
        this.iconStack = item.m_7968_();
        this.identifier = identifier;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public String translationKey() {
        return "malum.gui.book.entry." + this.identifier;
    }

    public String descriptionTranslationKey() {
        return "malum.gui.book.entry." + this.identifier + ".description";
    }

    public BookEntry addPage(BookPage page) {
        if (page.isValid()) {
            this.pages.add(page);
        }
        return this;
    }

    public BookEntry addModCompatPage(BookPage page, String modId) {
        if (ModList.get().isLoaded(modId)) {
            this.pages.add(page);
        }
        return this;
    }

    public BookEntry setObjectSupplier(EntryObjectSupplier objectSupplier) {
        this.objectSupplier = objectSupplier;
        return this;
    }

    public static interface EntryObjectSupplier {
        public EntryObject getBookObject(BookEntry var1, int var2, int var3);
    }
}

