/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.entity.spirit.SoulEntity;
import com.sammy.ortus.handlers.RenderHandler;
import com.sammy.ortus.helpers.ColorHelper;
import com.sammy.ortus.helpers.RenderHelper;
import com.sammy.ortus.setup.OrtusRenderTypes;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SoulEntityRenderer
extends EntityRenderer<SoulEntity> {
    public final ItemRenderer itemRenderer;
    private static final ResourceLocation SOUL_NOISE = MalumMod.prefix("textures/vfx/noise/soul_noise.png");
    private static final RenderType SOUL_NOISE_TYPE = (RenderType)OrtusRenderTypes.RADIAL_NOISE.apply(SOUL_NOISE);
    private static final ResourceLocation SECONDARY_SOUL_NOISE = MalumMod.prefix("textures/vfx/noise/soul_noise_secondary.png");
    private static final RenderType SECONDARY_SOUL_NOISE_TYPE = (RenderType)OrtusRenderTypes.RADIAL_SCATTER_NOISE.apply(SECONDARY_SOUL_NOISE);
    private static final ResourceLocation TRINARY_SOUL_NOISE = MalumMod.prefix("textures/vfx/noise/soul_noise_trinary.png");
    private static final RenderType TRINARY_SOUL_NOISE_TYPE = (RenderType)OrtusRenderTypes.RADIAL_SCATTER_NOISE.apply(TRINARY_SOUL_NOISE);

    public SoulEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.f_114477_ = 0.0f;
        this.f_114478_ = 0.0f;
    }

    public void render(SoulEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.25 + (double)entityIn.getYOffset(partialTicks), 0.0);
        SoulEntityRenderer.renderSoul(poseStack, entityIn.color.darker());
        poseStack.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(SoulEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public static void renderSoul(PoseStack poseStack, Color color) {
        poseStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        VertexConsumer soulNoise = RenderHandler.DELAYED_RENDER.m_6299_(OrtusRenderTypes.queueUniformChanges((RenderType)SOUL_NOISE_TYPE, instance -> {
            instance.m_173356_("Speed").m_5985_(2500.0f);
            instance.m_173356_("Intensity").m_5985_(25.0f);
        }));
        VertexConsumer secondarySoulNoise = RenderHandler.DELAYED_RENDER.m_6299_(OrtusRenderTypes.queueUniformChanges((RenderType)SECONDARY_SOUL_NOISE_TYPE, instance -> {
            instance.m_173356_("Speed").m_5985_(-1500.0f);
            instance.m_173356_("ScatterPower").m_5985_(-20.0f);
            instance.m_173356_("Intensity").m_5985_(35.0f);
        }));
        VertexConsumer trinarySoulNoise = RenderHandler.DELAYED_RENDER.m_6299_(OrtusRenderTypes.queueUniformChanges((RenderType)TRINARY_SOUL_NOISE_TYPE, instance -> {
            instance.m_173356_("Speed").m_5985_(-2000.0f);
            instance.m_173356_("ScatterPower").m_5985_(30.0f);
            instance.m_173356_("Intensity").m_5985_(55.0f);
        }));
        RenderHelper.create().setColor(color.brighter()).setAlpha(1.0f).setLight(0xF000F0).renderQuad(soulNoise, poseStack, 0.6f).setColor(ColorHelper.brighter((Color)color, (int)2)).renderQuad(secondarySoulNoise, poseStack, 0.7f).renderQuad(trinarySoulNoise, poseStack, 0.8f);
    }
}

