/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.ortus.setup.OrtusRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class FloatingItemEntityRenderer
extends EntityRenderer<FloatingItemEntity> {
    public final ItemRenderer itemRenderer;
    private static final ResourceLocation LIGHT_TRAIL = MalumMod.prefix("textures/vfx/light_trail.png");
    private static final RenderType LIGHT_TYPE = (RenderType)OrtusRenderTypes.ADDITIVE_TEXTURE.apply(LIGHT_TRAIL);

    public FloatingItemEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.f_114477_ = 0.0f;
        this.f_114478_ = 0.0f;
    }

    public void render(FloatingItemEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        ItemStack itemStack = entity.getItem();
        BakedModel model = this.itemRenderer.m_174264_(itemStack, entity.f_19853_, null, entity.getItem().m_41613_());
        float yOffset = entity.getYOffset(partialTicks);
        float scale = model.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        float rotation = entity.getRotation(partialTicks);
        poseStack.m_85837_(0.0, (double)(yOffset + 0.25f * scale), 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122270_(rotation));
        this.itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GROUND, false, poseStack, bufferIn, packedLightIn, OverlayTexture.f_118083_, model);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(FloatingItemEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

