/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.curio;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.equipment.curios.CurioTokenOfGratitude;
import com.sammy.malum.core.setup.content.item.ItemRegistry;
import com.sammy.ortus.setup.OrtusRenderTypes;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class TokenOfGratitudeRenderer
implements ICurioRenderer {
    private static final ResourceLocation SAMMY = MalumMod.prefix("textures/other/sammy_texture.png");
    private static final ResourceLocation OWL_PERSON = MalumMod.prefix("textures/other/owl_person_texture.png");

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer playerEntity = (AbstractClientPlayer)livingEntity;
            if (playerEntity.m_142081_().equals(CurioTokenOfGratitude.SAMMY)) {
                poseStack.m_85836_();
                Vec3 movement = new Vec3(playerEntity.m_20184_().f_82479_, 0.0, playerEntity.m_20184_().f_82481_);
                double wagSpeed = playerEntity.m_20184_().m_82553_();
                if (wagSpeed != 0.0) {
                    double factor = 55.0;
                    Vec3 yawLook = Vec3.m_82498_((float)0.0f, (float)playerEntity.m_146908_());
                    Vec3 look = new Vec3(yawLook.f_82479_, 0.0, yawLook.f_82481_);
                    Vec3 desiredDirection = look.m_82524_((float)Math.toRadians(90.0)).m_82541_();
                    Vec3 sidewaysVelocity = desiredDirection.m_82490_(movement.m_82526_(desiredDirection));
                    double speedAndDirection = sidewaysVelocity.m_82553_() * -Math.signum(desiredDirection.m_82526_(sidewaysVelocity)) / wagSpeed;
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(speedAndDirection * factor)));
                }
                float ambientFactor = playerEntity.m_6144_() ? 2.0f : 6.0f;
                double ambientXRotation = Math.sin((float)playerEntity.f_19853_.m_46467_() / 18.0f) * (double)ambientFactor;
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_((float)ambientXRotation));
                double ambientYRotation = Math.cos((float)playerEntity.f_19853_.m_46467_() / 24.0f) * (double)(-ambientFactor);
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)ambientYRotation));
                VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)SAMMY), (boolean)false, (boolean)stack.m_41790_());
                ItemRegistry.ClientOnly.TAIL_MODEL.setupAnim((Player)playerEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                ItemRegistry.ClientOnly.TAIL_MODEL.m_6839_((Entity)playerEntity, limbSwing, limbSwingAmount, partialTicks);
                ICurioRenderer.translateIfSneaking((PoseStack)poseStack, (LivingEntity)playerEntity);
                ICurioRenderer.rotateIfSneaking((PoseStack)poseStack, (LivingEntity)playerEntity);
                ItemRegistry.ClientOnly.TAIL_MODEL.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
            if (playerEntity.m_142081_().equals(CurioTokenOfGratitude.OWL_PERSON)) {
                poseStack.m_85836_();
                TokenOfGratitudeRenderer.renderGlowingEyes(playerEntity, OWL_PERSON, poseStack, renderTypeBuffer);
                poseStack.m_85849_();
            }
        }
    }

    public static void renderGlowingEyes(AbstractClientPlayer playerEntity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource renderTypeBuffer) {
        VertexConsumer vertexconsumer = renderTypeBuffer.m_6299_((RenderType)OrtusRenderTypes.SOLID_TEXTURE.apply(texture));
        ICurioRenderer.followHeadRotations((LivingEntity)playerEntity, (ModelPart[])new ModelPart[]{ItemRegistry.ClientOnly.HEAD_OVERLAY_MODEL.overlay});
        ItemRegistry.ClientOnly.HEAD_OVERLAY_MODEL.m_7695_(poseStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

