/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.blockshot.WebUtils;
import net.creeperhost.polylib.client.screen.widget.LoadingSpinner;
import net.creeperhost.polylib.client.screen.widget.ScreenList;
import net.creeperhost.polylib.client.screen.widget.ScreenListEntry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BlockShotHistoryScreen
extends Screen {
    private Button deleteButton;
    private Button viewButton;
    private Button copyButton;
    private ScreenList<BlockShotHistoryEntry> list;
    public Screen parent;
    boolean isLoading = true;
    int ticks = 0;
    BlockShotHistoryEntry lastSelected;
    AtomicReference<List<ScreencapListItem>> caps = new AtomicReference();
    private boolean hasRequested = false;

    public BlockShotHistoryScreen(Screen parent) {
        super((Component)new TextComponent("BlockShot Upload History"));
        this.parent = parent;
        if (this.caps.get() == null) {
            this.caps.getAndSet(new ArrayList());
        }
    }

    protected void m_7856_() {
        this.list = new ScreenList((Screen)this, this.f_96541_, this.f_96543_, this.f_96544_, 56, this.f_96544_ - 36, 36);
        this.loadRemote().thenRun(() -> {
            this.isLoading = false;
        });
        this.m_142416_((GuiEventListener)this.list);
        this.copyButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 152, this.f_96544_ - 28, 72, 20, (Component)new TranslatableComponent("Copy URL"), arg -> ((BlockShotHistoryEntry)this.list.getCurrSelected()).copyUrl()));
        this.deleteButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 76, this.f_96544_ - 28, 72, 20, (Component)new TranslatableComponent("selectWorld.delete"), arg -> {
            try {
                this.copyButton.f_93623_ = false;
                this.deleteButton.f_93623_ = false;
                this.viewButton.f_93623_ = false;
                CompletableFuture.runAsync(() -> {
                    this.isLoading = true;
                    ((BlockShotHistoryEntry)this.list.getCurrSelected()).delete();
                    this.caps.getAndUpdate(a -> {
                        a.clear();
                        return a;
                    });
                    this.hasRequested = false;
                    this.loadRemote().thenRun(() -> {
                        this.isLoading = false;
                    });
                }).thenRun(() -> {});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        this.viewButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2, this.f_96544_ - 28, 72, 20, (Component)new TextComponent("View"), arg -> ((BlockShotHistoryEntry)this.list.getCurrSelected()).openUrl()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 76, this.f_96544_ - 28, 72, 20, CommonComponents.f_130656_, arg -> this.f_96541_.m_91152_(this.parent)));
        this.copyButton.f_93623_ = false;
        this.deleteButton.f_93623_ = false;
        this.viewButton.f_93623_ = false;
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, i, j, f);
        if (this.list.getCurrSelected() != null && this.list.getCurrSelected() != this.lastSelected) {
            this.copyButton.f_93623_ = !((BlockShotHistoryEntry)this.list.getCurrSelected()).isDeleting;
            this.deleteButton.f_93623_ = !((BlockShotHistoryEntry)this.list.getCurrSelected()).isDeleting;
            this.viewButton.f_93623_ = !((BlockShotHistoryEntry)this.list.getCurrSelected()).isDeleting;
            this.lastSelected = (BlockShotHistoryEntry)this.list.getCurrSelected();
        }
        if (this.isLoading) {
            ++this.ticks;
            LoadingSpinner.render((PoseStack)poseStack, (float)f, (int)this.ticks, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (ItemStack)new ItemStack((ItemLike)Items.f_42580_));
        }
        BlockShotHistoryScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)18, (int)0xFFFFFF);
    }

    private CompletableFuture<?> loadRemote() {
        return CompletableFuture.runAsync(() -> {
            if (this.caps.get().size() == 0 && !this.hasRequested) {
                this.isLoading = true;
                this.hasRequested = true;
                String rsp = WebUtils.getWebResponse("https://blockshot.ch/list");
                if (!rsp.equals("error")) {
                    JsonElement jsonElement = JsonParser.parseString((String)rsp);
                    JsonArray images = jsonElement.getAsJsonArray();
                    for (JsonElement obj : images) {
                        ScreencapListItem item = new ScreencapListItem();
                        item.id = obj.getAsJsonObject().get("id").getAsString();
                        item.preview = obj.getAsJsonObject().get("preview").getAsString();
                        item.created = obj.getAsJsonObject().get("created").getAsLong();
                        this.caps.getAndUpdate(a -> {
                            a.add(item);
                            return a;
                        });
                    }
                } else if (this.caps.get().size() == 0) {
                    ScreencapListItem item = new ScreencapListItem();
                    item.id = "BlockShot not available in offline mode.";
                    item.preview = "";
                    item.isDeleting = true;
                    item.created = 0L;
                    this.caps.getAndUpdate(a -> {
                        a.add(item);
                        return a;
                    });
                }
            }
            this.list.m_6702_().clear();
            ArrayList localCaps = new ArrayList(this.caps.get());
            for (ScreencapListItem c : localCaps) {
                BlockShotHistoryEntry entry = new BlockShotHistoryEntry(this.list, c.id, c.preview, c.created, c.isDeleting);
                this.list.m_6702_().add(entry);
            }
        });
    }

    public class BlockShotHistoryEntry
    extends ScreenListEntry {
        String id;
        String preview;
        long created;
        ScreenList parent;
        boolean isDeleting;
        private boolean previewLoading;
        private boolean previewLoaded;
        private ResourceLocation _resource;

        public BlockShotHistoryEntry(ScreenList list, String id, String preview, long created, boolean isDeleting) {
            super(list);
            this.isDeleting = false;
            this.previewLoading = false;
            this.previewLoaded = false;
            this.parent = list;
            this.id = id;
            this.isDeleting = isDeleting;
            this.preview = preview;
            this.created = created;
        }

        public void m_6311_(PoseStack poseStack, int slotIndex, int y, int x, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float p_render_9_) {
            Date date = this.created > 0L ? new Date(this.created * 1000L) : new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            this.mc.f_91062_.m_92883_(poseStack, sdf.format(date), (float)(x + 35), (float)y, 0xFFFFFF);
            if (this.isDeleting) {
                if (this.id.length() < 10) {
                    this.mc.f_91062_.m_92883_(poseStack, "Pending deletion...", (float)(x + 35), (float)(y + 10), 0x808080);
                } else {
                    this.mc.f_91062_.m_92883_(poseStack, this.id, (float)(x + 35), (float)(y + 10), 0x808080);
                }
            } else if (this.id.length() < 10) {
                this.mc.f_91062_.m_92883_(poseStack, "https://blockshot.ch/" + this.id, (float)(x + 35), (float)(y + 10), 0x808080);
            }
            this.drawIcon(poseStack, x, y, this.getPreview());
        }

        public void delete() {
            this.isDeleting = true;
            BlockShotHistoryScreen.this.caps.getAndUpdate(a -> {
                for (ScreencapListItem c : a) {
                    if (c.id != this.id) continue;
                    c.isDeleting = true;
                    break;
                }
                return a;
            });
            WebUtils.getWebResponse("https://blockshot.ch/delete/" + this.id);
        }

        public void openUrl() {
            URL url = null;
            try {
                url = new URL("https://blockshot.ch/" + this.id);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return;
            }
            if (url != null) {
                Util.m_137581_().m_137650_(url);
            }
        }

        public void copyUrl() {
            Minecraft.m_91087_().f_91068_.m_90911_("https://blockshot.ch/" + this.id);
        }

        public ResourceLocation getPreview() {
            if (this.preview == null || this.preview.length() == 0 || this.created == 0L) {
                return new ResourceLocation("textures/misc/unknown_server.png");
            }
            try {
                if (this.previewLoading) {
                    return new ResourceLocation("textures/misc/unknown_server.png");
                }
                if (this.previewLoaded) {
                    return this._resource;
                }
                this.previewLoading = true;
                NativeImage image = NativeImage.m_85060_((String)this.preview);
                DynamicTexture i = new DynamicTexture(image);
                this._resource = Minecraft.m_91087_().m_91097_().m_118490_("blockshot/", i);
                this.previewLoaded = true;
                this.previewLoading = false;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.previewLoading = false;
                this.previewLoaded = true;
            }
            return new ResourceLocation("textures/misc/unknown_server.png");
        }

        protected void drawIcon(PoseStack poseStack, int i, int j, ResourceLocation resourceLocation) {
            if (resourceLocation == null) {
                resourceLocation = new ResourceLocation("textures/misc/unknown_server.png");
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
            RenderSystem.m_69478_();
            GuiComponent.m_93133_((PoseStack)poseStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.m_69461_();
        }
    }

    class ScreencapListItem {
        String id;
        String preview;
        long created;
        boolean isDeleting;

        ScreencapListItem() {
        }
    }
}

