/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.mixin.MixinChatComponent;
import net.creeperhost.polylib.client.gif.GifSequenceWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class GifEncoder {
    private static ExecutorService rendering = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("blockshot-framerenderer-%d").build());
    private static ExecutorService encoding = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("blockshot-imageencoder-%d").build());
    public static AtomicInteger addedFrames = new AtomicInteger();
    public static AtomicInteger processedFrames = new AtomicInteger();
    public static boolean isRecording = false;
    public static long lastTimestamp;
    public static long frames;
    public static long totalSeconds;
    private static AtomicReference<List<BufferedImage>> _frames;

    public static void addFrameAndClose(NativeImage screenImage) {
        CompletableFuture.runAsync(() -> {
            addedFrames.incrementAndGet();
            try {
                int width = screenImage.m_84982_();
                int height = screenImage.m_85084_();
                int k = 0;
                int l = 0;
                screenImage.m_85122_();
                int new_width = 856;
                int new_height = 482;
                int scaleFactor = 2;
                new_width -= new_width / 2 / 3 * scaleFactor;
                new_height -= new_height / 2 / 3 * scaleFactor;
                if (width > height) {
                    ratio = (double)height / (double)width;
                    new_height = (int)Math.round((double)new_width * ratio);
                } else {
                    ratio = (double)width / (double)height;
                    new_width = (int)Math.round((double)new_height * ratio);
                }
                NativeImage nativeImage = new NativeImage(new_width, new_height, false);
                screenImage.m_85034_(k, l, width, height, nativeImage);
                screenImage.close();
                ByteArrayInputStream is = new ByteArrayInputStream(nativeImage.m_85121_());
                BufferedImage finalFrame = new BufferedImage(new_width, new_height, 1);
                finalFrame.getGraphics().drawImage(ImageIO.read(is), 0, 0, null);
                nativeImage.close();
                _frames.getAndUpdate(a -> {
                    a.add(finalFrame);
                    return a;
                });
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                screenImage.close();
            }
            processedFrames.incrementAndGet();
        }, rendering);
    }

    public static void begin() {
        if (_frames == null || _frames.get() == null) {
            _frames.set(new ArrayList());
        }
        if (isRecording) {
            return;
        }
        lastTimestamp = 0L;
        frames = 0L;
        totalSeconds = 0L;
        isRecording = true;
        CompletableFuture.runAsync(() -> {
            TextComponent message = new TextComponent("[BlockShot] You are now recording gameplay! ");
            if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)message, 420420);
            }
            while (isRecording) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            message = new TextComponent("[BlockShot] Gameplay recording complete, preparing... ");
            if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)message, 420420);
            }
            while (addedFrames.get() > processedFrames.get()) {
                try {
                    message = new TextComponent("[BlockShot] Preparing frame " + processedFrames + " of " + addedFrames.get());
                    if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                        ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)message, 420420);
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (_frames.get() != null) {
                List<BufferedImage> frames = _frames.get();
                BufferedImage firstFrame = frames.get(0);
                GifSequenceWriter writer = null;
                ByteArrayOutputStream outputStream = null;
                ImageOutputStream imageStream = null;
                int duration = (int)(totalSeconds / (long)frames.size());
                message = new TextComponent("[BlockShot] Preparation complete, encoding frames... ");
                if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                    ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)message, 420420);
                }
                try {
                    outputStream = new ByteArrayOutputStream();
                    imageStream = ImageIO.createImageOutputStream(outputStream);
                    writer = new GifSequenceWriter(imageStream, firstFrame.getType(), duration, true);
                    writer.writeToSequence((RenderedImage)firstFrame);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int i = 0;
                int f = frames.size();
                for (BufferedImage frame : frames) {
                    try {
                        ++i;
                        Object dots = "";
                        for (int z = 0; z <= i % 3; ++z) {
                            dots = (String)dots + ".";
                        }
                        message = new TextComponent("[BlockShot] Encoding frame " + i + " of " + f + (String)dots);
                        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                            ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)message, 420420);
                        }
                        writer.writeToSequence((RenderedImage)frame);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    writer.close();
                    imageStream.close();
                    frames.clear();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                _frames.set(new ArrayList());
                message = new TextComponent("[BlockShot] Encoding complete... Starting upload...");
                if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                    ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeremoveById(420420);
                    ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)message, 360360);
                }
                try {
                    byte[] bytes = outputStream.toByteArray();
                    outputStream.close();
                    BlockShot.uploadAndAddToChat(bytes);
                    outputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            addedFrames.set(0);
            processedFrames.set(0);
            isRecording = false;
        }, encoding);
    }

    static {
        _frames = new AtomicReference();
    }
}

