/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Base64;
import java.util.Random;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.GifEncoder;
import net.creeperhost.blockshot.WebUtils;
import net.creeperhost.blockshot.gui.BlockShotHistoryScreen;
import net.creeperhost.blockshot.mixin.MixinChatComponent;
import net.creeperhost.blockshot.mixin.MixinMinecraft;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockShot {
    public static final String MOD_ID = "blockshot";
    public static Logger logger = LogManager.getLogger();
    public static Path configLocation = Platform.getGameFolder().resolve("blockshot.json");
    public static final int CHAT_UPLOAD_ID = 360360;
    public static final int CHAT_ENCODING_ID = 420420;
    public static byte[] latest;
    private static boolean _active;
    private static long keybindLast;

    public static void init() {
        if (Platform.getEnvironment().equals((Object)Env.CLIENT)) {
            if (BlockShot.getServerIDAndVerify() != null || Platform.isDevelopmentEnvironment()) {
                _active = true;
            } else {
                logger.error("BlockShot will not run in offline mode.");
            }
        }
        if (BlockShot.isActive()) {
            Config.init(configLocation.toFile());
            ClientRawInputEvent.KEY_PRESSED.register(BlockShot::onRawInput);
            ClientGuiEvent.INIT_POST.register((screen, access) -> {
                if (screen instanceof ControlsScreen) {
                    int i = screen.f_96543_ / 2 - 155 + 160;
                    int k = screen.f_96544_ / 6 - 12 + 48;
                    String value = "Auto";
                    if (Config.INSTANCE.uploadMode == 0) {
                        value = "Off";
                    }
                    if (Config.INSTANCE.uploadMode == 1) {
                        value = "Prompt";
                    }
                    String name = "BlockShot Upload: " + value;
                    access.addRenderableWidget((AbstractWidget)new Button(i, k, 150, 20, (Component)new TextComponent(name), button -> {
                        if (Config.INSTANCE.uploadMode == 2) {
                            Config.INSTANCE.uploadMode = 0;
                        } else if (Config.INSTANCE.uploadMode == 1) {
                            Config.INSTANCE.uploadMode = 2;
                        } else if (Config.INSTANCE.uploadMode == 0) {
                            Config.INSTANCE.uploadMode = 1;
                        }
                        Config.saveConfigToFile(configLocation.toFile());
                        Minecraft.m_91087_().m_91152_(screen);
                    }));
                    String value2 = "Anonymous";
                    if (!Config.INSTANCE.anonymous) {
                        value2 = Minecraft.m_91087_().m_91094_().m_92546_();
                    }
                    String name2 = "BlockShot Owner: " + value2;
                    access.addRenderableWidget((AbstractWidget)new Button(i -= 160, k += 24, 150, 20, (Component)new TextComponent(name2), button -> {
                        Config.INSTANCE.anonymous = !Config.INSTANCE.anonymous;
                        Config.saveConfigToFile(configLocation.toFile());
                        Minecraft.m_91087_().m_91152_(screen);
                    }));
                    String name3 = "View BlockShot History";
                    Button historyBtn = new Button(i += 160, k, 150, 20, (Component)new TextComponent(name3), button -> Minecraft.m_91087_().m_91152_((Screen)new BlockShotHistoryScreen(screen)));
                    historyBtn.f_93623_ = !Config.INSTANCE.anonymous;
                    access.addRenderableWidget((AbstractWidget)historyBtn);
                    for (Widget renderable : access.getRenderables()) {
                        Button button2;
                        if (!(renderable instanceof Button) || !(button2 = (Button)renderable).m_6035_().equals(CommonComponents.f_130655_)) continue;
                        button2.f_93621_ += 24;
                        break;
                    }
                }
            });
        }
    }

    public static boolean isActive() {
        return _active;
    }

    private static EventResult onRawInput(Minecraft minecraft, int keyCode, int scanCode, int action, int modifiers) {
        if (Screen.m_96637_() && Minecraft.m_91087_().f_91066_.f_92102_.m_90832_(keyCode, scanCode)) {
            if (keybindLast + 5L > Instant.now().getEpochSecond()) {
                return EventResult.pass();
            }
            keybindLast = Instant.now().getEpochSecond();
            if (GifEncoder.isRecording) {
                GifEncoder.isRecording = false;
            } else if (GifEncoder.processedFrames.get() == 0 && GifEncoder.addedFrames.get() == 0) {
                GifEncoder.begin();
            }
            return EventResult.interrupt((Boolean)true);
        }
        return EventResult.pass();
    }

    public static int getFPS() {
        return ((MixinMinecraft)Minecraft.m_91087_()).getfps();
    }

    public static void uploadAndAddToChat(byte[] imageBytes) {
        String result;
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
            TextComponent finished = new TextComponent("[BlockShot] Uploading to BlockShot...");
            ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)finished, 360360);
        }
        if ((result = BlockShot.uploadImage(imageBytes)) == null) {
            if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                TextComponent finished = new TextComponent("[BlockShot] An error occurred uploading your content to BlockShot.");
                ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeaddMessage((Component)finished, 360360);
            }
        } else if (result.startsWith("http")) {
            MutableComponent link = new TextComponent(result).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, result)));
            MutableComponent finished = new TextComponent("[BlockShot] Your content is now available on BlockShot! ").m_7220_((Component)link);
            ((MixinChatComponent)Minecraft.m_91087_().f_91065_.m_93076_()).invokeremoveById(360360);
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)finished);
        }
    }

    public static String uploadImage(byte[] imageBytes) {
        block4: {
            try {
                String rsp = WebUtils.putWebResponse("https://blockshot.ch/upload", Base64.getEncoder().encodeToString(imageBytes), false, false, true);
                if (rsp.equals("error")) break block4;
                JsonElement jsonElement = JsonParser.parseString((String)rsp);
                String status = jsonElement.getAsJsonObject().get("status").getAsString();
                if (!status.equals("error")) {
                    String url = jsonElement.getAsJsonObject().get("url").getAsString();
                    if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91065_.m_93076_() != null) {
                        return url;
                    }
                    break block4;
                }
                logger.error(jsonElement.getAsJsonObject().get("message").getAsString());
                return null;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static String getServerIDAndVerify() {
        Minecraft mc = Minecraft.m_91087_();
        String serverId = DigestUtils.sha1Hex((String)String.valueOf(new Random().nextInt()));
        try {
            mc.m_91108_().joinServer(mc.m_91094_().m_92548_(), mc.m_91094_().m_92547_(), serverId);
        }
        catch (AuthenticationException e) {
            logger.error("Failed to validate with Mojang: " + e.getMessage());
            return null;
        }
        return serverId;
    }

    static {
        _active = false;
        keybindLast = 0L;
    }
}

