/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen.info.blocks;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public abstract class RenderableBlock {
    private static final MultiBufferSource.BufferSource MODEL_BUFFER = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(128));
    private final float rotation;
    private final int x;
    private final int y;
    private final int z;

    public RenderableBlock(float rotation, int x, int y, int z) {
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void render(PoseStack matrixStack) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.x, (double)this.y, (double)this.z);
        if (this.rotation != 0.0f) {
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85845_(new Quaternion(0.0f, this.rotation, 0.0f, true));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
        }
        this.renderInternal(matrixStack);
        matrixStack.m_85849_();
    }

    protected abstract void renderInternal(PoseStack var1);

    public static RenderableBlock of(final ResourceLocation modelLocation, float rotation, int x, int y, int z) {
        return new RenderableBlock(rotation, x, y, z){

            @Override
            public void renderInternal(PoseStack matrixStack) {
                BakedModel model = ClientUtils.getBlockRenderer().m_110907_().m_110881_().getModel(modelLocation);
                ClientUtils.getBlockRenderer().m_110937_().renderModel(matrixStack.m_85850_(), MODEL_BUFFER.m_6299_(RenderType.m_110451_()), null, model, 1.0f, 1.0f, 1.0f, 0, 0, (IModelData)EmptyModelData.INSTANCE);
            }
        };
    }

    public static RenderableBlock of(final Block block, float rotation, int x, int y, int z) {
        return new RenderableBlock(rotation, x, y, z){

            @Override
            public void renderInternal(PoseStack matrixStack) {
                BakedModel model = ClientUtils.getBlockRenderer().m_110910_(block.m_49966_());
                ClientUtils.getBlockRenderer().m_110937_().renderModel(matrixStack.m_85850_(), MODEL_BUFFER.m_6299_(RenderType.m_110451_()), null, model, 1.0f, 1.0f, 1.0f, 0, 0, (IModelData)EmptyModelData.INSTANCE);
            }
        };
    }

    public static RenderableBlock of(final BlockState state, float rotation, int x, int y, int z) {
        return new RenderableBlock(rotation, x, y, z){

            @Override
            public void renderInternal(PoseStack matrixStack) {
                BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
                ClientUtils.getBlockRenderer().m_110937_().renderModel(matrixStack.m_85850_(), MODEL_BUFFER.m_6299_(RenderType.m_110451_()), null, model, 1.0f, 1.0f, 1.0f, 0, 0, (IModelData)EmptyModelData.INSTANCE);
            }
        };
    }
}

