/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TesseractReference {
    private final String dimension;
    private final BlockPos pos;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canSend = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canReceive = new EnumMap(EnumChannelType.class);

    public TesseractReference(TesseractTile tile) {
        this.dimension = tile.m_58904_().m_46472_().m_135782_().toString();
        this.pos = tile.m_58899_();
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tile.getChannelId(type));
            this.canSend.put(type, tile.canSend(type));
            this.canReceive.put(type, tile.canReceive(type));
        }
    }

    public TesseractReference(CompoundTag tag) {
        this.dimension = tag.m_128461_("dim");
        this.pos = new BlockPos(tag.m_128451_("posx"), tag.m_128451_("posy"), tag.m_128451_("posz"));
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tag.m_128451_(type + "_channel"));
            this.canSend.put(type, tag.m_128471_(type + "_canSend"));
            this.canReceive.put(type, tag.m_128471_(type + "_canReceive"));
        }
    }

    public String getDimension() {
        return this.dimension;
    }

    public Level getWorld() {
        if (TesseractChannelManager.minecraftServer == null) {
            return null;
        }
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(this.dimension));
        return TesseractChannelManager.minecraftServer.m_129880_(key);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isValid() {
        boolean isValid;
        Level world = this.getWorld();
        boolean bl = isValid = world != null && world.m_8055_(this.pos).m_60734_() == Tesseract.tesseract && world.m_7702_(this.pos) instanceof TesseractTile;
        if (!isValid) {
            TesseractTracker.SERVER.remove(this.dimension, this.pos);
        }
        return isValid;
    }

    public TesseractTile getTesseract() {
        return (TesseractTile)this.getWorld().m_7702_(this.pos);
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("dim", this.dimension);
        compound.m_128405_("posx", this.pos.m_123341_());
        compound.m_128405_("posy", this.pos.m_123342_());
        compound.m_128405_("posz", this.pos.m_123343_());
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.m_128405_(type + "_channel", this.channels.get((Object)type).intValue());
            compound.m_128379_(type + "_canSend", this.canSend.get((Object)type).booleanValue());
            compound.m_128379_(type + "_canReceive", this.canReceive(type));
        }
        return compound;
    }

    public boolean canSend(EnumChannelType type) {
        return this.canSend.get((Object)type);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.canReceive.get((Object)type);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public void update(TesseractTile tile) {
        for (EnumChannelType type : EnumChannelType.values()) {
            Channel channel;
            int channelId = tile.getChannelId(type);
            this.channels.put(type, channelId);
            this.canSend.put(type, tile.canSend(type));
            this.canReceive.put(type, tile.canReceive(type));
            if (channelId != -1 || (channel = TesseractChannelManager.getInstance(tile.m_58904_()).getChannelById(type, channelId)) == null) continue;
            channel.updateTesseract(this);
        }
    }

    public void delete() {
        for (Map.Entry<EnumChannelType, Integer> entry : this.channels.entrySet()) {
            Channel channel = TesseractChannelManager.SERVER.getChannelById(entry.getKey(), entry.getValue());
            if (channel == null) continue;
            channel.removeTesseract(this);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TesseractReference)) {
            return false;
        }
        TesseractReference that = (TesseractReference)o;
        return that.dimension.equals(this.dimension) && Objects.equals(this.pos, that.pos);
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        return result;
    }
}

