/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CommandMineral {
    public static void registerArguments() {
        ArgumentTypes.m_121601_((String)"immersiveengineering:mineral", MineralArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(MineralArgument::new));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder main = Commands.m_82127_((String)"mineral");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)main.then(CommandMineral.listMineral())).then(CommandMineral.getMineral())).then(CommandMineral.putMineral())).then(CommandMineral.setMineralDepletion());
        return main;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> listMineral() {
        LiteralArgumentBuilder list = Commands.m_82127_((String)"list");
        list.executes(command -> {
            StringBuilder s = new StringBuilder();
            int i = 0;
            for (MineralMix mm : MineralMix.RECIPES.getRecipes((Level)((CommandSourceStack)command.getSource()).m_81372_())) {
                s.append(i++ > 0 ? ", " : "").append(mm.m_6423_());
            }
            ((CommandSourceStack)command.getSource()).m_81354_((Component)new TextComponent(s.toString()), true);
            return 1;
        });
        return list;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> getMineral() {
        LiteralArgumentBuilder get = Commands.m_82127_((String)"get");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)get.requires(source -> source.m_6761_(2))).executes(command -> {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            CommandMineral.getMineral((CommandContext<CommandSourceStack>)command, new ColumnPos(player.m_142538_()));
            return 1;
        })).then(Commands.m_82129_((String)"location", (ArgumentType)ColumnPosArgument.m_118989_()).executes(command -> {
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)command, (String)"location");
            CommandMineral.getMineral((CommandContext<CommandSourceStack>)command, pos);
            return 1;
        }));
        return get;
    }

    private static void getMineral(CommandContext<CommandSourceStack> context, ColumnPos pos) {
        CommandSourceStack sender = (CommandSourceStack)context.getSource();
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((Level)sender.m_81372_(), pos);
        TextComponent ret = new TextComponent("");
        if (info == null || info.getTotalWeight() == 0) {
            ret.m_7220_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.get.none", new Object[]{pos.f_140723_, pos.f_140724_}));
        } else {
            ret.m_7220_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.get", new Object[]{pos.f_140723_, pos.f_140724_}));
            for (Pair<MineralVein, Integer> pair : info.getAllVeins()) {
                MineralVein vein = (MineralVein)pair.getFirst();
                double percentage = (double)((Integer)pair.getSecond()).intValue() / (double)info.getTotalWeight();
                TextComponent component = new TextComponent("\n " + Utils.formatDouble(percentage * 100.0, "0.00") + "% ");
                component.m_7220_((Component)new TranslatableComponent(vein.getMineral((Level)((CommandSourceStack)context.getSource()).m_81372_()).getTranslationKey()));
                ret.m_7220_((Component)component.m_130940_(ChatFormatting.GRAY));
                component = new TextComponent("\n  ");
                component.m_7220_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.get.pos", new Object[]{vein.getPos().f_140723_, vein.getPos().f_140724_, vein.getRadius()}));
                component.m_130946_("\n  ");
                if (ExcavatorHandler.mineralVeinYield == 0) {
                    component.m_7220_((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.infinite"));
                } else {
                    component.m_7220_((Component)new TranslatableComponent("desc.immersiveengineering.info.coresample.yield", new Object[]{ExcavatorHandler.mineralVeinYield - vein.getDepletion()}));
                }
                ret.m_7220_((Component)component.m_130940_(ChatFormatting.GRAY));
            }
        }
        sender.m_81354_((Component)ret, true);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> putMineral() {
        LiteralArgumentBuilder set = Commands.m_82127_((String)"put");
        ((LiteralArgumentBuilder)set.requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"mineral", (ArgumentType)new MineralArgument()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)8, (int)64)).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(ctx -> {
            CommandMineral.putMineral((CommandContext<CommandSourceStack>)ctx, ColumnPosArgument.m_118992_((CommandContext)ctx, (String)"pos"));
            return 1;
        }))).executes(ctx -> {
            CommandMineral.putMineral((CommandContext<CommandSourceStack>)ctx, CommandMineral.columnPos(((CommandSourceStack)ctx.getSource()).m_81371_()));
            return 1;
        })));
        return set;
    }

    private static void putMineral(CommandContext<CommandSourceStack> context, ColumnPos pos) {
        CommandSourceStack sender = (CommandSourceStack)context.getSource();
        MineralMix mineral = (MineralMix)context.getArgument("mineral", MineralMix.class);
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        if (mineral != null) {
            MineralVein vein = new MineralVein(pos, mineral.m_6423_(), radius);
            ExcavatorHandler.addVein((ResourceKey<Level>)sender.m_81372_().m_46472_(), vein);
            IESaveData.markInstanceDirty();
            sender.m_81354_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.put.success", new Object[]{mineral.m_6423_(), radius, pos.f_140723_, pos.f_140724_}), true);
        } else {
            sender.m_81354_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.put.invalid_mineral", new Object[]{mineral.m_6423_()}), true);
        }
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setMineralDepletion() {
        LiteralArgumentBuilder setDepletion = Commands.m_82127_((String)"setDepletion");
        ((LiteralArgumentBuilder)setDepletion.requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"depletion", (ArgumentType)IntegerArgumentType.integer((int)0, (int)ExcavatorHandler.mineralVeinYield)).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(ctx -> {
            CommandMineral.setMineralDepletion((CommandContext<CommandSourceStack>)ctx, ColumnPosArgument.m_118992_((CommandContext)ctx, (String)"pos"));
            return 1;
        }))).executes(ctx -> {
            CommandMineral.setMineralDepletion((CommandContext<CommandSourceStack>)ctx, CommandMineral.columnPos(((CommandSourceStack)ctx.getSource()).m_81371_()));
            return 1;
        }));
        return setDepletion;
    }

    private static void setMineralDepletion(CommandContext<CommandSourceStack> context, ColumnPos pos) {
        CommandSourceStack sender = (CommandSourceStack)context.getSource();
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo((Level)sender.m_81372_(), pos);
        if (info != null && info.getTotalWeight() > 0) {
            int depletion = IntegerArgumentType.getInteger(context, (String)"depletion");
            for (Pair<MineralVein, Integer> pair : info.getAllVeins()) {
                ((MineralVein)pair.getFirst()).setDepletion(depletion);
            }
            IESaveData.markInstanceDirty();
            sender.m_81354_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.set_depletion.success", new Object[]{depletion}), true);
        } else {
            sender.m_81354_((Component)new TranslatableComponent("chat.immersiveengineering.command.mineral.set_depletion.no_mineral", new Object[]{pos.f_140723_, pos.f_140724_}), true);
        }
    }

    private static ColumnPos columnPos(Vec3 vec) {
        return new ColumnPos((int)vec.f_82479_, (int)vec.f_82481_);
    }

    private static class MineralArgument
    implements ArgumentType<MineralMix> {
        public static final DynamicCommandExceptionType invalidVein = new DynamicCommandExceptionType(input -> new TranslatableComponent("chat.immersiveengineering.command.mineral.invalid", new Object[]{input}));

        private MineralArgument() {
        }

        public MineralMix parse(StringReader reader) throws CommandSyntaxException {
            String name = reader.readQuotedString();
            for (MineralMix mm : this.getStaticMinerals()) {
                if (!mm.m_6423_().toString().equalsIgnoreCase(name)) continue;
                return mm;
            }
            throw invalidVein.create((Object)name);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82981_(this.getStaticMinerals().stream().map(mix -> "\"" + mix.m_6423_() + "\""), (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            ArrayList<String> ret = new ArrayList<String>();
            for (MineralMix mix : this.getStaticMinerals()) {
                ret.add("\"" + mix.m_6423_() + "\"");
                if (ret.size() <= 5) continue;
                break;
            }
            return ret;
        }

        private Collection<MineralMix> getStaticMinerals() {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            Level level = server == null ? ImmersiveEngineering.proxy.getClientWorld() : server.m_129783_();
            return MineralMix.RECIPES.getRecipes(level);
        }
    }
}

