/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.Raytracer;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.mojang.math.Vector4f;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class Utils {
    public static final Random RAND = new Random();
    public static final DecimalFormat NUMBERFORMAT_PREFIXED = new DecimalFormat("+#;-#");
    public static final BiMap<TagKey<Item>, DyeColor> DYES_BY_TAG = ImmutableBiMap.builder().put((Object)Tags.Items.DYES_BLACK, (Object)DyeColor.BLACK).put((Object)Tags.Items.DYES_RED, (Object)DyeColor.RED).put((Object)Tags.Items.DYES_GREEN, (Object)DyeColor.GREEN).put((Object)Tags.Items.DYES_BROWN, (Object)DyeColor.BROWN).put((Object)Tags.Items.DYES_BLUE, (Object)DyeColor.BLUE).put((Object)Tags.Items.DYES_PURPLE, (Object)DyeColor.PURPLE).put((Object)Tags.Items.DYES_CYAN, (Object)DyeColor.CYAN).put((Object)Tags.Items.DYES_LIGHT_GRAY, (Object)DyeColor.LIGHT_GRAY).put((Object)Tags.Items.DYES_GRAY, (Object)DyeColor.GRAY).put((Object)Tags.Items.DYES_PINK, (Object)DyeColor.PINK).put((Object)Tags.Items.DYES_LIME, (Object)DyeColor.LIME).put((Object)Tags.Items.DYES_YELLOW, (Object)DyeColor.YELLOW).put((Object)Tags.Items.DYES_LIGHT_BLUE, (Object)DyeColor.LIGHT_BLUE).put((Object)Tags.Items.DYES_MAGENTA, (Object)DyeColor.MAGENTA).put((Object)Tags.Items.DYES_ORANGE, (Object)DyeColor.ORANGE).put((Object)Tags.Items.DYES_WHITE, (Object)DyeColor.WHITE).build();
    private static final long UUID_BASE = 109406000905L;
    private static long UUIDAdd = 1L;

    public static boolean compareItemNBT(ItemStack stack1, ItemStack stack2) {
        boolean hasTag2;
        if (stack1.m_41619_() != stack2.m_41619_()) {
            return false;
        }
        boolean hasTag1 = stack1.m_41782_();
        if (hasTag1 != (hasTag2 = stack2.m_41782_())) {
            return false;
        }
        if (hasTag1 && !stack1.m_41784_().equals((Object)stack2.m_41784_())) {
            return false;
        }
        return stack1.areCapsCompatible((CapabilityProvider)stack2);
    }

    @Nullable
    public static DyeColor getDye(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        if (stack.m_204117_(Tags.Items.DYES)) {
            for (Map.Entry entry : DYES_BY_TAG.entrySet()) {
                if (!stack.m_204117_((TagKey)entry.getKey())) continue;
                return (DyeColor)entry.getValue();
            }
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        return stack.m_204117_(Tags.Items.DYES);
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        return FluidUtils.copyFluidStackWithAmount(stack, amount, stripPressure);
    }

    public static UUID generateNewUUID() {
        UUID uuid = new UUID(109406000905L, UUIDAdd);
        ++UUIDAdd;
        return uuid;
    }

    public static boolean isBlockAt(Level world, BlockPos pos, Block b) {
        return world.m_8055_(pos).m_60734_() == b;
    }

    public static double generateLuckInfluencedDouble(double median, double deviation, double luck, Random rng, boolean isBad, double luckScale) {
        double number = rng.nextDouble() * deviation;
        if (isBad) {
            number = -number;
        }
        number += luckScale * luck;
        number = deviation < 0.0 ? Math.max(number, deviation) : Math.min(number, deviation);
        return median + number;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String getHarvestLevelName(Tier lvl) {
        return Utils.toCamelCase(TierSortingRegistry.getName((Tier)lvl).m_135815_());
    }

    public static String getModName(String modid) {
        return ModList.get().getModContainerById(modid).map(container -> container.getModInfo().getDisplayName()).orElse(modid);
    }

    public static <T> int findSequenceInList(List<T> list, T[] sequence, BiPredicate<T, T> equal) {
        if (list.size() <= 0 || list.size() < sequence.length) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!equal.test(sequence[0], list.get(i))) continue;
            boolean found = true;
            for (int j = 1; j < sequence.length && (found = equal.test(sequence[j], list.get(i + j))); ++j) {
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static Direction rotateFacingTowardsDir(Direction f, Direction dir) {
        if (dir == Direction.NORTH) {
            return f;
        }
        if (dir == Direction.SOUTH && f.m_122434_() != Direction.Axis.Y) {
            return f.m_122427_().m_122427_();
        }
        if (dir == Direction.WEST && f.m_122434_() != Direction.Axis.Y) {
            return f.m_122428_();
        }
        if (dir == Direction.EAST && f.m_122434_() != Direction.Axis.Y) {
            return f.m_122427_();
        }
        if (dir == Direction.DOWN && f.m_122434_() != Direction.Axis.Y) {
            return DirectionUtils.rotateAround(f, Direction.Axis.X);
        }
        if (dir == Direction.UP && f.m_122434_() != Direction.Axis.X) {
            return DirectionUtils.rotateAround(f, Direction.Axis.X).m_122424_();
        }
        return f;
    }

    public static Vec3 getLivingFrontPos(LivingEntity entity, double offset, double height, HumanoidArm hand, boolean useSteppedYaw, float partialTicks) {
        double offsetX = hand == HumanoidArm.LEFT ? -0.3125 : (hand == HumanoidArm.RIGHT ? 0.3125 : 0.0);
        float yaw = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks;
        if (useSteppedYaw) {
            yaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTicks;
        }
        float pitch = entity.f_19860_ + (entity.m_146909_() - entity.f_19860_) * partialTicks;
        float yawCos = Mth.m_14089_((float)(-yaw * (float)Math.PI / 180.0f - (float)Math.PI));
        float yawSin = Mth.m_14031_((float)(-yaw * (float)Math.PI / 180.0f - (float)Math.PI));
        float pitchCos = -Mth.m_14089_((float)(-pitch * (float)Math.PI / 180.0f));
        float pitchSin = Mth.m_14031_((float)(-pitch * (float)Math.PI / 180.0f));
        return new Vec3(entity.m_20185_() + offsetX * (double)yawCos + offset * (double)pitchCos * (double)yawSin, entity.m_20186_() + offset * (double)pitchSin + height, entity.m_20189_() + offset * (double)pitchCos * (double)yawCos - offsetX * (double)yawSin);
    }

    public static List<LivingEntity> getTargetsInCone(Level world, Vec3 start, Vec3 dir, float spreadAngle, float truncationLength) {
        double length = dir.m_82553_();
        Vec3 dirNorm = dir.m_82541_();
        double radius = Math.tan(spreadAngle / 2.0f) * length;
        Vec3 endLow = start.m_82549_(dir).m_82492_(radius, radius, radius);
        Vec3 endHigh = start.m_82549_(dir).m_82520_(radius, radius, radius);
        AABB box = new AABB(Utils.minInArray(start.f_82479_, endLow.f_82479_, endHigh.f_82479_), Utils.minInArray(start.f_82480_, endLow.f_82480_, endHigh.f_82480_), Utils.minInArray(start.f_82481_, endLow.f_82481_, endHigh.f_82481_), Utils.maxInArray(start.f_82479_, endLow.f_82479_, endHigh.f_82479_), Utils.maxInArray(start.f_82480_, endLow.f_82480_, endHigh.f_82480_), Utils.maxInArray(start.f_82481_, endLow.f_82481_, endHigh.f_82481_));
        List list = world.m_45976_(LivingEntity.class, box);
        list.removeIf(e -> !Utils.isPointInCone(dirNorm, radius, length, truncationLength, e.m_20182_().m_82546_(start)));
        return list;
    }

    public static boolean isPointInCone(Vec3 normDirection, double radius, double length, float truncationLength, Vec3 relativePoint) {
        double projectedDist = relativePoint.m_82526_(normDirection);
        if (projectedDist < (double)truncationLength || projectedDist > length) {
            return false;
        }
        double radiusAtDist = projectedDist / length * radius;
        Vec3 orthVec = relativePoint.m_82546_(normDirection.m_82490_(projectedDist));
        return orthVec.m_82556_() < radiusAtDist * radiusAtDist;
    }

    public static boolean isPointInTriangle(Vec3 tA, Vec3 tB, Vec3 tC, Vec3 point) {
        Vec3 v0 = tC.m_82546_(tA);
        Vec3 v1 = tB.m_82546_(tA);
        Vec3 v2 = point.m_82546_(tA);
        return Utils.isPointInTriangle(v0, v1, v2);
    }

    private static boolean isPointInTriangle(Vec3 leg0, Vec3 leg1, Vec3 targetVec) {
        double dot00 = leg0.m_82526_(leg0);
        double dot01 = leg0.m_82526_(leg1);
        double dot02 = leg0.m_82526_(targetVec);
        double dot11 = leg1.m_82526_(leg1);
        double dot12 = leg1.m_82526_(targetVec);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v < 1.0;
    }

    public static void attractEnemies(LivingEntity target, float radius) {
        Utils.attractEnemies(target, radius, null);
    }

    public static void attractEnemies(LivingEntity target, float radius, Predicate<Monster> predicate) {
        AABB aabb = new AABB(target.m_20185_() - (double)radius, target.m_20186_() - (double)radius, target.m_20189_() - (double)radius, target.m_20185_() + (double)radius, target.m_20186_() + (double)radius, target.m_20189_() + (double)radius);
        List list = target.m_20193_().m_45976_(Monster.class, aabb);
        for (Monster mob : list) {
            if (predicate != null && !predicate.test(mob)) continue;
            mob.m_6710_(target);
            mob.m_21391_((Entity)target, 180.0f, 0.0f);
        }
    }

    public static boolean isHammer(ItemStack stack) {
        return stack.m_204117_(IETags.hammers);
    }

    public static boolean isScrewdriver(ItemStack stack) {
        return stack.m_204117_(IETags.screwdrivers);
    }

    public static boolean canBlockDamageSource(LivingEntity entity, DamageSource damageSourceIn) {
        Vec3 vec3d;
        if (!damageSourceIn.m_19376_() && entity.m_21254_() && (vec3d = damageSourceIn.m_7270_()) != null) {
            Vec3 vec3d1 = entity.m_20252_(1.0f);
            Vec3 vec3d2 = vec3d.m_82505_(entity.m_20182_()).m_82541_();
            vec3d2 = new Vec3(vec3d2.f_82479_, 0.0, vec3d2.f_82481_);
            return vec3d2.m_82526_(vec3d1) < 0.0;
        }
        return false;
    }

    public static Vec3 getFlowVector(Level world, BlockPos pos) {
        BlockState bState = world.m_8055_(pos);
        FluidState fState = bState.m_60819_();
        return fState.m_76179_((BlockGetter)world, pos);
    }

    public static double minInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double min = f[0];
        for (int i = 1; i < f.length; ++i) {
            min = Math.min(min, f[i]);
        }
        return min;
    }

    public static double maxInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double max = f[0];
        for (int i = 1; i < f.length; ++i) {
            max = Math.max(max, f[i]);
        }
        return max;
    }

    public static boolean isVecInEntityHead(LivingEntity entity, Vec3 vec) {
        if (entity.m_20206_() / entity.m_20205_() < 2.0f) {
            return false;
        }
        double d = vec.f_82480_ - (entity.m_20186_() + (double)entity.m_20192_());
        return Math.abs(d) < 0.25;
    }

    public static void unlockIEAdvancement(Player player, String name) {
        if (player instanceof ServerPlayer) {
            PlayerAdvancements advancements = ((ServerPlayer)player).m_8960_();
            ServerAdvancementManager manager = ((ServerLevel)player.m_20193_()).m_142572_().m_129889_();
            Advancement advancement = manager.m_136041_(new ResourceLocation("immersiveengineering", name));
            if (advancement != null) {
                advancements.m_135988_(advancement, "code_trigger");
            }
        }
    }

    public static CompoundTag getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        CompoundTag tag = new CompoundTag();
        CompoundTag expl = new CompoundTag();
        expl.m_128379_("Flicker", true);
        expl.m_128379_("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = DyeColor.m_41053_((int)j).m_41070_();
        }
        expl.m_128385_("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.m_128344_("Type", (byte)type);
        ListTag list = new ListTag();
        list.add((Object)expl);
        tag.m_128365_("Explosions", (Tag)list);
        return tag;
    }

    public static int intFromRGBA(Vector4f rgba) {
        float[] array = new float[]{rgba.m_123601_(), rgba.m_123615_(), rgba.m_123616_(), rgba.m_123617_()};
        return Utils.intFromRGBA(array);
    }

    public static int intFromRGBA(float[] rgba) {
        int ret = (int)(255.0f * rgba[3]);
        ret = (ret << 8) + (int)(255.0f * rgba[0]);
        ret = (ret << 8) + (int)(255.0f * rgba[1]);
        ret = (ret << 8) + (int)(255.0f * rgba[2]);
        return ret;
    }

    public static Vector4f vec4fFromDye(DyeColor dyeColor) {
        if (dyeColor == null) {
            return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        float[] rgb = dyeColor.m_41068_();
        return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
    }

    public static Vector4f vec4fFromInt(int argb) {
        return new Vector4f((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >> 24 & 0xFF) / 255.0f);
    }

    public static FluidStack drainFluidBlock(Level world, BlockPos pos, IFluidHandler.FluidAction action) {
        Block block;
        BlockState b = world.m_8055_(pos);
        FluidState f = b.m_60819_();
        if (f.m_76170_() && (block = b.m_60734_()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            if (action.execute()) {
                bucketPickup.m_142598_((LevelAccessor)world, pos, b);
            }
            return new FluidStack(f.m_76152_(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public static Fluid getRelatedFluid(Level w, BlockPos pos) {
        return w.m_8055_(pos).m_60819_().m_76152_();
    }

    public static boolean placeFluidBlock(Level worldIn, BlockPos posIn, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (!(fluid instanceof FlowingFluid) || fluidStack.getAmount() < 1000) {
            return false;
        }
        BlockState blockstate = worldIn.m_8055_(posIn);
        Material material = blockstate.m_60767_();
        boolean flag = !material.m_76333_();
        boolean flag1 = material.m_76336_();
        if (worldIn.m_46859_(posIn) || flag || flag1 || blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, fluid)) {
            if (worldIn.m_6042_().m_63951_() && fluid.m_205067_(FluidTags.f_13131_)) {
                int i = posIn.m_123341_();
                int j = posIn.m_123342_();
                int k = posIn.m_123343_();
                worldIn.m_5594_(null, posIn, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.m_60734_() instanceof LiquidBlockContainer && fluid == Fluids.f_76193_) {
                ((LiquidBlockContainer)blockstate.m_60734_()).m_7361_((LevelAccessor)worldIn, posIn, blockstate, ((FlowingFluid)fluid).m_76068_(false));
            } else {
                if (!worldIn.f_46443_ && (flag || flag1) && !material.m_76332_()) {
                    worldIn.m_46961_(posIn, true);
                }
                worldIn.m_7731_(posIn, fluid.m_76145_().m_76188_(), 11);
            }
            fluidStack.shrink(1000);
            return true;
        }
        return false;
    }

    public static BlockState getStateFromItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block != Blocks.f_50016_) {
            return block.m_49966_();
        }
        return null;
    }

    public static ItemStack insertStackIntoInventory(CapabilityReference<IItemHandler> ref, ItemStack stack, boolean simulate) {
        IItemHandler handler = ref.getNullable();
        if (handler != null && !stack.m_41619_()) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)simulate);
        }
        return stack;
    }

    public static void dropStackAtPos(Level world, DirectionalBlockPos pos, ItemStack stack) {
        Utils.dropStackAtPos(world, pos.position(), stack, pos.side());
    }

    public static void dropStackAtPos(Level world, BlockPos pos, ItemStack stack, @Nonnull Direction facing) {
        if (!stack.m_41619_()) {
            ItemEntity ei = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack.m_41777_());
            ei.m_20334_(0.075 * (double)facing.m_122429_(), 0.025, 0.075 * (double)facing.m_122431_());
            world.m_7967_((Entity)ei);
        }
    }

    public static void dropStackAtPos(Level world, BlockPos pos, ItemStack stack) {
        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
    }

    public static ItemStack drainFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut) {
        FluidActionResult result;
        if (containerIn == null || containerIn.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (containerIn.m_41782_() && containerIn.m_41784_().m_128456_()) {
            containerIn.m_41751_(null);
        }
        if ((result = FluidUtils.tryEmptyContainer(containerIn, handler, Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isSuccess()) {
            ItemStack empty = result.getResult();
            if (containerOut.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)empty)) {
                if (!containerOut.m_41619_() && containerOut.m_41613_() + empty.m_41613_() > containerOut.m_41741_()) {
                    return ItemStack.f_41583_;
                }
                result = FluidUtils.tryEmptyContainer(containerIn, handler, Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    public static Optional<CraftingRecipe> findCraftingRecipe(CraftingContainer crafting, Level world) {
        return world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)crafting, world);
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromItemStack(ItemStack stack) {
        NonNullList list = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        list.set(0, (Object)stack);
        return list;
    }

    public static float[] rotateToFacing(float[] in, Direction facing) {
        int i;
        int i2 = 0;
        while (i2 < in.length) {
            int n = i2++;
            in[n] = in[n] - 0.5f;
        }
        float[] ret = new float[in.length];
        for (i = 0; i < in.length; i += 3) {
            for (int j = 0; j < 3; ++j) {
                ret[i + j] = j == 0 ? in[i + 0] * (float)facing.m_122431_() + in[i + 1] * (float)facing.m_122429_() + in[i + 2] * (float)facing.m_122430_() : (j == 1 ? in[i + 0] * (float)facing.m_122429_() + in[i + 1] * (float)facing.m_122430_() + in[i + 2] * (float)facing.m_122431_() : in[i + 0] * (float)facing.m_122430_() + in[i + 1] * (float)facing.m_122431_() + in[i + 2] * (float)facing.m_122429_());
            }
        }
        i = 0;
        while (i < in.length) {
            int n = i++;
            ret[n] = (float)((double)ret[n] + 0.5);
        }
        return ret;
    }

    public static boolean isVecInBlock(Vec3 vec3d, BlockPos pos, BlockPos offset, double eps) {
        return vec3d.f_82479_ >= (double)(pos.m_123341_() - offset.m_123341_()) - eps && vec3d.f_82479_ <= (double)(pos.m_123341_() - offset.m_123341_() + 1) + eps && vec3d.f_82480_ >= (double)(pos.m_123342_() - offset.m_123342_()) - eps && vec3d.f_82480_ <= (double)(pos.m_123342_() - offset.m_123342_() + 1) + eps && vec3d.f_82481_ >= (double)(pos.m_123343_() - offset.m_123343_()) - eps && vec3d.f_82481_ <= (double)(pos.m_123343_() - offset.m_123343_() + 1) + eps;
    }

    public static Vec3 withCoordinate(Vec3 vertex, Direction.Axis axis, double value) {
        switch (axis) {
            case X: {
                return new Vec3(value, vertex.f_82480_, vertex.f_82481_);
            }
            case Y: {
                return new Vec3(vertex.f_82479_, value, vertex.f_82481_);
            }
            case Z: {
                return new Vec3(vertex.f_82479_, vertex.f_82480_, value);
            }
        }
        return vertex;
    }

    public static BlockPos rayTraceForFirst(Vec3 start, Vec3 end, Level w, Set<BlockPos> ignore) {
        Set<BlockPos> trace = Raytracer.rayTrace(start, end, w);
        for (BlockPos cc : ignore) {
            trace.remove(cc);
        }
        if (start.f_82479_ != end.f_82479_) {
            trace = Utils.findMinOrMax(trace, start.f_82479_ > end.f_82479_, 0);
        }
        if (start.f_82480_ != end.f_82480_) {
            trace = Utils.findMinOrMax(trace, start.f_82480_ > end.f_82480_, 0);
        }
        if (start.f_82481_ != end.f_82481_) {
            trace = Utils.findMinOrMax(trace, start.f_82481_ > end.f_82481_, 0);
        }
        if (trace.size() > 0) {
            return trace.iterator().next();
        }
        return null;
    }

    public static Set<BlockPos> findMinOrMax(Set<BlockPos> in, boolean max, int coord) {
        int curr;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.m_123341_() : (coord == 1 ? cc.m_123342_() : cc.m_123342_());
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.m_123341_() : (coord == 1 ? cc.m_123342_() : cc.m_123343_());
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static BlockEntity getExistingTileEntity(Level world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        if (world.m_46805_(pos)) {
            return world.m_7702_(pos);
        }
        return null;
    }

    public static void modifyInvStackSize(NonNullList<ItemStack> inv, int slot, int amount) {
        if (slot >= 0 && slot < inv.size() && !((ItemStack)inv.get(slot)).m_41619_()) {
            ((ItemStack)inv.get(slot)).m_41769_(amount);
            if (((ItemStack)inv.get(slot)).m_41613_() <= 0) {
                inv.set(slot, (Object)ItemStack.f_41583_);
            }
        }
    }

    public static void shuffleLootItems(List<ItemStack> stacks, int slotAmount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.m_41613_() <= 0) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        slotAmount -= stacks.size();
        while (slotAmount > 0 && list.size() > 0) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.m_14072_((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = Mth.m_14072_((Random)rand, (int)1, (int)(itemstack2.m_41613_() / 2));
            itemstack2.m_41774_(i);
            ItemStack itemstack1 = itemstack2.m_41777_();
            itemstack1.m_41764_(i);
            if (itemstack2.m_41613_() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    public static int calcRedstoneFromInventory(IIEInventory inv) {
        if (inv == null) {
            return 0;
        }
        int max = inv.getComparatedSize();
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < max; ++j) {
            ItemStack itemstack = (ItemStack)inv.getInventory().get(j);
            if (itemstack.m_41619_()) continue;
            f += (float)itemstack.m_41613_() / (float)Math.min(inv.getSlotLimit(j), itemstack.m_41741_());
            ++i;
        }
        return Mth.m_14143_((float)((f /= (float)max) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        ResourceLocation resourcelocation = state.m_60734_().m_60589_();
        if (resourcelocation == BuiltInLootTables.f_78712_) {
            return Collections.emptyList();
        }
        LootContext lootcontext = builder.m_78972_(LootContextParams.f_81461_, (Object)state).m_78975_(LootContextParamSets.f_81421_);
        ServerLevel serverworld = lootcontext.m_78952_();
        LootTable loottable = serverworld.m_142572_().m_129898_().m_79217_(resourcelocation);
        return loottable.m_79129_(lootcontext);
    }

    public static ItemStack getPickBlock(BlockState state, HitResult rtr, Player player) {
        BlockGetter w = Utils.getSingleBlockWorldAccess(state);
        return state.m_60734_().getCloneItemStack(state, rtr, w, BlockPos.f_121853_, player);
    }

    public static ItemStack getPickBlock(BlockState state) {
        return Utils.getPickBlock(state, (HitResult)new BlockHitResult(Vec3.f_82478_, Direction.DOWN, BlockPos.f_121853_, false), ImmersiveEngineering.proxy.getClientPlayer());
    }

    public static List<AABB> flipBoxes(boolean flipFront, boolean flipRight, List<AABB> boxes) {
        return Utils.flipBoxes(flipFront, flipRight, boxes.toArray(new AABB[0]));
    }

    public static List<AABB> flipBoxes(boolean flipFront, boolean flipRight, AABB ... boxes) {
        ArrayList<AABB> ret = new ArrayList<AABB>(boxes.length);
        for (AABB aabb : boxes) {
            ret.add(Utils.flipBox(flipFront, flipRight, aabb));
        }
        return ret;
    }

    public static AABB flipBox(boolean flipFront, boolean flipRight, AABB aabb) {
        AABB result = aabb;
        if (flipRight) {
            result = new AABB(1.0 - result.f_82291_, result.f_82289_, result.f_82290_, 1.0 - result.f_82288_, result.f_82292_, result.f_82293_);
        }
        if (flipFront) {
            result = new AABB(result.f_82288_, result.f_82289_, 1.0 - result.f_82293_, result.f_82291_, result.f_82292_, 1.0 - result.f_82290_);
        }
        return result;
    }

    public static BlockGetter getSingleBlockWorldAccess(BlockState state) {
        return new SingleBlockAcess(state);
    }

    private static class SingleBlockAcess
    implements BlockGetter {
        private final BlockState state;

        public SingleBlockAcess(BlockState state) {
            this.state = state;
        }

        @Nullable
        public BlockEntity m_7702_(@Nonnull BlockPos pos) {
            return null;
        }

        @Nonnull
        public BlockState m_8055_(@Nonnull BlockPos pos) {
            return pos.equals((Object)BlockPos.f_121853_) ? this.state : Blocks.f_50016_.m_49966_();
        }

        @Nonnull
        public FluidState m_6425_(@Nonnull BlockPos blockPos) {
            return this.m_8055_(blockPos).m_60819_();
        }

        public int m_7469_() {
            return 0;
        }

        public int m_141928_() {
            return 1;
        }

        public int m_141937_() {
            return 0;
        }
    }

    public static class InventoryCraftingFalse
    extends CraftingContainer {
        private static final AbstractContainerMenu nullContainer = new AbstractContainerMenu(MenuType.f_39968_, 0){

            public void m_6199_(Container paramIInventory) {
            }

            public boolean m_6875_(@Nonnull Player playerIn) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }

        public static CraftingContainer createFilledCraftingInventory(int w, int h, NonNullList<ItemStack> stacks) {
            InventoryCraftingFalse invC = new InventoryCraftingFalse(w, h);
            for (int j = 0; j < w * h; ++j) {
                if (((ItemStack)stacks.get(j)).m_41619_()) continue;
                invC.m_6836_(j, ((ItemStack)stacks.get(j)).m_41777_());
            }
            return invC;
        }
    }
}

