/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MessageSpeedloaderSync
implements IMessage {
    private final int slot;
    private final InteractionHand hand;

    public MessageSpeedloaderSync(int slot, InteractionHand hand) {
        this.slot = slot;
        this.hand = hand;
    }

    public MessageSpeedloaderSync(FriendlyByteBuf buf) {
        this.slot = buf.readByte();
        this.hand = InteractionHand.values()[buf.readByte()];
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte(this.slot);
        buf.writeByte(this.hand.ordinal());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Player player = ImmersiveEngineering.proxy.getClientPlayer();
            if (player != null) {
                if (player.m_21120_(this.hand).m_41720_() instanceof RevolverItem) {
                    player.m_5496_(IESounds.revolverReload, 1.0f, 1.0f);
                    ItemNBTHelper.putInt(player.m_21120_(this.hand), "reload", 60);
                }
                player.m_150109_().m_6836_(this.slot, new ItemStack(IEItems.Weapons.SPEEDLOADER));
            }
        });
    }
}

