/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RevolvershotFlareEntity
extends RevolvershotEntity {
    public int colour = -1;
    private static final EntityDataAccessor<Integer> dataMarker_colour = SynchedEntityData.m_135353_(RevolvershotFlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private BlockPos lightPos;

    public RevolvershotFlareEntity(EntityType<RevolvershotFlareEntity> type, Level world) {
        super((EntityType<? extends RevolvershotEntity>)type, world);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.FLARE_REVOLVERSHOT.get()), world, null, x, y, z, ax, ay, az, type);
        this.setTickLimit(400);
    }

    public RevolvershotFlareEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type, ItemStack stack) {
        super((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.FLARE_REVOLVERSHOT.get()), world, living, ax, ay, az, type);
        this.setTickLimit(400);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(dataMarker_colour, (Object)-1);
    }

    public void setColourSynced() {
        this.f_19804_.m_135381_(dataMarker_colour, (Object)this.colour);
    }

    public int getColourSynced() {
        return (Integer)this.f_19804_.m_135370_(dataMarker_colour);
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.colour < 0) {
            this.colour = this.getColourSynced();
        }
        if (this.f_19853_.f_46443_) {
            float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.getColour() & 0xFF) / 255.0f;
            this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            if (this.f_19797_ > 40) {
                for (int i = 0; i < 20; ++i) {
                    Vec3 v = new Vec3(Utils.RAND.nextDouble() - 0.5, Utils.RAND.nextDouble() - 0.5, Utils.RAND.nextDouble() - 0.5);
                    this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), this.m_20185_() + v.f_82479_, this.m_20186_() + v.f_82480_, this.m_20189_() + v.f_82481_, v.f_82479_ / 10.0, v.f_82480_ / 10.0, v.f_82481_ / 10.0);
                }
            }
        }
        if (this.f_19797_ == 40) {
            this.m_20334_(0.0, -0.1, 0.0);
            this.spawnParticles();
            this.lightPos = this.m_142538_();
            for (int i = 0; i < 128; ++i) {
                if (!this.f_19853_.m_46859_(this.lightPos)) {
                    this.lightPos = this.lightPos.m_6630_(6);
                    break;
                }
                this.lightPos = this.lightPos.m_7495_();
            }
        }
    }

    @Override
    public void m_6532_(HitResult mop) {
        if (this.f_19797_ <= 40) {
            if (!this.f_19853_.f_46443_) {
                BlockHitResult blockRTR;
                BlockPos pos;
                if (mop instanceof EntityHitResult) {
                    Entity hit = ((EntityHitResult)mop).m_82443_();
                    if (!hit.m_5825_()) {
                        hit.m_20254_(8);
                    }
                } else if (mop instanceof BlockHitResult && this.f_19853_.m_46859_(pos = (blockRTR = (BlockHitResult)mop).m_82425_().m_142300_(blockRTR.m_82434_()))) {
                    this.f_19853_.m_46597_(pos, Blocks.f_50083_.m_49966_());
                }
            }
            this.spawnParticles();
        }
        this.m_146870_();
    }

    private void spawnParticles() {
        float r = (float)(this.getColour() >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.getColour() >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.getColour() & 0xFF) / 255.0f;
        for (int i = 0; i < 80; ++i) {
            Vec3 v = new Vec3((Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0, (Utils.RAND.nextDouble() - 0.5) * (double)i > 40.0 ? 2.0 : 1.0);
            this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), 1.0f), this.m_20185_() + v.f_82479_, this.m_20186_() + v.f_82480_, this.m_20189_() + v.f_82481_, v.f_82479_ / 10.0, v.f_82480_ / 10.0, v.f_82481_ / 10.0);
        }
    }
}

