/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.AbstractCollection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;

public class ArcRecyclingRecipe
extends ArcFurnaceRecipe {
    private final Supplier<RegistryAccess> tags;
    private List<Pair<Lazy<ItemStack>, Double>> outputs;
    private final Lazy<NonNullList<ItemStack>> defaultOutputs = Lazy.of(() -> {
        NonNullList ret = NonNullList.m_122779_();
        for (Pair<Lazy<ItemStack>, Double> e : this.outputs) {
            double scaledOut = (Double)e.getSecond();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)ret, e);
        }
        return ret;
    });

    public ArcRecyclingRecipe(ResourceLocation id, Supplier<RegistryAccess> tags, List<Pair<Lazy<ItemStack>, Double>> outputs, IngredientWithSize input, int time, int energyPerTick) {
        super(id, (List)outputs.stream().map(Pair::getFirst).collect(NonNullList::m_122779_, List::add, AbstractCollection::addAll), (Lazy<ItemStack>)LAZY_EMPTY, (List<StackWithChance>)ImmutableList.of(), time, energyPerTick, input, new IngredientWithSize[0]);
        this.tags = tags;
        this.outputs = outputs;
        this.setSpecialRecipeType("Recycling");
    }

    @Override
    public NonNullList<ItemStack> generateActualOutput(ItemStack input, NonNullList<ItemStack> additives, long seed) {
        if (this.outputs == null) {
            return NonNullList.m_122779_();
        }
        float mod = !input.m_41763_() ? 1.0f : (float)(input.m_41776_() - input.m_41773_()) / (float)input.m_41776_();
        NonNullList outs = NonNullList.m_122779_();
        for (Pair<Lazy<ItemStack>, Double> e : this.outputs) {
            double scaledOut = (double)mod * (Double)e.getSecond();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)outs, e);
        }
        return outs;
    }

    @Override
    public NonNullList<ItemStack> getBaseOutputs() {
        return (NonNullList)this.defaultOutputs.get();
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return (NonNullList)this.defaultOutputs.get();
    }

    private void addOutputToList(double scaledOut, NonNullList<ItemStack> outs, Pair<Lazy<ItemStack>, Double> e) {
        String[] type;
        int nuggetOut;
        if (scaledOut >= 1.0) {
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)((Lazy)e.getFirst()).get()), (int)((int)scaledOut)));
        }
        if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) > 0 && (type = TagUtils.getMatchingPrefixAndRemaining(this.tags.get(), (ItemStack)((Lazy)e.getFirst()).get(), "ingots")) != null) {
            ItemStack nuggets = IEApi.getPreferredTagStack(this.tags.get(), TagUtils.createItemWrapper(IETags.getNugget(type[1])));
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)nuggets, (int)nuggetOut));
        }
    }

    @Override
    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        return !input.m_41619_() && this.input.test(input);
    }

    public List<Pair<Lazy<ItemStack>, Double>> getOutputs() {
        return this.outputs;
    }
}

