/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.MetalBarrelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WoodenBarrelBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IComparatorOverride {
    public static final int IGNITION_TEMPERATURE = 573;
    public EnumMap<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap(ImmutableMap.of((Object)Direction.DOWN, (Object)((Object)IEEnums.IOSideConfig.OUTPUT), (Object)Direction.UP, (Object)((Object)IEEnums.IOSideConfig.INPUT)));
    public FluidTank tank = new FluidTank(12000, this::isFluidValid);
    private final Map<Direction, CapabilityReference<IFluidHandler>> neighbors = ImmutableMap.of((Object)Direction.DOWN, CapabilityReference.forNeighbor((BlockEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN), (Object)Direction.UP, CapabilityReference.forNeighbor((BlockEntity)this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP));
    private final Map<Direction, ResettableCapability<IFluidHandler>> sidedFluidHandler = new HashMap<Direction, ResettableCapability<IFluidHandler>>();

    public WoodenBarrelBlockEntity(BlockEntityType<? extends WoodenBarrelBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.sidedFluidHandler.put(Direction.DOWN, this.registerCapability(new SidedFluidHandler(this, Direction.DOWN)));
        this.sidedFluidHandler.put(Direction.UP, this.registerCapability(new SidedFluidHandler(this, Direction.UP)));
        this.sidedFluidHandler.put(null, this.registerCapability(new SidedFluidHandler(this, null)));
    }

    public WoodenBarrelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends WoodenBarrelBlockEntity>)((BlockEntityType)IEBlockEntities.WOODEN_BARREL.get()), pos, state);
    }

    @Override
    public void tickServer() {
        boolean update = false;
        for (Direction side : this.neighbors.keySet()) {
            int accepted;
            FluidStack drained;
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig.get(side) != IEEnums.IOSideConfig.OUTPUT) continue;
            int out = Math.min(1000, this.tank.getFluidAmount());
            CapabilityReference<IFluidHandler> capRef = this.neighbors.get(side);
            IFluidHandler handler = capRef.getNullable();
            if (handler == null || (drained = this.tank.drain(accepted = handler.fill(Utils.copyFluidStackWithAmount(this.tank.getFluid(), out, false), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
            handler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            update = true;
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult rtr, boolean hammer) {
        if (rtr.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        if (Utils.isFluidRelatedItemStack(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return new Component[]{TextUtils.formatFluidStack(this.tank.getFluid())};
        }
        if (!(rtr instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult brtr = (BlockHitResult)rtr;
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && brtr.m_82434_().m_122434_() == Direction.Axis.Y) {
            IEEnums.IOSideConfig side = this.sideConfig.getOrDefault(brtr.m_82434_(), IEEnums.IOSideConfig.NONE);
            IEEnums.IOSideConfig opposite = this.sideConfig.getOrDefault(brtr.m_82434_().m_122424_(), IEEnums.IOSideConfig.NONE);
            return TextUtils.sideConfigWithOpposite("desc.immersiveengineering.info.blockSide.connectFluid.", side, opposite);
        }
        return null;
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] sideCfgArray = nbt.m_128465_("sideConfig");
        if (sideCfgArray.length < 2) {
            sideCfgArray = new int[]{-1, 0};
        }
        this.sideConfig.clear();
        for (int i = 0; i < sideCfgArray.length; ++i) {
            this.sideConfig.put(Direction.m_122376_((int)i), IEEnums.IOSideConfig.VALUES[sideCfgArray[i]]);
        }
        this.readTank(nbt);
    }

    public void readTank(CompoundTag nbt) {
        this.tank.readFromNBT(nbt.m_128469_("tank"));
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] sideCfgArray = new int[]{this.sideConfig.get(Direction.DOWN).ordinal(), this.sideConfig.get(Direction.UP).ordinal()};
        nbt.m_128385_("sideConfig", sideCfgArray);
        this.writeTank(nbt, false);
    }

    public void writeTank(CompoundTag nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
        if (!toItem || write) {
            nbt.m_128365_("tank", (Tag)tankTag);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.sidedFluidHandler.containsKey(facing)) {
            return this.sidedFluidHandler.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean isFluidValid(FluidStack fluid) {
        return !fluid.isEmpty() && fluid.getFluid().getAttributes().getTemperature(fluid) < 573 && !fluid.getFluid().getAttributes().isGaseous(fluid);
    }

    @Override
    public IEEnums.IOSideConfig getSideConfig(Direction side) {
        return this.sideConfig.getOrDefault(side, IEEnums.IOSideConfig.NONE);
    }

    @Override
    public boolean toggleSide(Direction side, Player p) {
        if (side.m_122434_() != Direction.Axis.Y) {
            return false;
        }
        this.sideConfig.compute(side, (s, config) -> IEEnums.IOSideConfig.next(config));
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
        return true;
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        Optional<Boolean> ret;
        Optional fOptional = FluidUtil.getFluidContained((ItemStack)heldItem);
        boolean metal = this instanceof MetalBarrelBlockEntity;
        if (!metal && (ret = fOptional.map(f -> {
            if (f.getFluid().getAttributes().isGaseous(f)) {
                ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.noGasAllowed")});
                return true;
            }
            if (f.getFluid().getAttributes().getTemperature(f) >= 573) {
                ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.tooHot")});
                return true;
            }
            return false;
        })).orElse(false).booleanValue()) {
            return true;
        }
        if (FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.tank)) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag tag = new CompoundTag();
        this.writeTank(tag, true);
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.readTank(stack.m_41784_());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return (int)(15.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity()));
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        WoodenBarrelBlockEntity barrel;
        @Nullable
        Direction facing;

        SidedFluidHandler(WoodenBarrelBlockEntity barrel, @Nullable Direction facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource.isEmpty() || this.facing != null && this.barrel.sideConfig.get(this.facing) != IEEnums.IOSideConfig.INPUT || !this.barrel.isFluidValid(resource)) {
                return 0;
            }
            int i = this.barrel.tank.fill(resource, doFill);
            if (i > 0 && doFill.execute()) {
                this.barrel.m_6596_();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), doDrain);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (this.facing != null && this.barrel.sideConfig.get(this.facing) != IEEnums.IOSideConfig.OUTPUT) {
                return FluidStack.EMPTY;
            }
            FluidStack f = this.barrel.tank.drain(maxDrain, doDrain);
            if (!f.isEmpty()) {
                this.barrel.m_6596_();
                this.barrel.markContainingBlockForUpdate(null);
            }
            return f;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.barrel.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.barrel.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.barrel.tank.isFluidValid(tank, stack);
        }
    }
}

