/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MultiblockProcessInWorld<R extends MultiblockRecipe>
extends MultiblockProcess<R> {
    public NonNullList<ItemStack> inputItems;
    protected float transformationPoint;

    public MultiblockProcessInWorld(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, float transformationPoint, NonNullList<ItemStack> inputItem) {
        super(recipeId, getRecipe);
        this.inputItems = inputItem;
        this.transformationPoint = transformationPoint;
    }

    public MultiblockProcessInWorld(R recipe, BiFunction<Level, ResourceLocation, R> getRecipe, float transformationPoint, NonNullList<ItemStack> inputItem) {
        super(recipe, getRecipe);
        this.inputItems = inputItem;
        this.transformationPoint = transformationPoint;
    }

    public List<ItemStack> getDisplayItem(Level level) {
        NonNullList<ItemStack> list;
        MultiblockProcess.LevelDependentData levelData = this.getLevelData(level);
        if ((float)this.processTick / (float)levelData.maxTicks() > this.transformationPoint && levelData.recipe() != null && !(list = ((MultiblockRecipe)levelData.recipe()).getItemOutputs()).isEmpty()) {
            return list;
        }
        return this.inputItems;
    }

    public static <R extends MultiblockRecipe> MultiblockProcessInWorld<R> load(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
        NonNullList inputs = NonNullList.m_122780_((int)data.m_128451_("numInputs"), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)data, (NonNullList)inputs);
        float transformationPoint = data.m_128457_("process_transformationPoint");
        return new MultiblockProcessInWorld<ResourceLocation>(recipeId, (BiFunction<Level, ResourceLocation, ResourceLocation>)getRecipe, transformationPoint, (NonNullList<ItemStack>)inputs);
    }

    @Override
    public void writeExtraDataToNBT(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inputItems);
        nbt.m_128405_("numInputs", this.inputItems.size());
        nbt.m_128350_("process_transformationPoint", this.transformationPoint);
    }

    @Override
    protected void processFinish(PoweredMultiblockBlockEntity<?, R> multiblock) {
        super.processFinish(multiblock);
        int size = -1;
        Object recipe = this.getLevelData(multiblock.m_58904_()).recipe();
        if (recipe == null) {
            return;
        }
        for (ItemStack inputItem : this.inputItems) {
            for (IngredientWithSize s : ((MultiblockRecipe)recipe).getItemInputs()) {
                if (!s.test(inputItem)) continue;
                size = s.getCount();
                break;
            }
            if (size <= 0 || inputItem.m_41613_() <= size) continue;
            inputItem.m_41620_(size);
            this.processTick = 0;
            this.clearProcess = false;
        }
    }
}

