/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultiblockProcessInMachine<R extends MultiblockRecipe>
extends MultiblockProcess<R> {
    protected final int[] inputSlots;
    protected int[] inputAmounts = null;
    protected int[] inputTanks = new int[0];

    public MultiblockProcessInMachine(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, int ... inputSlots) {
        super(recipeId, getRecipe);
        this.inputSlots = inputSlots;
    }

    public MultiblockProcessInMachine(R recipe, BiFunction<Level, ResourceLocation, R> getRecipe, int ... inputSlots) {
        super(recipe, getRecipe);
        this.inputSlots = inputSlots;
    }

    public MultiblockProcessInMachine<R> setInputTanks(int ... inputTanks) {
        this.inputTanks = inputTanks;
        return this;
    }

    public MultiblockProcessInMachine<R> setInputAmounts(int ... inputAmounts) {
        this.inputAmounts = inputAmounts;
        return this;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    @Nullable
    public int[] getInputAmounts() {
        return this.inputAmounts;
    }

    public int[] getInputTanks() {
        return this.inputTanks;
    }

    protected List<IngredientWithSize> getRecipeItemInputs(PoweredMultiblockBlockEntity<?, R> multiblock) {
        Object recipe = this.getLevelData(multiblock.m_58904_()).recipe();
        return recipe == null ? List.of() : ((MultiblockRecipe)recipe).getItemInputs();
    }

    protected List<FluidTagInput> getRecipeFluidInputs(PoweredMultiblockBlockEntity<?, R> multiblock) {
        Object recipe = this.getLevelData(multiblock.m_58904_()).recipe();
        return recipe == null ? List.of() : ((MultiblockRecipe)recipe).getFluidInputs();
    }

    @Override
    public void doProcessTick(PoweredMultiblockBlockEntity<?, R> multiblock) {
        Object recipe = this.getLevelData(multiblock.m_58904_()).recipe();
        if (recipe == null) {
            return;
        }
        NonNullList inv = multiblock.getInventory();
        if (recipe.shouldCheckItemAvailability() && ((MultiblockRecipe)recipe).getItemInputs() != null && inv != null) {
            NonNullList query = NonNullList.m_122780_((int)this.inputSlots.length, (Object)ItemStack.f_41583_);
            for (int i = 0; i < this.inputSlots.length; ++i) {
                if (this.inputSlots[i] < 0 || this.inputSlots[i] >= inv.size()) continue;
                query.set(i, (Object)((ItemStack)multiblock.getInventory().get(this.inputSlots[i])));
            }
            if (!IngredientUtils.stacksMatchIngredientWithSizeList(((MultiblockRecipe)recipe).getItemInputs(), (NonNullList<ItemStack>)query)) {
                this.clearProcess = true;
                return;
            }
        }
        super.doProcessTick(multiblock);
    }

    @Override
    protected void processFinish(PoweredMultiblockBlockEntity<?, R> multiblock) {
        super.processFinish(multiblock);
        NonNullList inv = multiblock.getInventory();
        List<IngredientWithSize> itemInputList = this.getRecipeItemInputs(multiblock);
        if (inv != null && this.inputSlots != null && itemInputList != null) {
            if (this.inputAmounts != null && this.inputSlots.length == this.inputAmounts.length) {
                for (int i = 0; i < this.inputSlots.length; ++i) {
                    if (this.inputAmounts[i] <= 0) continue;
                    ((ItemStack)inv.get(this.inputSlots[i])).m_41774_(this.inputAmounts[i]);
                }
            } else {
                block1: for (IngredientWithSize ingr : new ArrayList<IngredientWithSize>(itemInputList)) {
                    int ingrSize = ingr.getCount();
                    for (int slot : this.inputSlots) {
                        if (((ItemStack)inv.get(slot)).m_41619_() || !ingr.test((ItemStack)inv.get(slot))) continue;
                        int taken = Math.min(((ItemStack)inv.get(slot)).m_41613_(), ingrSize);
                        ((ItemStack)inv.get(slot)).m_41774_(taken);
                        if (((ItemStack)inv.get(slot)).m_41613_() <= 0) {
                            inv.set(slot, (Object)ItemStack.f_41583_);
                        }
                        if ((ingrSize -= taken) <= 0) continue block1;
                    }
                }
            }
        }
        IFluidTank[] tanks = multiblock.getInternalTanks();
        List<FluidTagInput> fluidInputList = this.getRecipeFluidInputs(multiblock);
        if (tanks != null && this.inputTanks != null && fluidInputList != null) {
            block3: for (FluidTagInput ingr : new ArrayList<FluidTagInput>(fluidInputList)) {
                int ingrSize = ingr.getAmount();
                for (int tank : this.inputTanks) {
                    if (tanks[tank] == null || !ingr.testIgnoringAmount(tanks[tank].getFluid())) continue;
                    int taken = Math.min(tanks[tank].getFluidAmount(), ingrSize);
                    tanks[tank].drain(taken, IFluidHandler.FluidAction.EXECUTE);
                    if ((ingrSize -= taken) <= 0) continue block3;
                }
            }
        }
    }

    public static <R extends MultiblockRecipe> MultiblockProcessInMachine<R> load(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
        return new MultiblockProcessInMachine<ResourceLocation>(recipeId, (BiFunction<Level, ResourceLocation, ResourceLocation>)getRecipe, data.m_128465_("process_inputSlots")).setInputAmounts(data.m_128465_("process_inputAmounts")).setInputTanks(data.m_128465_("process_inputTanks"));
    }

    @Override
    public void writeExtraDataToNBT(CompoundTag nbt) {
        if (this.inputSlots != null) {
            nbt.m_128385_("process_inputSlots", this.inputSlots);
        }
        if (this.inputAmounts != null) {
            nbt.m_128385_("process_inputAmounts", this.inputAmounts);
        }
        if (this.inputTanks != null) {
            nbt.m_128385_("process_inputTanks", this.inputTanks);
        }
    }
}

