/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SiloBlockEntity
extends MultiblockPartBlockEntity<SiloBlockEntity>
implements IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IBlockBounds {
    public ItemStack identStack = ItemStack.f_41583_;
    public int storageAmount = 0;
    private static final int MAX_STORAGE = 41472;
    boolean lockItem = false;
    private final LayeredComparatorOutput comparatorHelper = new LayeredComparatorOutput(41472.0, 6, () -> this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_()), layer -> {
        BlockPos masterPos = this.f_58858_.m_141950_((Vec3i)this.offsetToMaster);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos pos = masterPos.m_142082_(x, layer + 1, z);
                this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
            }
        }
    });
    private final Map<Direction, CapabilityReference<IItemHandler>> outputCaps = CapabilityReference.forAllNeighbors(this, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private static final CachedShapesWithTransform<BlockPos, Direction> BLOCK_BOUNDS = CachedShapesWithTransform.createDirectional(pos -> {
        if (pos.m_123341_() % 2 == 0 && pos.m_123342_() == 0 && pos.m_123343_() % 2 == 0) {
            float xMin = pos.m_123341_() == 2 ? 0.75f : 0.0f;
            float xMax = pos.m_123341_() == 0 ? 0.25f : 1.0f;
            float zMin = pos.m_123343_() == 2 ? 0.75f : 0.0f;
            float zMax = pos.m_123343_() == 0 ? 0.25f : 1.0f;
            return ImmutableList.of((Object)new AABB((double)xMin, 0.0, (double)zMin, (double)xMax, 1.0, (double)zMax));
        }
        return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    });
    private AABB renderAABB;
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new SiloInventoryHandler()));
    private static final BlockPos bottomIoOffset = new BlockPos(1, 0, 1);
    private static final BlockPos topIoOffset = new BlockPos(1, 6, 1);
    private static final Set<BlockPos> ioOffsets = ImmutableSet.of((Object)bottomIoOffset, (Object)topIoOffset);

    public SiloBlockEntity(BlockEntityType<SiloBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.SILO, type, true, pos, state);
        this.redstoneControlInverted = true;
        this.outputCaps.remove(Direction.UP);
    }

    @Override
    public void tickServer() {
        if (!this.identStack.m_41619_() && this.storageAmount > 0 && this.f_58857_.m_46467_() % 8L == 0L && !this.isRSDisabled()) {
            for (CapabilityReference<IItemHandler> output : this.outputCaps.values()) {
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.identStack, (int)1);
                if (!(stack = Utils.insertStackIntoInventory(output, stack, false)).m_41619_()) continue;
                --this.storageAmount;
                if (this.storageAmount <= 0) {
                    this.identStack = ItemStack.f_41583_;
                }
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
                if (this.storageAmount > 0) continue;
                break;
            }
        }
        this.comparatorHelper.update(this.storageAmount);
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(1, 0, 1));
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.m_128425_("identStack", 10)) {
            CompoundTag t = nbt.m_128469_("identStack");
            this.identStack = ItemStack.m_41712_((CompoundTag)t);
        } else {
            this.identStack = ItemStack.f_41583_;
        }
        this.storageAmount = nbt.m_128451_("storageAmount");
        this.lockItem = nbt.m_128471_("lockItem");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.identStack.m_41619_()) {
            CompoundTag t = this.identStack.m_41739_(new CompoundTag());
            nbt.m_128365_("identStack", (Tag)t);
        }
        nbt.m_128405_("storageAmount", this.storageAmount);
        nbt.m_128379_("lockItem", this.lockItem);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return BLOCK_BOUNDS.get(this.posInMultiblock, this.getFacing());
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offsetToMaster.equals((Object)BlockPos.f_121853_) ? new AABB(this.m_58899_().m_142082_(-1, 0, -1), this.m_58899_().m_142082_(2, 7, 2)) : new AABB(this.m_58899_(), this.m_58899_());
        }
        return this.renderAABB;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ioOffsets.contains(this.posInMultiblock) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getComparatorInputOverride() {
        if (bottomIoOffset.equals((Object)this.posInMultiblock)) {
            return this.comparatorHelper.getCurrentMasterOutput();
        }
        SiloBlockEntity master = (SiloBlockEntity)this.master();
        if (this.offsetToMaster.m_123342_() >= 1 && master != null) {
            return this.comparatorHelper.getLayerOutput(this.offsetToMaster.m_123342_() - 1);
        }
        return 0;
    }

    public class SiloInventoryHandler
    implements IItemHandler {
        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)SiloBlockEntity.this.identStack, (int)SiloBlockEntity.this.storageAmount);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int space = 41472 - SiloBlockEntity.this.storageAmount;
            if (slot != 0 || space < 1 || stack.m_41619_() || !SiloBlockEntity.this.identStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)SiloBlockEntity.this.identStack, (ItemStack)stack)) {
                return stack;
            }
            int accepted = Math.min(space, stack.m_41613_());
            if (!simulate) {
                SiloBlockEntity.this.storageAmount += accepted;
                if (SiloBlockEntity.this.identStack.m_41619_()) {
                    SiloBlockEntity.this.identStack = stack.m_41777_();
                }
                SiloBlockEntity.this.m_6596_();
                SiloBlockEntity.this.markContainingBlockForUpdate(null);
            }
            stack = stack.m_41777_();
            stack.m_41774_(accepted);
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1 || SiloBlockEntity.this.storageAmount < 1 || amount < 1 || SiloBlockEntity.this.identStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int returned = Math.min(Math.min(SiloBlockEntity.this.storageAmount, amount), SiloBlockEntity.this.identStack.m_41741_());
            ItemStack out = ItemHandlerHelper.copyStackWithSize((ItemStack)SiloBlockEntity.this.identStack, (int)returned);
            if (!simulate) {
                SiloBlockEntity.this.storageAmount -= out.m_41613_();
                if (SiloBlockEntity.this.storageAmount <= 0 && !SiloBlockEntity.this.lockItem) {
                    SiloBlockEntity.this.identStack = ItemStack.f_41583_;
                }
                SiloBlockEntity.this.m_6596_();
                SiloBlockEntity.this.markContainingBlockForUpdate(null);
            }
            return out;
        }

        public int getSlotLimit(int slot) {
            return 41472;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }
    }
}

