/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FermenterBlockEntity
extends PoweredMultiblockBlockEntity<FermenterBlockEntity, FermenterRecipe>
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IInteractionObjectIE<FermenterBlockEntity> {
    public final FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)11, (Object)ItemStack.f_41583_);
    private final CapabilityReference<IItemHandler> outputCap = CapabilityReference.forBlockEntityAt(this, () -> {
        Direction fw = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        return new DirectionalBlockPos(this.m_58899_().m_142300_(fw), fw.m_122424_());
    }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(FermenterBlockEntity::getShape);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(8, (IIEInventory)this, 0, new boolean[]{true, true, true, true, true, true, true, true}, new boolean[8])));
    private final MultiblockCapability<IItemHandler> extractionHandler = MultiblockCapability.make(this, be -> be.extractionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(1, (IIEInventory)this, 8, new boolean[1], new boolean[]{true})));
    private final MultiblockCapability<IFluidHandler> fluidCap = MultiblockCapability.make(this, be -> be.fluidCap, MultiblockPartBlockEntity::master, this.registerFluidOutput((IFluidTank[])this.tanks));
    private static final PoweredMultiblockBlockEntity.MultiblockFace FLUID_OUTPUT = new PoweredMultiblockBlockEntity.MultiblockFace(2, 0, 1, RelativeBlockFace.RIGHT);

    public FermenterBlockEntity(BlockEntityType<FermenterBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.FERMENTER, 16000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tanks[0].readFromNBT(nbt.m_128469_("tank"));
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128365_("tank", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void tickServer() {
        IItemHandler outputHandler;
        super.tickServer();
        if (this.isRSDisabled()) {
            return;
        }
        boolean update = false;
        if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength()) {
            int n;
            Integer[] process2;
            int[] usedInvSlots = new int[8];
            for (Integer[] process2 : this.processQueue) {
                if (!(process2 instanceof MultiblockProcessInMachine)) continue;
                int[] nArray = ((MultiblockProcessInMachine)process2).getInputSlots();
                n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2;
                    int n2 = i2 = nArray[i];
                    usedInvSlots[n2] = usedInvSlots[n2] + 1;
                }
            }
            Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
            Arrays.sort(preferredSlots, 0, 8, Comparator.comparingInt(arg0 -> usedInvSlots[arg0]));
            process2 = preferredSlots;
            int n3 = process2.length;
            for (n = 0; n < n3; ++n) {
                MultiblockProcessInMachine<FermenterRecipe> process3;
                FermenterRecipe recipe;
                int slot = process2[n];
                ItemStack stack = (ItemStack)this.getInventory().get(slot);
                if (!stack.m_41619_()) {
                    stack = stack.m_41777_();
                    stack.m_41774_(usedInvSlots[slot]);
                }
                if (stack.m_41619_() || stack.m_41613_() <= 0 || (recipe = this.findRecipeForInsertion(stack)) == null || !this.addProcessToQueue(process3 = new MultiblockProcessInMachine<FermenterRecipe>(recipe, this::getRecipeForId, slot), true)) continue;
                this.addProcessToQueue(process3, false);
                update = true;
            }
        }
        Direction fw = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        update |= FluidUtils.multiblockFluidOutput(this.f_58857_, this.m_58899_().m_142082_(0, -1, 0).m_5484_(fw, 2), fw, this.tanks[0], 9, 10, arg_0 -> this.inventory.get(arg_0), (arg_0, arg_1) -> this.inventory.set(arg_0, arg_1));
        if (!((ItemStack)this.inventory.get(8)).m_41619_() && this.f_58857_.m_46467_() % 8L == 0L && (outputHandler = this.outputCap.getNullable()) != null) {
            ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.inventory.get(8)), (int)1);
            if ((stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) {
                ((ItemStack)this.inventory.get(8)).m_41774_(1);
            }
        }
        if (update) {
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (new BlockPos(2, 0, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875), (Object)new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
        }
        if (new BoundingBox(0, 0, 0, 1, 0, 1).m_71051_((Vec3i)posInMultiblock)) {
            List<AABB> list = Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 1, new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.0625, 0.5, 0.6875, 0.3125, 1.1875, 0.9375));
            if (new BlockPos(1, 0, 1).equals((Object)posInMultiblock)) {
                list.add(new AABB(0.0, 0.5, 0.375, 1.125, 0.75, 0.625));
                list.add(new AABB(0.875, 0.5, -0.125, 1.125, 0.75, 0.375));
                list.add(new AABB(0.875, 0.75, -0.125, 1.125, 1.0, 0.125));
            }
            return list;
        }
        if (new BoundingBox(0, 1, 0, 1, 2, 1).m_71051_((Vec3i)posInMultiblock)) {
            float minY = posInMultiblock.m_123342_() < 2 ? 0.1875f : -0.8125f;
            float maxY = posInMultiblock.m_123342_() < 2 ? 2.0f : 1.0f;
            return Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 1, new AABB(0.0625, (double)minY, 0.0, 1.0, (double)maxY, 0.9375));
        }
        AABB ret = posInMultiblock.m_123342_() == 0 && !ImmutableSet.of((Object)new BlockPos(2, 0, 1), (Object)new BlockPos(0, 0, 2)).contains((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0) : (new BlockPos(2, 1, 2).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0) : new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        return ImmutableList.of((Object)ret);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(0, 1, 2, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(2, 1, 2));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<FermenterRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).m_41619_()) {
            Utils.dropStackAtPos(this.f_58857_, this.m_58899_().m_5484_(this.getFacing(), 2), output, this.getFacing());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<FermenterRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 8;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 8;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<FermenterRecipe> process) {
        return 0.0f;
    }

    @Override
    public int getComparatedSize() {
        return 8;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{8};
    }

    @Override
    public int[] getOutputTanks() {
        return new int[]{0};
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || FLUID_OUTPUT.equals(this.asRelativeFace(facing)))) {
            return this.fluidCap.getAndCast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (new BlockPos(0, 1, 0).equals((Object)this.posInMultiblock)) {
                return this.insertionHandler.getAndCast();
            }
            if (new BlockPos(1, 1, 1).equals((Object)this.posInMultiblock)) {
                return this.extractionHandler.getAndCast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public FermenterRecipe findRecipeForInsertion(ItemStack inserting) {
        return FermenterRecipe.findRecipe(this.f_58857_, inserting);
    }

    @Override
    protected FermenterRecipe getRecipeForId(Level level, ResourceLocation id) {
        return FermenterRecipe.RECIPES.getById(level, id);
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public FermenterBlockEntity getGuiMaster() {
        return (FermenterBlockEntity)this.master();
    }

    @Override
    public IEContainerTypes.BEContainer<FermenterBlockEntity, ?> getContainerType() {
        return IEContainerTypes.FERMENTER;
    }
}

