/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class DynamoBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional {
    private final ResettableCapability<IEnergyStorage> energyCap = this.registerCapability(NullEnergyStorage.INSTANCE);
    private final ResettableCapability<IRotationAcceptor> rotationCap = this.registerCapability(new RotationAcceptor());
    private final Map<Direction, CapabilityReference<IEnergyStorage>> neighbors = CapabilityReference.forAllNeighbors(this, CapabilityEnergy.ENERGY);

    public DynamoBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.DYNAMO.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == IRotationAcceptor.CAPABILITY && side == this.getFacing()) {
            return this.rotationCap.cast();
        }
        return super.getCapability(cap, side);
    }

    private class RotationAcceptor
    implements IRotationAcceptor {
        private RotationAcceptor() {
        }

        @Override
        public void inputRotation(double rotation) {
            int output = (int)((Double)IEServerConfig.MACHINES.dynamo_output.get() * rotation);
            for (CapabilityReference<IEnergyStorage> neighbor : DynamoBlockEntity.this.neighbors.values()) {
                IEnergyStorage capOnSide = neighbor.getNullable();
                if (capOnSide != null) {
                    output -= capOnSide.receiveEnergy(output, false);
                }
                if (output > 0) continue;
                break;
            }
        }
    }
}

